/*
 * Decompiled with CFR 0.152.
 */
package com.wily.util.xml;

import com.wily.util.feedback.IModuleFeedbackChannel;
import com.wily.util.locale.LocaleUtils;
import com.wily.util.text.IStringLocalizer;
import com.wily.util.xml.BadlyFormedXMLException;
import com.wily.util.xml.BasicXMLErrorHandler;
import com.wily.util.xml.XMLQualifier;
import com.wily.utilities.properties.Messages;
import com.wily.wilyassert.Assertion;
import java.awt.Color;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import java.util.Vector;
import javax.xml.parsers.DocumentBuilder;
import javax.xml.parsers.DocumentBuilderFactory;
import javax.xml.parsers.ParserConfigurationException;
import javax.xml.transform.Transformer;
import javax.xml.transform.TransformerConfigurationException;
import javax.xml.transform.TransformerException;
import javax.xml.transform.TransformerFactory;
import javax.xml.transform.dom.DOMSource;
import javax.xml.transform.stream.StreamResult;
import javax.xml.transform.stream.StreamSource;
import org.w3c.dom.DOMImplementation;
import org.w3c.dom.Document;
import org.w3c.dom.DocumentType;
import org.w3c.dom.Element;
import org.w3c.dom.Node;
import org.w3c.dom.NodeList;
import org.w3c.dom.Text;
import org.xml.sax.EntityResolver;
import org.xml.sax.InputSource;
import org.xml.sax.SAXException;

public class XMLAssistant {
    private static final String kXmlnsXSI = "xmlns:xsi";
    private static final String kXSINoNamespaceSchemaLocation = "xsi:noNamespaceSchemaLocation";
    private static final String kSuperDocumentName = "SuperDocument";
    private static final String kSuperDocumentRootElementName = "SuperDocument";
    private static final String kSchemaValidationFeature = "http://apache.org/xml/features/validation/schema";
    private static final String kJAXPSchemaLanguage = "http://java.sun.com/xml/jaxp/properties/schemaLanguage";
    private static final String kW3CXMLSchema = "http://www.w3.org/2001/XMLSchema-instance";
    private static final String kMissingResourceError = "!Missing Resource!";
    static /* synthetic */ Class class$0;

    public static Element createDOMElementForInteger(Document doc, String elementName, int intValue) {
        return XMLAssistant.createDOMElementForString(doc, elementName, Integer.toString(intValue));
    }

    public static Element createDOMElementForDouble(Document doc, String elementName, double doubleValue) {
        return XMLAssistant.createDOMElementForString(doc, elementName, Double.toString(doubleValue));
    }

    public static Element createDOMElementForLong(Document doc, String elementName, long longValue) {
        return XMLAssistant.createDOMElementForString(doc, elementName, Long.toString(longValue));
    }

    public static Element createDOMElementForString(Document doc, String elementName, String stringValue) {
        if (stringValue == null) {
            stringValue = "";
        }
        Element newElement = doc.createElement(elementName);
        Text newText = doc.createTextNode(stringValue);
        newElement.appendChild(newText);
        return newElement;
    }

    public static Element createDOMElementForBoolean(Document doc, String elementName, boolean booleanValue) {
        String booleanAsString = new Boolean(booleanValue).toString();
        return XMLAssistant.createDOMElementForString(doc, elementName, booleanAsString);
    }

    public static int parseDOMElementAsInteger(Element element, String expectedElementName) throws BadlyFormedXMLException {
        XMLQualifier.qualifyName(element, expectedElementName);
        String elementValue = element.getFirstChild().getNodeValue();
        return Integer.parseInt(elementValue);
    }

    public static double parseDOMElementAsDouble(Element element, String expectedElementName) throws BadlyFormedXMLException {
        XMLQualifier.qualifyName(element, expectedElementName);
        String elementValue = element.getFirstChild().getNodeValue();
        return Double.valueOf(elementValue);
    }

    public static long parseDOMElementAsLong(Element element, String expectedElementName) throws BadlyFormedXMLException {
        XMLQualifier.qualifyName(element, expectedElementName);
        String elementValue = element.getFirstChild().getNodeValue();
        return Long.valueOf(elementValue);
    }

    public static String parseDOMElementAsString(Element element, String expectedElementName) throws BadlyFormedXMLException {
        XMLQualifier.qualifyName(element, expectedElementName);
        String elementValue = null;
        Node contentNode = element.getFirstChild();
        if (contentNode != null) {
            elementValue = contentNode.getNodeValue();
        }
        return elementValue;
    }

    public static boolean parseDOMElementAsBoolean(Element element, String expectedElementName) throws BadlyFormedXMLException {
        String stringValue = XMLAssistant.parseDOMElementAsString(element, expectedElementName);
        return Boolean.valueOf(stringValue);
    }

    public static Document getDocument(String schemaFile, String rootNodeName) throws ParserConfigurationException {
        DocumentBuilderFactory factory = DocumentBuilderFactory.newInstance();
        factory.setValidating(true);
        factory.setNamespaceAware(true);
        Document document = factory.newDocumentBuilder().newDocument();
        Element root = document.createElement(rootNodeName);
        root.setAttribute(kXmlnsXSI, kW3CXMLSchema);
        root.setAttribute(kXSINoNamespaceSchemaLocation, schemaFile);
        document.appendChild(root);
        return document;
    }

    public static DOMImplementation getDOMImplementation() {
        DOMImplementation implementation = null;
        try {
            implementation = DocumentBuilderFactory.newInstance().newDocumentBuilder().getDOMImplementation();
        }
        catch (ParserConfigurationException parserConfigurationException) {
            Assertion.unimplemented(Messages.getString("XMLAssistant.ParsingConfigErrorMsg_Log"));
        }
        return implementation;
    }

    /*
     * WARNING - Removed back jump from a try to a catch block - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public static void serializeDocument(Document xmlDoc, File file) throws IOException {
        FileOutputStream fos = new FileOutputStream(file);
        try {
            XMLAssistant.serializeDocument(xmlDoc, fos);
        }
        catch (Throwable throwable) {
            Object var3_4 = null;
            fos.close();
            throw throwable;
        }
        {
            Object var3_5 = null;
        }
        fos.close();
    }

    public static void serializeDocument(Document xmlDoc, OutputStream stream) throws IOException {
        TransformerFactory transformerFactory = TransformerFactory.newInstance();
        Document document = xmlDoc;
        Transformer transformer = null;
        try {
            Class<?> clazz = class$0;
            if (clazz == null) {
                try {
                    clazz = class$0 = Class.forName("com.wily.util.xml.XMLAssistant");
                }
                catch (ClassNotFoundException classNotFoundException) {
                    throw new NoClassDefFoundError(classNotFoundException.getMessage());
                }
            }
            StreamSource xslSource = new StreamSource(clazz.getResourceAsStream("pretty.xsl"));
            transformer = transformerFactory.newTransformer(xslSource);
            if (xmlDoc.getDoctype() != null) {
                transformer.setOutputProperty("doctype-system", xmlDoc.getDoctype().getSystemId());
            }
        }
        catch (TransformerConfigurationException e) {
            throw new IOException(String.valueOf(Messages.getString("XMLAssistant.TransformerFactoryError_Log")) + e);
        }
        StreamResult output = new StreamResult(stream);
        try {
            transformer.transform(new DOMSource(document), output);
        }
        catch (TransformerException e) {
            throw new IOException(String.valueOf(Messages.getString("XMLAssistant.TransformationError_Log")) + e);
        }
    }

    public static Document parseDocumentThroughUTF8(File file, boolean validate) throws IOException, SAXException, ParserConfigurationException {
        return XMLAssistant.parseDocument(file, validate);
    }

    public static Document parseDocument(File file, boolean validate) throws IOException, SAXException, ParserConfigurationException {
        return XMLAssistant.parseDocument(new FileInputStream(file), validate, null, null);
    }

    public static Document parseDocument(InputStream inputStream, boolean validate) throws IOException, SAXException, ParserConfigurationException {
        return XMLAssistant.parseDocument(inputStream, validate, null, null);
    }

    public static Document parseDocumentThroughUTF8(File file, boolean validate, EntityResolver entityResolver) throws IOException, SAXException, ParserConfigurationException {
        return XMLAssistant.parseDocument(file, validate, entityResolver);
    }

    public static Document parseDocument(File file, boolean validate, EntityResolver entityResolver) throws IOException, SAXException, ParserConfigurationException {
        return XMLAssistant.parseDocument(new FileInputStream(file), validate, entityResolver, null);
    }

    public static Document parseDocumentThroughUTF8(InputStream inputStream, boolean validate, EntityResolver entityResolver) throws IOException, SAXException, ParserConfigurationException {
        return XMLAssistant.parseDocument(inputStream, validate, entityResolver);
    }

    public static Document parseDocument(InputStream inputStream, boolean validate, EntityResolver entityResolver) throws IOException, SAXException, ParserConfigurationException {
        return XMLAssistant.parseDocument(inputStream, validate, entityResolver, null);
    }

    public static Document parseDocumentThroughUTF8(File file, boolean validate, EntityResolver entityResolver, IModuleFeedbackChannel moduleFeedback, IStringLocalizer stringLocalizer) throws IOException, SAXException, ParserConfigurationException {
        return XMLAssistant.parseDocument(file, validate, entityResolver, moduleFeedback);
    }

    public static Document parseDocument(File file, boolean validate, EntityResolver entityResolver, IModuleFeedbackChannel moduleFeedback) throws IOException, SAXException, ParserConfigurationException {
        return XMLAssistant.parseDocument(new FileInputStream(file), validate, entityResolver, moduleFeedback);
    }

    public static Document parseDocumentThroughUTF8(InputStream inputStream, boolean validate, EntityResolver entityResolver, IModuleFeedbackChannel moduleFeedback, IStringLocalizer stringLocalizer) throws IOException, SAXException, ParserConfigurationException {
        return XMLAssistant.parseDocument(inputStream, validate, entityResolver, moduleFeedback);
    }

    public static Document parseDocument(InputStream inputStream, boolean validate, EntityResolver entityResolver, IModuleFeedbackChannel moduleFeedback) throws IOException, SAXException, ParserConfigurationException {
        return XMLAssistant.parseDocument(inputStream, validate, entityResolver, moduleFeedback, Collections.EMPTY_MAP);
    }

    public static Document parseDocument(InputStream inputStream, boolean validate, EntityResolver entityResolver, IModuleFeedbackChannel moduleFeedback, Map factoryProperties) throws IOException, SAXException, ParserConfigurationException {
        Document document = null;
        DocumentBuilderFactory factory = DocumentBuilderFactory.newInstance();
        if (validate) {
            factory.setValidating(true);
            factory.setAttribute(kSchemaValidationFeature, new Boolean(true));
            factory.setAttribute(kJAXPSchemaLanguage, kW3CXMLSchema);
            Iterator iter = factoryProperties.entrySet().iterator();
            while (iter.hasNext()) {
                Map.Entry entry = iter.next();
                factory.setAttribute((String)entry.getKey(), entry.getValue());
            }
            factory.setNamespaceAware(true);
        }
        DocumentBuilder builder = factory.newDocumentBuilder();
        if (validate) {
            builder.setErrorHandler(new BasicXMLErrorHandler(false, false, moduleFeedback));
        }
        if (entityResolver != null) {
            builder.setEntityResolver(entityResolver);
        }
        document = builder.parse(new InputSource(inputStream));
        return document;
    }

    public static Document createSuperDocument(Document[] subDocuments) throws ParserConfigurationException {
        Assertion.wilyAssert(subDocuments != null);
        DOMImplementation implementation = null;
        DocumentType superDocumentType = null;
        Document superDocument = null;
        Element superDocumentRoot = null;
        Element currentSubDocumentRoot = null;
        if (subDocuments.length != 0) {
            implementation = XMLAssistant.getDOMImplementation();
            superDocumentType = implementation.createDocumentType("SuperDocument", null, null);
            superDocument = implementation.createDocument(subDocuments[0].getNamespaceURI(), "SuperDocument", superDocumentType);
            superDocumentRoot = superDocument.getDocumentElement();
            int i = 0;
            while (i < subDocuments.length) {
                currentSubDocumentRoot = subDocuments[i].getDocumentElement();
                superDocumentRoot.appendChild(superDocument.importNode(currentSubDocumentRoot, true));
                ++i;
            }
        }
        return superDocument;
    }

    public static Document[] createSubDocuments(Document superDocument, DocumentType documentTypeTemplate) throws ParserConfigurationException {
        Assertion.wilyAssert(superDocument != null);
        Assertion.wilyAssert(superDocument.getDocumentElement() != null);
        DOMImplementation currentImplementation = null;
        Document currentSubDocument = null;
        NodeList subDocumentRoots = superDocument.getDocumentElement().getChildNodes();
        Element currentSubDocumentRoot = null;
        Vector<Document> subDocumentsVector = new Vector<Document>();
        Document[] subDocumentsArray = null;
        DocumentType subDocumentType = null;
        int i = 0;
        while (i < subDocumentRoots.getLength()) {
            if (subDocumentRoots.item(i).getNodeType() == 1) {
                currentSubDocumentRoot = (Element)subDocumentRoots.item(i);
                currentImplementation = XMLAssistant.getDOMImplementation();
                subDocumentType = null;
                if (documentTypeTemplate != null) {
                    subDocumentType = currentImplementation.createDocumentType(documentTypeTemplate.getName(), documentTypeTemplate.getPublicId(), documentTypeTemplate.getSystemId());
                }
                currentSubDocument = currentImplementation.createDocument(superDocument.getNamespaceURI(), currentSubDocumentRoot.getNodeName(), subDocumentType);
                currentSubDocumentRoot = (Element)currentSubDocument.importNode(currentSubDocumentRoot, true);
                currentSubDocument.replaceChild(currentSubDocumentRoot, currentSubDocument.getDocumentElement());
                subDocumentsVector.add(currentSubDocument);
            }
            ++i;
        }
        subDocumentsArray = new Document[subDocumentsVector.size()];
        subDocumentsVector.toArray(subDocumentsArray);
        return subDocumentsArray;
    }

    public static List getDirectDescendentElementsByTagName(Element element, String name) {
        Assertion.wilyAssert(element != null);
        Assertion.wilyAssert(name != null);
        ArrayList<Element> newList = new ArrayList<Element>();
        NodeList origList = element.getElementsByTagName(name);
        int i = 0;
        while (i < origList.getLength()) {
            Element listElement = (Element)origList.item(i);
            if (listElement.getParentNode().equals(element)) {
                newList.add(listElement);
            }
            ++i;
        }
        return newList;
    }

    public static String getLocalizedString(Element parentElement, String name) {
        Assertion.wilyAssert(parentElement != null);
        Assertion.wilyAssert(name != null);
        List childElements = XMLAssistant.getDirectDescendentElementsByTagName(parentElement, name);
        if (childElements.size() == 0) {
            return "";
        }
        HashMap<String, Element> localeMap = new HashMap<String, Element>();
        int i = 0;
        while (i < childElements.size()) {
            Element childElement = (Element)childElements.get(i);
            String strLocale = childElement.getAttribute("xml:lang");
            if (strLocale != null && strLocale.length() == 0) {
                strLocale = null;
            }
            localeMap.put(strLocale, childElement);
            ++i;
        }
        String bestLocale = LocaleUtils.bestAvailableLocale(localeMap.keySet(), Locale.getDefault());
        Element foundElement = (Element)localeMap.get(bestLocale);
        if (foundElement == null) {
            return kMissingResourceError;
        }
        Node titleNode = foundElement.getFirstChild();
        if (titleNode == null || titleNode.getNodeType() != 3) {
            return kMissingResourceError;
        }
        return titleNode.getNodeValue();
    }

    public static String getLocalizedString(Element parentElement, String name, Locale locale) {
        String bestLocale;
        Element foundElement;
        Assertion.wilyAssert(parentElement != null);
        Assertion.wilyAssert(name != null);
        List childElements = XMLAssistant.getDirectDescendentElementsByTagName(parentElement, name);
        if (childElements.size() == 0) {
            return "";
        }
        HashMap<String, Element> localeMap = new HashMap<String, Element>();
        int i = 0;
        while (i < childElements.size()) {
            Element childElement = (Element)childElements.get(i);
            String strLocale = childElement.getAttribute("xml:lang");
            if (strLocale != null && strLocale.length() == 0) {
                strLocale = null;
            }
            localeMap.put(strLocale, childElement);
            ++i;
        }
        if (locale == null) {
            locale = Locale.getDefault();
        }
        if ((foundElement = (Element)localeMap.get(bestLocale = LocaleUtils.bestAvailableLocale(localeMap.keySet(), locale))) == null) {
            return kMissingResourceError;
        }
        Node titleNode = foundElement.getFirstChild();
        if (titleNode == null || titleNode.getNodeType() != 3) {
            return kMissingResourceError;
        }
        return titleNode.getNodeValue();
    }

    public static Element createDOMElementForColor(Document doc, String elementName, Color color) {
        return XMLAssistant.createDOMElementForInteger(doc, elementName, color.getRGB());
    }

    public static Color parseDOMElementAsColor(Element colorElement, String expectedElementName) throws BadlyFormedXMLException {
        int rgbValue = XMLAssistant.parseDOMElementAsInteger(colorElement, expectedElementName);
        return new Color(rgbValue, true);
    }
}

