/*
 * Decompiled with CFR 0.152.
 */
package com.wily.introscope.agent.bizdef;

import com.wily.introscope.agent.IAgent;
import com.wily.introscope.agent.bizdef.IBizParameter;
import com.wily.introscope.agent.bizdef.IBizParameterSet;
import com.wily.introscope.agent.bizdef.IBizParameterType;
import com.wily.introscope.agent.bizdef.adt.CaseSensitiveMap;
import com.wily.introscope.agent.bizdef.constants.KBizConstants;
import com.wily.introscope.agent.bizdef.parameters.BizParameter;
import com.wily.introscope.agent.bizdef.types.BizDefType;
import com.wily.introscope.agent.urlgroup.TomcatUtil;
import com.wily.introscope.spec.agent.beans.bizdef.IBizDefSupportBean;
import com.wily.util.feedback.IModuleFeedbackChannel;
import com.wily.util.text.IStringLocalizer;
import java.io.UnsupportedEncodingException;
import java.util.HashMap;
import java.util.Map;

public class LazyBizParameterSetMap
extends HashMap
implements IBizParameterSet {
    IBizParameter kNullResult = new IBizParameter(){

        public String getName() {
            return "null";
        }

        public IBizParameterType getType() {
            return null;
        }

        public String getValue() {
            return null;
        }

        public String getValue(String key) {
            return null;
        }

        public CaseSensitiveMap getValues() {
            return null;
        }
    };
    private final Map lazyMap;
    private final IAgent fAgent;
    private final IStringLocalizer fLocalizer;
    private final IModuleFeedbackChannel fFeedback;
    private final IBizDefSupportBean fSupport;
    private final boolean fIsVerboseEnabled;

    public LazyBizParameterSetMap(IBizDefSupportBean support, Map lazyMap, IAgent agent) {
        this.fSupport = support;
        this.lazyMap = lazyMap;
        this.fAgent = agent;
        this.fFeedback = this.fAgent.IAgent_getModuleFeedback();
        this.fLocalizer = this.fAgent.IAgent_getStringLocalizer();
        this.fIsVerboseEnabled = this.fFeedback.isVerboseEnabled(KBizConstants.kBizDefModule);
    }

    public void put(IBizParameterType type, IBizParameter parameter) {
    }

    public IBizParameter get(IBizParameterType type) throws UnsupportedEncodingException {
        IBizParameter result = (IBizParameter)super.get(type);
        if (result == null) {
            result = this.getBizParameterByType(type);
            if (result == null) {
                result = this.kNullResult;
                super.put(type, result);
                return null;
            }
            super.put(type, result);
            return result;
        }
        if (result == this.kNullResult) {
            return null;
        }
        return result;
    }

    private IBizParameter getBizParameterByType(IBizParameterType type) throws UnsupportedEncodingException {
        if (type == BizDefType.getInstance("PATH")) {
            String result = (String)this.lazyMap.get("URL");
            if (result != null) {
                BizParameter parameter = new BizParameter("Path", result, type);
                String cfr_ignored_0 = (String)this.lazyMap.get("Server Name");
                if (this.fIsVerboseEnabled) {
                    this.fFeedback.verbose(KBizConstants.kBizDefModule, this.fLocalizer.IStringLocalizer_getLocalizedString("BizDef_Added_BizParameterSet"));
                    this.fFeedback.verbose(KBizConstants.kBizDefModule, ((Object)parameter).toString());
                }
                return parameter;
            }
            return null;
        }
        if (type == BizDefType.getInstance("HOST")) {
            String result = (String)this.lazyMap.get("Server Name");
            if (result != null) {
                BizParameter parameter = new BizParameter("Host", result, type);
                if (this.fIsVerboseEnabled) {
                    this.fFeedback.verbose(KBizConstants.kBizDefModule, this.fLocalizer.IStringLocalizer_getLocalizedString("BizDef_Added_BizParameterSet"));
                    this.fFeedback.verbose(KBizConstants.kBizDefModule, ((Object)parameter).toString());
                }
                return parameter;
            }
            return null;
        }
        if (type == BizDefType.getInstance("PORT")) {
            String result = (String)this.lazyMap.get("Server Port");
            if (result != null) {
                BizParameter parameter = new BizParameter("Port", result, type);
                if (this.fIsVerboseEnabled) {
                    this.fFeedback.verbose(KBizConstants.kBizDefModule, this.fLocalizer.IStringLocalizer_getLocalizedString("BizDef_Added_BizParameterSet"));
                    this.fFeedback.verbose(KBizConstants.kBizDefModule, ((Object)parameter).toString());
                }
                return parameter;
            }
            return null;
        }
        if (type == BizDefType.getInstance("QUERY")) {
            String result = (String)this.lazyMap.get("URL Query");
            if (result != null) {
                HashMap queryMap = new HashMap();
                TomcatUtil.parseParameters(queryMap, (String)result, (String)"US-ASCII");
                BizParameter parameter = new BizParameter(null, CaseSensitiveMap.getInstance(queryMap), type);
                if (this.fIsVerboseEnabled) {
                    this.fFeedback.verbose(KBizConstants.kBizDefModule, this.fLocalizer.IStringLocalizer_getLocalizedString("BizDef_Added_BizParameterSet"));
                    this.fFeedback.verbose(KBizConstants.kBizDefModule, ((Object)parameter).toString());
                }
                return parameter;
            }
            return null;
        }
        if (type == BizDefType.getInstance("POST")) {
            Map result;
            Object servletURI = this.lazyMap.get("URL");
            if (!this.fSupport.isVetoedPostURI(servletURI) && (result = (Map)this.lazyMap.get("introscope.agent.HttpServletTracer.postParameters")) != null) {
                BizParameter parameter = new BizParameter(null, CaseSensitiveMap.getInstance(result), type);
                if (this.fIsVerboseEnabled) {
                    this.fFeedback.verbose(KBizConstants.kBizDefModule, this.fLocalizer.IStringLocalizer_getLocalizedString("BizDef_Added_BizParameterSet"));
                    this.fFeedback.verbose(KBizConstants.kBizDefModule, ((Object)parameter).toString());
                }
                return parameter;
            }
            return null;
        }
        if (type == BizDefType.getInstance("COOKIE")) {
            Map result = (Map)this.lazyMap.get("introscope.agent.HttpServletTracer.cookieParameters");
            if (result != null) {
                BizParameter parameter = new BizParameter(null, CaseSensitiveMap.getInstance(result), type);
                if (this.fIsVerboseEnabled) {
                    this.fFeedback.verbose(KBizConstants.kBizDefModule, this.fLocalizer.IStringLocalizer_getLocalizedString("BizDef_Added_BizParameterSet"));
                    this.fFeedback.verbose(KBizConstants.kBizDefModule, ((Object)parameter).toString());
                }
                return parameter;
            }
            return null;
        }
        if (type == BizDefType.getInstance("HTTP")) {
            Map result = (Map)this.lazyMap.get("introscope.agent.HttpServletTracer.headerParameters");
            if (result != null) {
                BizParameter parameter = new BizParameter(null, CaseSensitiveMap.getInstance(result), type);
                if (this.fIsVerboseEnabled) {
                    this.fFeedback.verbose(KBizConstants.kBizDefModule, this.fLocalizer.IStringLocalizer_getLocalizedString("BizDef_Added_BizParameterSet"));
                    this.fFeedback.verbose(KBizConstants.kBizDefModule, ((Object)parameter).toString());
                }
                return parameter;
            }
            return null;
        }
        if (type == BizDefType.getInstance("XWTG")) {
            Map result = (Map)this.lazyMap.get("XWTG");
            if (result != null) {
                BizParameter parameter = new BizParameter(null, CaseSensitiveMap.getInstance(result), type);
                if (this.fIsVerboseEnabled) {
                    this.fFeedback.verbose(KBizConstants.kBizDefModule, this.fLocalizer.IStringLocalizer_getLocalizedString("BizDef_Added_BizParameterSet"));
                    this.fFeedback.verbose(KBizConstants.kBizDefModule, ((Object)parameter).toString());
                }
                return parameter;
            }
            return null;
        }
        return null;
    }

    public int size() {
        return super.size();
    }
}

