/*
 * Decompiled with CFR 0.152.
 */
package com.wily.introscope.agent.bizdef.definition;

import com.wily.introscope.agent.bizdef.BizDefAdministrator;
import com.wily.introscope.spec.agent.bizdef.IBizTrx;
import com.wily.introscope.spec.server.MetricNameUtils;
import com.wily.util.HashCodeUtils;
import com.wily.wilyassert.Assertion;

public final class BizTrxDef
implements IBizTrx {
    private Long fBizId;
    private String fBizProcessName;
    private String fBizTrxName;
    private String fBizTrxComponentName;
    private boolean fContainsPostParams;
    private boolean fIdentifying;
    private boolean fisResponseBased;

    public BizTrxDef() {
        this.fBizProcessName = null;
        this.fBizTrxName = null;
        this.fBizTrxComponentName = null;
        this.fContainsPostParams = false;
        this.fBizId = new Long(0L);
    }

    public BizTrxDef(long id, String bizProcessName, String bizTrxName, String bizTrxComponentName, boolean identifying, boolean isResponseBased) {
        Assertion.wilyAssert(false);
        this.fBizId = new Long(id);
        this.fBizTrxComponentName = this.replaceEscapeChars(bizTrxComponentName);
        this.fBizProcessName = this.replaceEscapeChars(bizProcessName);
        this.fBizTrxName = this.replaceEscapeChars(bizTrxName);
        this.fIdentifying = identifying;
        this.fisResponseBased = isResponseBased;
    }

    public BizTrxDef(String name) {
        this(0L, "BP" + name, "BT" + name, "BTC" + name, true, false);
    }

    public long getId() {
        return this.fBizId;
    }

    public String getBizFullName() {
        return "Business Segment|" + this.getBizProcessName() + "|" + this.getBizTrxName() + "|" + this.getBizTrxComponentName();
    }

    public String getBizFullDescriptionName() {
        return "Business Segment|BusinessProcess|" + this.getBizProcessName() + "|" + "BusinessTransaction" + "|" + this.getBizTrxName() + "|" + "BusinessTransactionComponent" + "|" + this.getBizTrxComponentName();
    }

    public String getBizProcessName() {
        return this.fBizProcessName;
    }

    public void setBizProcessName(String processName) {
        Assertion.wilyAssert(false);
        this.fBizProcessName = processName;
    }

    public String getBizSegmentName() {
        return null;
    }

    public void setBizSegmentName(String segmentName) {
    }

    public String getBizTrxComponentName() {
        return this.fBizTrxComponentName;
    }

    public void setBizTrxComponentName(String componentName) {
        Assertion.wilyAssert(false);
        this.fBizTrxComponentName = this.replaceEscapeChars(componentName);
    }

    public String getBizTrxName() {
        return this.fBizTrxName;
    }

    public void setBizTrxName(String trxName) {
        Assertion.wilyAssert(false);
        this.fBizTrxName = trxName;
    }

    public String getBusinessDomain() {
        return "Business Segment";
    }

    public void setPostParams() {
        this.fContainsPostParams = true;
    }

    public boolean containsPostParams() {
        return this.fContainsPostParams;
    }

    public String replaceEscapeChars(String name) {
        if (name == null) {
            return name;
        }
        Boolean segmentSeparatorReplacementEnabled = BizDefAdministrator.isSegmentSeparatorReplacementEnabled();
        if (segmentSeparatorReplacementEnabled != null && !segmentSeparatorReplacementEnabled.booleanValue()) {
            return name.replace(':', '%');
        }
        return MetricNameUtils.substituteMetricSeparatorChars((String)name);
    }

    public String toString() {
        return this.getBizFullName();
    }

    public int hashCode() {
        int result = 17;
        result = HashCodeUtils.accumulateHashCode(result, this.fBizId);
        return result;
    }

    public boolean equals(Object other) {
        if (other != null && other instanceof BizTrxDef) {
            BizTrxDef otherMT = (BizTrxDef)other;
            return this.safeEquals(otherMT.fBizId, this.fBizId);
        }
        return false;
    }

    private boolean safeEquals(Object a, Object b) {
        return a != null ? (b != null ? a.equals(b) : false) : b == null;
    }

    public boolean isIdentifying() {
        return this.fIdentifying;
    }

    public boolean isResponseBased() {
        return this.fisResponseBased;
    }
}

