/*
 * Decompiled with CFR 0.152.
 */
package com.wily.introscope.agent.bizdef.operations;

import com.wily.introscope.agent.bizdef.BizDefEncapsulatedPattern;
import com.wily.introscope.agent.bizdef.IBizOperationType;
import com.wily.introscope.agent.bizdef.adt.CaseSensitiveMap;
import com.wily.introscope.agent.bizdef.operations.BizUndefinedOperation;
import com.wily.introscope.agent.bizdef.operations.IBizAction;

public class BizNotEqualOperation
implements IBizAction {
    private final String fName = "NOT_EQUALS_OPERATION";
    private final IBizOperationType fType;

    public BizNotEqualOperation(IBizOperationType type) {
        this.fType = type;
    }

    public IBizOperationType getType() {
        return this.fType;
    }

    public boolean matches(BizDefEncapsulatedPattern pattern, String value, boolean caseSensitivity) {
        if (pattern != null) {
            String value0 = pattern.getPattern();
            if (!caseSensitivity) {
                value0 = pattern.getLowercaseOnlyPattern();
            }
            String value1 = value;
            if (!caseSensitivity) {
                value1 = value1.toLowerCase();
            }
            return !value0.equals(value1);
        }
        return false;
    }

    public boolean matches(Object parameter, BizDefEncapsulatedPattern name, BizDefEncapsulatedPattern pattern, CaseSensitiveMap parameterMap, boolean caseSensitiveName, boolean caseSensitiveValue) {
        if (name != null && pattern != null && parameterMap != null) {
            String value = BizNotEqualOperation.findValue(parameter, name, parameterMap, caseSensitiveName, caseSensitiveValue);
            if (value == null) {
                return false;
            }
            String patternString = pattern.getPattern();
            if (!caseSensitiveValue) {
                patternString = pattern.getLowercaseOnlyPattern();
            }
            if (caseSensitiveValue) {
                return !value.equals(patternString);
            }
            return !value.toLowerCase().equals(patternString);
        }
        return false;
    }

    static String findValue(Object parameter, BizDefEncapsulatedPattern name, CaseSensitiveMap parameterMap, boolean caseSensitiveName, boolean caseSensitiveValue) {
        Object result = parameter;
        if (result != null && result == BizUndefinedOperation.kUndefinedNameCheck) {
            result = parameterMap.get(name, caseSensitiveName, caseSensitiveValue);
        }
        if (result == null) {
            return null;
        }
        if (result instanceof String[]) {
            return ((String[])result)[0];
        }
        if (result instanceof String) {
            return result.toString();
        }
        return null;
    }

    public String toString() {
        return "NOT_EQUALS_OPERATION";
    }

    public boolean equals(Object arg0) {
        if (arg0 == null) {
            return false;
        }
        return this.toString().equals(arg0.toString());
    }

    public int hashCode() {
        return this.toString().hashCode();
    }
}

