/*
 * Decompiled with CFR 0.152.
 */
package com.wily.util.adt;

import com.wily.util.adt.DequeueTimedOutException;
import com.wily.util.adt.LimitingQueue;
import com.wily.util.clock.MasterClock;
import com.wily.util.feedback.IModuleFeedbackChannel;

public class BlockingQueue
extends LimitingQueue {
    public BlockingQueue(String name, IModuleFeedbackChannel feedback) {
        super(name, feedback);
    }

    public synchronized boolean enqueue(Object data) {
        boolean result = super.enqueue(data);
        if (result) {
            this.notifyAll();
        }
        return result;
    }

    public synchronized Object dequeue() throws InterruptedException {
        while (this.isEmpty()) {
            this.wait();
        }
        return super.dequeue();
    }

    public synchronized Object dequeue(long timeoutInMillis) throws DequeueTimedOutException, InterruptedException {
        while (this.isEmpty()) {
            try {
                long startTime = 0L;
                long endTime = 0L;
                if (timeoutInMillis > 0L) {
                    startTime = MasterClock.currentTimeMillis();
                }
                this.wait(timeoutInMillis);
                if (timeoutInMillis <= 0L) continue;
                endTime = MasterClock.currentTimeMillis();
                if (startTime + timeoutInMillis > endTime) {
                    timeoutInMillis -= endTime - startTime;
                    continue;
                }
                throw new DequeueTimedOutException();
            }
            catch (InterruptedException interruptedException) {}
        }
        return super.dequeue();
    }

    public synchronized Object interruptableDequeue() throws InterruptedException {
        while (this.isEmpty()) {
            this.wait();
        }
        return super.dequeue();
    }

    public synchronized Object interruptableDequeue(long timeoutInMillis) throws InterruptedException, DequeueTimedOutException {
        while (this.isEmpty()) {
            long startTime = 0L;
            long endTime = 0L;
            if (timeoutInMillis > 0L) {
                startTime = MasterClock.currentTimeMillis();
            }
            this.wait(timeoutInMillis);
            if (timeoutInMillis <= 0L) continue;
            endTime = MasterClock.currentTimeMillis();
            if (startTime + timeoutInMillis > endTime) {
                timeoutInMillis -= endTime - startTime;
                continue;
            }
            throw new DequeueTimedOutException();
        }
        return super.dequeue();
    }
}

