/*
 * Decompiled with CFR 0.152.
 */
package com.wily.util.io;

import com.wily.util.exception.UnexpectedExceptionError;
import com.wily.util.io.NonSyncBufferedOutputStream;
import com.wily.util.io.NonSyncByteArrayOutputStream;
import java.io.IOException;
import java.io.ObjectOutput;
import java.io.ObjectOutputStream;
import java.util.zip.GZIPOutputStream;

public class CompressedObjectOutputByteArray {
    private ObjectOutputStream fOut;
    private NonSyncByteArrayOutputStream fByteOut;

    public CompressedObjectOutputByteArray() {
        try {
            this.fByteOut = new NonSyncByteArrayOutputStream();
            GZIPOutputStream gzipOutput = new GZIPOutputStream(this.fByteOut){
                {
                    this.def.setLevel(1);
                }
            };
            NonSyncBufferedOutputStream bufferedOut = new NonSyncBufferedOutputStream(gzipOutput);
            this.fOut = new ObjectOutputStream(bufferedOut);
        }
        catch (IOException e) {
            throw new UnexpectedExceptionError(e);
        }
    }

    public ObjectOutput getObjectOutput() {
        return this.fOut;
    }

    public byte[] getData() {
        return this.fByteOut.toByteArray();
    }

    public void flush() throws IOException {
        this.fOut.flush();
    }

    public void close() throws IOException {
        this.fOut.close();
    }
}

