/*
 * Decompiled with CFR 0.152.
 */
package com.wily.introscope.agent.platform;

import com.wily.introscope.agent.platform.APlatformStatPoller;
import com.wily.introscope.agent.platform.IPlatformStatistics;
import com.wily.introscope.agent.platform.PlatformLibraryException;
import com.wily.introscope.agent.platform.PlatformStatUnavailableException;
import com.wily.introscope.agent.stat.DataAccumulatorFactory;
import com.wily.introscope.agent.stat.IIntegerAverageDataAccumulator;
import com.wily.introscope.spec.metric.AgentMetric;

public final class ProcessCPUUtilizationPoller
extends APlatformStatPoller {
    private final IIntegerAverageDataAccumulator fAccumulator;

    public ProcessCPUUtilizationPoller(DataAccumulatorFactory factory, IPlatformStatistics platformStats) {
        super(platformStats);
        this.fAccumulator = factory.safeGetIntegerPercentageDataAccumulator("CPU:Utilization % (process)", 64);
    }

    protected AgentMetric getMetric() {
        return this.fAccumulator.IDataAccumulator_getMetric();
    }

    protected void reset() throws PlatformLibraryException, PlatformStatUnavailableException {
        this.getPlatformStatistics().IPlatformStatistics_resetCPUUtilizationForCurrentProcess();
    }

    protected void pollForPlatformStatistic() throws PlatformLibraryException, PlatformStatUnavailableException {
        double usage = this.getPlatformStatistics().IPlatformStatistics_getCPUUtilizationForCurrentProcess();
        int result = (int)usage;
        if (result > 100) {
            result = 100;
        } else if (result < 0) {
            result = 0;
        }
        this.fAccumulator.IIntegerAggregatingDataAccumulator_recordDataPoint(result);
    }
}

