/*
 * Decompiled with CFR 0.152.
 */
package com.wily.util.event;

import com.wily.util.event.EventMarker;
import com.wily.util.event.InvalidEventMarkerException;
import com.wily.util.text.ILocalizableMessage;
import com.wily.util.text.SimpleLocalizableMessage;
import com.wily.wilyassert.Assertion;
import java.io.PrintStream;
import java.util.Iterator;
import java.util.SortedMap;
import java.util.TreeMap;

public class EventMarkedQueue {
    private final SortedMap fMarkerMap;
    private final long fAgingLimit;

    public EventMarkedQueue(long agingLimit) {
        this.fAgingLimit = agingLimit;
        this.fMarkerMap = new TreeMap();
    }

    public synchronized Object add(EventMarker marker, Object o) {
        this.doAging();
        if (this.fMarkerMap.size() > 0) {
            Assertion.wilyAssert(marker.compareTo(this.fMarkerMap.firstKey()) > 0);
        }
        return this.fMarkerMap.put(marker, o);
    }

    public synchronized Object get(EventMarker marker) throws InvalidEventMarkerException {
        this.doAging();
        Object exact = this.fMarkerMap.get(marker);
        if (exact != null) {
            return exact;
        }
        SortedMap map = this.fMarkerMap.headMap(marker);
        if (map.size() > 0) {
            return this.fMarkerMap.get(map.lastKey());
        }
        throw new InvalidEventMarkerException("event marker is unavailable", (ILocalizableMessage)new SimpleLocalizableMessage("EventMarkerTimedOutExceptionKey"));
    }

    private void doAging() {
        while (this.fMarkerMap.size() > 1) {
            EventMarker marker = (EventMarker)this.fMarkerMap.firstKey();
            if (System.currentTimeMillis() - marker.getEventTimestamp() <= this.fAgingLimit) break;
            this.fMarkerMap.remove(marker);
        }
    }

    public void debug_dumpQueue(PrintStream ps) {
        ps.println(this.getClass().getName() + ": queueSize = " + this.fMarkerMap.size() + ", aging window = " + this.fAgingLimit + ", current time = " + System.currentTimeMillis());
        Iterator it = this.fMarkerMap.keySet().iterator();
        while (it.hasNext()) {
            Object o = it.next();
            ps.println("EventMarker=" + o + " Object=" + this.fMarkerMap.get(o));
        }
    }
}

