/*
 * Decompiled with CFR 0.152.
 */
package com.wily.diagnos.cmp.batch;

import com.wily.diagnos.cmp.batch.IMethodSpanningCacheLine;
import com.wily.diagnos.cmp.directives.TracerGroup;
import com.wily.diagnos.cmp.directives.apply.MethodSettingsApplier;
import com.wily.diagnos.cmp.log.ICompilerLog;
import com.wily.diagnos.cmp.tracer.MethodTracer;
import com.wily.util.adt.ConcurrentHighPerformanceLRUHashMap;
import com.wily.util.adt.IFlushable;
import com.wily.util.classfile.IClassName;
import com.wily.util.classfile.IModeledClass;
import com.wily.wilyassert.Assertion;
import java.util.ArrayList;
import java.util.BitSet;
import java.util.HashMap;
import java.util.Map;

public class MethodSpanningCache
implements IFlushable {
    private final ICompilerLog fLog;
    private final Map fCache;
    private long fHit;
    private long fMiss;

    public MethodSpanningCache(ICompilerLog log, int size) {
        this.fLog = log;
        this.fCache = new ConcurrentHighPerformanceLRUHashMap(size);
    }

    public void IFlushable_flush() {
        int x = this.fCache.size();
        this.fCache.clear();
        this.fLog.ICompilerLog_logMessage("Method spanning cache was flushed:::" + x + " elements removed");
    }

    public IMethodSpanningCacheLine getCacheLine(IModeledClass modeledClass, int tracerCount) {
        IClassName key = modeledClass.getClassName();
        IMethodSpanningCacheLine cacheLine = (IMethodSpanningCacheLine)this.fCache.get(key);
        if (cacheLine == null) {
            ++this.fMiss;
            cacheLine = new CacheLineBuilder(this.fLog, modeledClass, tracerCount);
        } else {
            ++this.fHit;
        }
        return cacheLine;
    }

    public void commitCacheLine(IModeledClass modeledClass, IMethodSpanningCacheLine cacheLine) {
        if (cacheLine.needsCommit()) {
            IMethodSpanningCacheLine commitedCopy = cacheLine.commit();
            this.fCache.put(modeledClass.getClassName(), commitedCopy);
        }
    }

    public void invalidateMethodSpanningCache() {
        this.fCache.clear();
    }

    private static class CacheLineBuilder
    implements IMethodSpanningCacheLine {
        private final ICompilerLog fLog;
        private final IModeledClass fModeledClass;
        private BitSet fTracerGroupSkips;
        private BitSet fTracerMatches;
        private final HashMap fMap;
        private boolean fCommitted;

        public CacheLineBuilder(ICompilerLog log, IModeledClass targetClass, int tracerCount) {
            this.fLog = log;
            this.fModeledClass = targetClass;
            this.fMap = new HashMap();
            this.fTracerGroupSkips = new BitSet(tracerCount);
            this.fTracerMatches = new BitSet(tracerCount);
        }

        private void cleanupBits() {
            this.fTracerGroupSkips = null;
            this.fTracerMatches = null;
        }

        public boolean doesTracerMatchClass(MethodTracer tracer, int tracerIndex) {
            Assertion.wilyAssert(false);
            Assertion.wilyAssert(false);
            boolean result = tracer.getClassMatcher().IClassMatcher_matches(this.fModeledClass);
            if (result) {
                this.fTracerMatches.set(tracerIndex);
            }
            return result;
        }

        public boolean shouldSkipClassForTracerGroup(TracerGroup group, MethodSettingsApplier applier, int tracerIndex) {
            boolean finalAnswer;
            Assertion.wilyAssert(false);
            Assertion.wilyAssert(false);
            Boolean wrappedResult = (Boolean)this.fMap.get(group);
            if (wrappedResult == null) {
                boolean result = applier.shouldSkipClassForTracerGroup(group);
                wrappedResult = result ? Boolean.TRUE : Boolean.FALSE;
                this.fMap.put(group, wrappedResult);
            }
            boolean bl = finalAnswer = wrappedResult == Boolean.TRUE;
            if (finalAnswer) {
                this.fTracerGroupSkips.set(tracerIndex);
            }
            return finalAnswer;
        }

        public boolean needsCommit() {
            return !this.fCommitted;
        }

        public IMethodSpanningCacheLine commit() {
            if (!this.needsCommit()) {
                throw new IllegalStateException();
            }
            FinishedCacheLine finishedLine = new FinishedCacheLine(this.fTracerGroupSkips, this.fTracerMatches, this.fLog);
            this.cleanupBits();
            this.fCommitted = true;
            return finishedLine;
        }
    }

    private static class FinishedCacheLine
    implements IMethodSpanningCacheLine {
        private final ICompilerLog fLog;
        private static final ArrayList fBitSetCache = new ArrayList();
        private static int kHitCount;
        private static int kMissCount;
        private final BitSet fTracerGroupSkips;
        private final BitSet fTracerMatches;

        public FinishedCacheLine(BitSet tracerGroupSkips, BitSet tracerMatches, ICompilerLog log) {
            Assertion.wilyAssert(false);
            Assertion.wilyAssert(false);
            this.fLog = log;
            this.fTracerGroupSkips = this.retrieveCachedCopyIfExists(tracerGroupSkips);
            this.fTracerMatches = this.retrieveCachedCopyIfExists(tracerMatches);
            tracerGroupSkips = null;
            tracerMatches = null;
        }

        BitSet retrieveCachedCopyIfExists(BitSet bits) {
            int x = 0;
            while (x < fBitSetCache.size()) {
                BitSet cache = (BitSet)fBitSetCache.get(x);
                if (bits.equals(cache)) {
                    return cache;
                }
                ++x;
            }
            fBitSetCache.add(bits);
            return bits;
        }

        public boolean doesTracerMatchClass(MethodTracer t, int tracerIndex) {
            return this.fTracerMatches.get(tracerIndex);
        }

        public boolean shouldSkipClassForTracerGroup(TracerGroup group, MethodSettingsApplier applier, int tracerIndex) {
            return this.fTracerGroupSkips.get(tracerIndex);
        }

        public boolean needsCommit() {
            return false;
        }

        public IMethodSpanningCacheLine commit() {
            return this;
        }
    }
}

