/*
 * Decompiled with CFR 0.152.
 */
package com.wily.diagnos.cmp.classmatcher;

import com.wily.diagnos.cmp.classmatcher.AImmutableClassMatcher;
import com.wily.diagnos.cmp.directives.utility.CompilerSettingsUtility;
import com.wily.diagnos.cmp.log.CompilerLogDetails;
import com.wily.diagnos.cmp.log.CompilerLogDetailsSession;
import com.wily.util.HashCodeUtils;
import com.wily.util.classfile.ClassFileUtilities;
import com.wily.util.classfile.IClassName;
import com.wily.util.classfile.IModeledClass;

public class DGInheritedClassMatcher
extends AImmutableClassMatcher {
    private final IClassName fClassName;

    public DGInheritedClassMatcher(IClassName className) {
        this.fClassName = className;
    }

    private boolean executeMatches(IModeledClass cls) {
        if (cls.hasSuperClass() && ClassFileUtilities.looselyMatches(this.fClassName, cls.getSuperClassName())) {
            return true;
        }
        return cls.inheritsDirectlyFromInterface(this.fClassName);
    }

    public boolean IClassMatcher_supportsNameMatching() {
        return false;
    }

    public boolean IClassMatcher_matches(IClassName className) {
        return false;
    }

    public IClassName getClassName() {
        return this.fClassName;
    }

    public int hashCode() {
        int result = 17;
        result = HashCodeUtils.accumulateHashCode(result, this.fClassName);
        return result;
    }

    public boolean equals(Object obj) {
        if (obj instanceof DGInheritedClassMatcher) {
            DGInheritedClassMatcher m = (DGInheritedClassMatcher)obj;
            return this.fClassName.equals(m.fClassName);
        }
        return false;
    }

    public boolean IClassMatcher_matches(IModeledClass cls) {
        boolean result = this.executeMatches(cls);
        if (result) {
            CompilerLogDetails current = CompilerLogDetailsSession.getCurrent();
            current.setInheritedClassName(this.fClassName);
            current.setSkipCause(4096);
        }
        return result;
    }

    public String[] getMatcherKeys() {
        return new String[]{CompilerSettingsUtility.getKeyFromString(this.fClassName.getPackageAndNameString())};
    }
}

