/*
 * Decompiled with CFR 0.152.
 */
package com.wily.diagnos.cmp.directives;

import com.wily.util.classfile.InvalidClassNameException;
import com.wily.util.classfile.InvalidMethodDescriptorException;
import com.wily.util.classfile.InvalidMethodNameException;
import com.wily.util.classfile.java.ClassName;
import com.wily.util.classfile.java.MethodName;
import java.util.Iterator;
import java.util.Map;
import java.util.Set;
import java.util.concurrent.ConcurrentHashMap;

public class AnalysedClassesMapInitializer {
    private static ConcurrentHashMap InstrumentationCandidatesClassesList;
    private static ConcurrentHashMap sInstrumentationCandidatesMethodsMapping;
    private static ConcurrentHashMap sDoNotSkipList;

    static {
        sDoNotSkipList = new ConcurrentHashMap();
    }

    public AnalysedClassesMapInitializer() {
        InstrumentationCandidatesClassesList = new ConcurrentHashMap();
        sInstrumentationCandidatesMethodsMapping = new ConcurrentHashMap();
    }

    public static void addCandidateClasses(Set classList) {
        Iterator it = classList.iterator();
        while (it.hasNext()) {
            AnalysedClassesMapInitializer.addCandidateClass((String)it.next());
        }
    }

    public static void addCandidateClass(String className) {
        String strClassname = "";
        try {
            strClassname = ClassName.getClassName(className).getPackageAndNameString();
        }
        catch (InvalidClassNameException invalidClassNameException) {}
        InstrumentationCandidatesClassesList.put(new Integer(strClassname.hashCode()), new Integer(1));
    }

    public static boolean isCandidateClass(String className) {
        String strClassname = "";
        try {
            strClassname = ClassName.getClassName(className).getPackageAndNameString();
        }
        catch (InvalidClassNameException invalidClassNameException) {}
        return InstrumentationCandidatesClassesList.containsKey(new Integer(strClassname.hashCode()));
    }

    public static void addCandidateMethods(Map methodMap) {
        sInstrumentationCandidatesMethodsMapping.putAll(methodMap);
    }

    public static short[] getCandidateMethodInfo(int methodKey) {
        return (short[])sInstrumentationCandidatesMethodsMapping.get(new Integer(methodKey));
    }

    public static int getMethodKey(String classname, String methodname, String methodDescriptor) {
        String strClassname = "";
        String strMethodName = "";
        try {
            strClassname = ClassName.getClassName(classname).getPackageAndNameString();
            strMethodName = MethodName.getMethodName(String.valueOf(methodname) + methodDescriptor).getNameAndSignatureString();
        }
        catch (InvalidClassNameException invalidClassNameException) {
        }
        catch (InvalidMethodDescriptorException invalidMethodDescriptorException) {
        }
        catch (InvalidMethodNameException invalidMethodNameException) {}
        String keystr = String.valueOf(strClassname) + strMethodName;
        return keystr.hashCode();
    }

    public static short[] getMethodMetadata(String classname, String methodname, String methodDescriptor) {
        int key = AnalysedClassesMapInitializer.getMethodKey(classname, methodname, methodDescriptor);
        return (short[])sInstrumentationCandidatesMethodsMapping.get(new Integer(key));
    }

    public static short getSequentialProbeIndexForMethod(String classname, String methodname, String methodDescriptor) {
        short retVal = -1;
        int key = AnalysedClassesMapInitializer.getMethodKey(classname, methodname, methodDescriptor);
        short[] meta = (short[])sInstrumentationCandidatesMethodsMapping.get(new Integer(key));
        if (meta != null && meta.length > 2) {
            retVal = meta[1];
        }
        return retVal;
    }

    public static void updateMethodMetadata(String classname, String methodname, String methodDescriptor, short[] metadata) {
        int key = AnalysedClassesMapInitializer.getMethodKey(classname, methodname, methodDescriptor);
        sInstrumentationCandidatesMethodsMapping.put(new Integer(key), metadata);
    }

    public static void updateMethodScoreAndState(String classname, String methodname, String methodDescriptor, short methodScore, short methodState) {
        String strClassname = "";
        String strMethodName = "";
        try {
            strClassname = ClassName.getClassName(classname).getPackageAndNameString();
            strMethodName = MethodName.getMethodName(String.valueOf(methodname) + methodDescriptor).getNameAndSignatureString();
        }
        catch (InvalidClassNameException invalidClassNameException) {
        }
        catch (InvalidMethodDescriptorException invalidMethodDescriptorException) {
        }
        catch (InvalidMethodNameException invalidMethodNameException) {}
        String keystr = String.valueOf(strClassname) + strMethodName;
        int key = keystr.hashCode();
        short[] metadata = (short[])sInstrumentationCandidatesMethodsMapping.get(new Integer(key));
        metadata[0] = methodScore;
        metadata[2] = methodState;
        sInstrumentationCandidatesMethodsMapping.put(new Integer(key), metadata);
    }

    public static boolean shouldNotSkipClass(String className) {
        return sDoNotSkipList.get(className) != null;
    }

    public static void addToDoNotSkipList(String className) {
        sDoNotSkipList.putIfAbsent(className, Boolean.TRUE);
    }
}

