/*
 * Decompiled with CFR 0.152.
 */
package com.wily.diagnos.cmp.directives;

import com.wily.diagnos.cmp.directives.ADirective;
import com.wily.diagnos.cmp.directives.InvalidDirectiveException;
import com.wily.diagnos.cmp.directives.builder.CompilerSettingsBuilder;
import com.wily.diagnos.cmp.transform.builder.SubstituteStaticMethodTransformationBuilder;
import com.wily.util.classfile.FullyQualifiedMethodName;
import com.wily.util.classfile.IMethodSignature;
import com.wily.util.text.ILocalizableMessage;
import com.wily.util.text.SimpleLocalizableMessage;

public final class SubstituteStaticMethodDirective
extends ADirective {
    private static final String kMethodDescriptorsMustBeIdenticalMessage = "Method descriptors must be identical";
    private final FullyQualifiedMethodName fSourceMethod;
    private final FullyQualifiedMethodName fReplacementMethod;

    public SubstituteStaticMethodDirective(String source, int lineNumber, FullyQualifiedMethodName sourceMethod, FullyQualifiedMethodName replacementMethod) throws InvalidDirectiveException {
        super(source, lineNumber);
        this.validateParameters(sourceMethod, replacementMethod);
        this.fSourceMethod = sourceMethod;
        this.fReplacementMethod = replacementMethod;
    }

    private void validateParameters(FullyQualifiedMethodName sourceMethod, FullyQualifiedMethodName replacementMethod) throws InvalidDirectiveException {
        IMethodSignature replacementDescriptor;
        IMethodSignature sourceDescriptor = sourceMethod.getMethodName().getSignature();
        if (!sourceDescriptor.equals(replacementDescriptor = replacementMethod.getMethodName().getSignature())) {
            throw new InvalidDirectiveException(kMethodDescriptorsMustBeIdenticalMessage, (ILocalizableMessage)new SimpleLocalizableMessage("Diagnos_Exception_Parsing_Substitute_Method_Descriptors_Must_Match"));
        }
    }

    private FullyQualifiedMethodName getSourceMethod() {
        return this.fSourceMethod;
    }

    private FullyQualifiedMethodName getReplacementMethod() {
        return this.fReplacementMethod;
    }

    protected void applyToSettings(CompilerSettingsBuilder builder) {
        builder.addTransformation(new SubstituteStaticMethodTransformationBuilder(this.getSourceMethod(), this.getReplacementMethod()));
    }
}

