/*
 * Decompiled with CFR 0.152.
 */
package com.wily.diagnos.cmp.directives;

import com.wily.diagnos.cmp.directives.ADirective;
import com.wily.diagnos.cmp.directives.FlagName;
import com.wily.diagnos.cmp.directives.TracerName;
import com.wily.diagnos.cmp.directives.builder.CompilerSettingsBuilder;
import com.wily.diagnos.cmp.directives.builder.TracerGroupBuilder;
import com.wily.diagnos.cmp.methodmatcher.AnnotationMethodMatcher;
import com.wily.diagnos.cmp.methodmatcher.IMethodMatcher;
import com.wily.diagnos.cmp.tracer.builder.MethodTracerBuilder;
import com.wily.util.classfile.IClassName;

public final class TraceAnnotatedMethodsIfFlaggedDirective
extends ADirective {
    private final FlagName fFlagName;
    private final IClassName fClassName;
    private final TracerName fTracerName;
    private final String fNameParameter;

    public TraceAnnotatedMethodsIfFlaggedDirective(String source, int lineNumber, FlagName flagName, IClassName className, TracerName tracerName, String nameParameter) {
        super(source, lineNumber);
        this.fFlagName = flagName;
        this.fClassName = className;
        this.fTracerName = tracerName;
        this.fNameParameter = nameParameter;
    }

    private FlagName getFlagName() {
        return this.fFlagName;
    }

    private IClassName getClassName() {
        return this.fClassName;
    }

    private TracerName getTracerName() {
        return this.fTracerName;
    }

    private String getNameParameter() {
        return this.fNameParameter;
    }

    protected void applyToSettings(CompilerSettingsBuilder builder) {
        TracerGroupBuilder flag = builder.getTracerGroupBuilder(this.getFlagName());
        builder.addTracer(new MethodTracerBuilder(this.getSource(), this.getLineNumber(), flag.getClassMatcher(), (IMethodMatcher)new AnnotationMethodMatcher(this.getClassName()), this.getTracerName(), this.getNameParameter(), flag));
        flag.setSource(this.getSource());
    }
}

