/*
 * Decompiled with CFR 0.152.
 */
package com.wily.diagnos.personality.java.classfile.attributes;

import com.wily.diagnos.cmp.classfile.DGClassLoadingException;
import com.wily.diagnos.cmp.classfile.DGClassModificationException;
import com.wily.diagnos.personality.java.classfile.attributes.DGAttribute;
import com.wily.diagnos.personality.java.classfile.attributes.DGChangeListener;
import com.wily.diagnos.personality.java.classfile.attributes.DGWilyAttributeCurrent;
import com.wily.diagnos.personality.java.classfile.constants.DGConstantPool;
import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.DataInputStream;
import java.io.DataOutputStream;
import java.io.FilterInputStream;
import java.io.IOException;

public class DGWilyAttribute
extends DGAttribute
implements DGChangeListener {
    public static final String kWilyAttributeName = "com.wilytech.WilyAttribute";
    private DGConstantPool fConstantPool;
    private DGWilyAttributeCurrent fCurrentData;
    private boolean fDirty;

    public DGWilyAttribute(DGConstantPool constantPool, int nameIndex, String name, byte[] data) throws DGClassLoadingException, IOException {
        super(nameIndex, name, data);
        this.fDirty = false;
        this.load(constantPool);
    }

    public DGWilyAttribute(DGConstantPool constantPool, String identificationInfo) throws DGClassModificationException, IOException {
        super(-1, kWilyAttributeName, null);
        this.fDirty = true;
        this.create(constantPool, identificationInfo);
    }

    private void load(DGConstantPool constantPool) throws DGClassLoadingException, IOException {
        this.initialize(constantPool, null);
        FilterInputStream input = null;
        try {
            input = new DataInputStream(new ByteArrayInputStream(this.fAttribData));
            this.fCurrentData.loadData((DataInputStream)input);
        }
        finally {
            if (input != null) {
                input.close();
            }
        }
        this.fCurrentData.addChangeListener(this);
    }

    private void create(DGConstantPool constantPool, String identificationInfo) throws DGClassModificationException, IOException {
        this.initialize(constantPool, identificationInfo);
        this.fCPI_name = this.fConstantPool.addUtf(this.getName());
        this.fCurrentData.addChangeListener(this);
    }

    private void initialize(DGConstantPool constantPool, String identificationInfo) {
        this.fConstantPool = constantPool;
        this.fCurrentData = new DGWilyAttributeCurrent(identificationInfo);
    }

    public void write(DataOutputStream out) throws IOException {
        if (this.fDirty) {
            ByteArrayOutputStream byteStore = new ByteArrayOutputStream();
            DataOutputStream internalOut = new DataOutputStream(byteStore);
            this.fCurrentData.write(internalOut);
            internalOut.flush();
            this.fAttribData = byteStore.toByteArray();
            this.fDirty = false;
        }
        super.write(out);
    }

    public void stateChanged() {
        this.fDirty = true;
    }

    public boolean canUndoChanges() {
        return false;
    }

    public void undoChanges() throws DGClassModificationException {
    }
}

