/*
 * Decompiled with CFR 0.152.
 */
package com.wily.diagnos.personality.java.classfile.attributes.stackmapframe;

import com.wily.diagnos.personality.java.classfile.attributes.stackmapframe.DGStackMapFrame;
import com.wily.diagnos.personality.java.classfile.attributes.stackmapframe.DGVerificationTypeInfoArray;
import java.io.DataInputStream;
import java.io.DataOutputStream;
import java.io.IOException;

public class DGAppendFrame
extends DGStackMapFrame {
    private int fLocalsAppended;
    private DGVerificationTypeInfoArray fLocals;
    public static final int kFrameTagBase = 252;
    public static final int kFrameTagMax = 254;
    private static final int kFrameTagOffset = 251;
    private static final int kFrameSize = 3;

    public DGAppendFrame(DataInputStream data, int frameType, int prevOffset) throws IOException {
        super(prevOffset);
        this.fLocalsAppended = frameType - 251;
        int offsetDelta = data.readUnsignedShort();
        this.setOffsetDelta(offsetDelta);
        this.fLocals = new DGVerificationTypeInfoArray(this.fLocalsAppended, data);
    }

    public DGVerificationTypeInfoArray getLocals() {
        return this.fLocals;
    }

    public String toString() {
        return "Append(offset=" + this.getOffset() + ", delta=" + this.getOffsetDelta() + ", locals=" + this.getLocals() + ")";
    }

    public void write(DataOutputStream out) throws IOException {
        out.writeByte(251 + this.fLocalsAppended);
        out.writeShort(this.getOffsetDelta());
        this.fLocals.write(out);
    }

    public int size() {
        return 3 + this.fLocals.size();
    }

    protected DGVerificationTypeInfoArray adjustLocals(DGVerificationTypeInfoArray locals) {
        return new DGVerificationTypeInfoArray(locals, this.fLocals);
    }

    protected DGVerificationTypeInfoArray adjustStack(DGVerificationTypeInfoArray stack) {
        return new DGVerificationTypeInfoArray(0);
    }

    protected boolean updateUninitializedTypeOffset(int pc, int delta) {
        return this.fLocals.updateUninitializedVariableOffset(pc, delta);
    }
}

