/*
 * Decompiled with CFR 0.152.
 */
package com.wily.diagnos.personality.java.classfile.constants;

import com.wily.diagnos.cmp.classfile.DGClassLoadingException;
import com.wily.diagnos.personality.java.classfile.DGClassConstants;
import com.wily.diagnos.personality.java.classfile.constants.DGClassConstant;
import com.wily.diagnos.personality.java.classfile.constants.DGConstantPool;
import com.wily.diagnos.personality.java.classfile.constants.DGDoubleConstant;
import com.wily.diagnos.personality.java.classfile.constants.DGFieldMethodRefConstant;
import com.wily.diagnos.personality.java.classfile.constants.DGFloatConstant;
import com.wily.diagnos.personality.java.classfile.constants.DGIntegerConstant;
import com.wily.diagnos.personality.java.classfile.constants.DGInvokeDynamicConstant;
import com.wily.diagnos.personality.java.classfile.constants.DGLongConstant;
import com.wily.diagnos.personality.java.classfile.constants.DGMethodHandleConstant;
import com.wily.diagnos.personality.java.classfile.constants.DGMethodTypeConstant;
import com.wily.diagnos.personality.java.classfile.constants.DGNameAndTypeConstant;
import com.wily.diagnos.personality.java.classfile.constants.DGStringConstant;
import com.wily.diagnos.personality.java.classfile.constants.DGUnknownConstantTypeException;
import com.wily.diagnos.personality.java.classfile.constants.DGUtf8Constant;
import java.io.DataInputStream;
import java.io.DataOutputStream;
import java.io.IOException;

public abstract class DGConstant
implements DGClassConstants,
Cloneable {
    protected int fTag;
    protected DGConstantPool fPool;
    protected int fIndex;

    public static DGConstant createConstant(DGConstantPool constantPool, int index, DataInputStream in) throws DGUnknownConstantTypeException, IOException {
        DGConstant wrConstant;
        int tag = in.readUnsignedByte();
        switch (tag) {
            case 1: {
                wrConstant = new DGUtf8Constant(constantPool, in);
                break;
            }
            case 3: {
                wrConstant = new DGIntegerConstant(constantPool, in);
                break;
            }
            case 4: {
                wrConstant = new DGFloatConstant(constantPool, in);
                break;
            }
            case 5: {
                wrConstant = new DGLongConstant(constantPool, in);
                break;
            }
            case 6: {
                wrConstant = new DGDoubleConstant(constantPool, in);
                break;
            }
            case 7: {
                wrConstant = new DGClassConstant(constantPool, in);
                break;
            }
            case 8: {
                wrConstant = new DGStringConstant(constantPool, in);
                break;
            }
            case 9: 
            case 10: 
            case 11: {
                wrConstant = new DGFieldMethodRefConstant(tag, constantPool, in);
                break;
            }
            case 12: {
                wrConstant = new DGNameAndTypeConstant(constantPool, in);
                break;
            }
            case 15: {
                wrConstant = new DGMethodHandleConstant(constantPool, in);
                break;
            }
            case 16: {
                wrConstant = new DGMethodTypeConstant(constantPool, in);
                break;
            }
            case 18: {
                wrConstant = new DGInvokeDynamicConstant(constantPool, in);
                break;
            }
            default: {
                throw new DGUnknownConstantTypeException(tag);
            }
        }
        wrConstant.fIndex = index;
        return wrConstant;
    }

    public DGConstant cloneToAppend(DGConstantPool newPool, int delta) {
        try {
            DGConstant constant = (DGConstant)this.clone();
            constant.fPool = newPool;
            constant.adjustIndices(delta - 1);
            return constant;
        }
        catch (Exception exception) {
            return null;
        }
    }

    public int getTag() {
        return this.fTag;
    }

    public int getIndex() {
        return this.fIndex;
    }

    protected DGConstant(DGConstantPool constantPool, int tag) {
        this.fPool = constantPool;
        this.fTag = tag;
    }

    public abstract void validate() throws DGClassLoadingException;

    public abstract void write(DataOutputStream var1) throws IOException;

    public void adjustIndices(int delta) {
        this.adjustIndices(delta, 0);
    }

    public void adjustIndices(int delta, int base) {
        if (this.fIndex > base) {
            this.fIndex += delta;
        }
    }
}

