/*
 * Decompiled with CFR 0.152.
 */
package com.wily.introscope.agent.blame;

import com.wily.introscope.agent.ACommonAgent;
import com.wily.introscope.agent.IAgent;
import com.wily.introscope.agent.blame.BasicBlameStackAllocator;
import com.wily.introscope.agent.blame.BoundaryBlameStackAllocator;
import com.wily.introscope.agent.blame.CompoundBlameStack;
import com.wily.introscope.agent.blame.IAllocatorChangeListener;
import com.wily.introscope.agent.blame.IAppMapStack;
import com.wily.introscope.agent.blame.IBlameStack;
import com.wily.introscope.agent.blame.IBlameStackAllocator;
import com.wily.introscope.agent.blame.IBoundaryBlameStack;
import com.wily.introscope.agent.blame.IComponentParameterCallback;
import com.wily.introscope.agent.blame.IStackType;
import com.wily.introscope.agent.blame.NullBlameStack;
import com.wily.introscope.agent.blame.NullBoundaryBlameStackHelperProvider;
import com.wily.introscope.agent.blame.TracerSamplingHelper;
import com.wily.introscope.agent.blamestackfeature.BlameStackFeatureBlameStackAllocator;
import com.wily.introscope.agent.blamestackfeature.IBlameStackFeatureAdministrator;
import com.wily.introscope.agent.blamestackfeature.IBlameStackFeatureFactory;
import com.wily.introscope.agent.blamestackfeature.IFeatureChangeListener;
import com.wily.introscope.agent.correlation.CrossProcessCorrelationAdmin;
import com.wily.introscope.agent.probe.net.DefaultBackendFeatureFactory;
import com.wily.introscope.agent.trace.InvocationData;
import com.wily.introscope.agent.trace.cas.IBoundaryBlameStackHelperProvider;
import com.wily.introscope.agent.transactiontrace.ITransactionEnvironment;
import com.wily.introscope.agent.transactiontrace.SharedCrossProcessData;
import com.wily.introscope.stat.blame.BlameStackSnapshot;
import com.wily.introscope.stat.blame.BlameStackSnapshotPolicy;
import com.wily.util.clock.MasterClock;
import com.wily.util.properties.IndexedProperties;
import com.wily.wilyassert.Assertion;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;

public final class ComponentTracer
implements IBlameStackFeatureAdministrator,
IAllocatorChangeListener,
ITransactionEnvironment {
    private IAgent fAgent;
    public static final String kNoComponent = null;
    private static final ThreadLocal fStackReference = new ThreadLocal();
    private static final ThreadLocal fURLContextIndicator = new ThreadLocal(){

        protected Object initialValue() {
            return Boolean.FALSE;
        }
    };
    private static final ThreadLocal fEJBContextIndicator = new ThreadLocal(){

        protected Object initialValue() {
            return Boolean.FALSE;
        }
    };
    private IBlameStackAllocator fDefaultBlameStackAllocator;
    private boolean fAddedDefaultFeatureFactory;
    private final TimestampedAllocatorList fBlameStackAllocators;
    private BlameStackSnapshotPolicy fSnapshotPolicy;
    private boolean fUseBoundaryBlame;
    private List fFeatureChangeListeners;
    private static List featureFactories = new ArrayList();
    private final boolean fAgentOldMode;
    private final TracerSamplingHelper fSamplingHelper;
    private static volatile IBoundaryBlameStackHelperProvider defaultProvider = new NullBoundaryBlameStackHelperProvider();

    public ComponentTracer(IAgent agent, BlameStackSnapshotPolicy snapshotPolicy) {
        this.fAgent = agent;
        this.fBlameStackAllocators = new TimestampedAllocatorList();
        this.fSnapshotPolicy = snapshotPolicy;
        this.fFeatureChangeListeners = new ArrayList(2);
        this.fSamplingHelper = new TracerSamplingHelper(agent);
        this.fAgentOldMode = agent instanceof ACommonAgent ? (Boolean)((ACommonAgent)this.fAgent).fAgentBlameConfigurationOldProperty.getValue() : true;
    }

    public synchronized void addBlameStackAllocator(IBlameStackAllocator allocator) {
        Assertion.wilyAssert(false);
        this.fBlameStackAllocators.addBlameStackAllocator(allocator);
        allocator.addAllocatorChangeListener(this);
    }

    public synchronized void removeBlameStackAllocator(IBlameStackAllocator allocator) {
        Assertion.wilyAssert(false);
        this.fBlameStackAllocators.removeBlameStackAllocator(allocator);
    }

    public boolean getHeadFilteringStatus() {
        return this.getHeadFilteringStatus(this.getCurrentThreadStack());
    }

    public boolean getHeadFilteringStatus(IBlameStack stack) {
        if (stack == null) {
            return false;
        }
        return stack.getHeadFilteringStatus();
    }

    public boolean shouldCurrentTraceBePropagated() {
        return this.shouldCurrentTraceBePropagated(this.getCurrentThreadStack());
    }

    public boolean shouldCurrentTraceBePropagated(IBlameStack stack) {
        if (stack == null) {
            return false;
        }
        return stack.shouldCurrentTraceBePropagated();
    }

    public final void addComponent(String component) {
        this.addComponent(this.getCurrentThreadStack(true), component);
    }

    public final void addComponent(IBlameStack stack, String component) {
        stack.IBlameStack_addComponent(component);
    }

    public final void addComponent(String component, String paramName, String paramValue) {
        this.addComponent(this.getCurrentThreadStack(true), component, paramName, paramValue);
    }

    public final void addComponent(IBlameStack stack, String component, String paramName, String paramValue) {
        stack.IBlameStack_addComponent(component, paramName, paramValue);
    }

    public final void addComponent(String component, IComponentParameterCallback callback) {
        this.addComponent(this.getCurrentThreadStack(true), component, callback);
    }

    public final void addComponent(IBlameStack stack, String component, IComponentParameterCallback callback) {
        stack.IBlameStack_addComponent(component, callback);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void addFeatureChangeListener(IFeatureChangeListener listener) {
        List list = this.fFeatureChangeListeners;
        synchronized (list) {
            this.fFeatureChangeListeners.add(listener);
        }
    }

    public void addExtraParameter(String paramName, String paramValue) {
        this.addExtraParameter(this.getCurrentThreadStack(), paramName, paramValue);
    }

    public void addExtraParameter(IBlameStack blameStack, String paramName, String paramValue) {
        if (blameStack != null) {
            if (paramValue == null) {
                paramValue = "";
            }
            blameStack.IBlameStack_addExtraParameter(paramName, paramValue);
        }
    }

    public void addCorrelationParameter(String key, String value) {
        if (key != null && value != null) {
            if (!key.startsWith("Cor")) {
                key = "Cor" + key;
            }
            this.addRootParameter(key, value);
        } else {
            this.fAgent.IAgent_getModuleFeedback().warn("Internal error: attempt to add correlation parameter with null key: operation will be ignored.");
        }
    }

    public final void addRootParameter(String key, String value) {
        this.addRootParameter(this.getCurrentThreadStack(), key, value);
    }

    public final void addRootParameter(IBlameStack stack, String key, String value) {
        if (stack != null) {
            if (!stack.IBlameStack_isEmpty()) {
                stack.addRootParameter(key, value);
            } else {
                this.fAgent.IAgent_getModuleFeedback().debug("Internal error: attempt to add parameter when blame stack is empty: operation will be ignored.");
            }
        }
    }

    public final void removeComponent(String component) {
        this.removeComponent(this.getCurrentThreadStack(), component);
    }

    public final void removeComponent(IBlameStack stack, String component) {
        if (stack != null) {
            stack.IBlameStack_removeComponent(component);
            if (stack.IBlameStack_isEmpty()) {
                this.internalTeardown(stack);
                if (this.fAgent.IAgent_getModuleFeedback().isTraceEnabled()) {
                    this.fAgent.IAgent_getModuleFeedback().trace("Remove component for component " + component + " on Thread " + Thread.currentThread().getName() + " invalidating cross process cache ");
                }
            } else if (this.fAgent.IAgent_getModuleFeedback().isTraceEnabled()) {
                this.fAgent.IAgent_getModuleFeedback().trace("Remove component for component " + component + " on Thread " + Thread.currentThread().getName() + " Stack not empty " + stack.toString());
            }
        }
    }

    public final void setBackend(String component) {
        this.setBackend(this.getCurrentThreadStack(true), component);
    }

    public final void setBackend(IBlameStack stack, String component) {
        stack.setEndBoundary(component);
    }

    public final void setFrontend(String component) {
        this.setFrontend(this.getCurrentThreadStack(), component);
    }

    public final void setFrontend(IBlameStack stack, String component) {
        Assertion.wilyAssert(false);
        if (stack != null) {
            stack.setFrontBoundary(component);
        }
    }

    public final boolean hasFrontend() {
        return this.hasFrontend(this.getCurrentThreadStack());
    }

    public final boolean hasFrontend(IBlameStack stack) {
        return stack != null && stack.hasFrontBoundary();
    }

    public void frontBoundaryPopped(String component) {
    }

    public void endBoundaryPopped(String component) {
    }

    public final void setComponentMetricPropagateFlag(String component, int flag) {
        this.setComponentMetricPropagateFlag(this.getCurrentThreadStack(), component, flag);
    }

    public final void setComponentMetricPropagateFlag(IBlameStack stack, String component, int flag) {
        if (stack != null && stack instanceof IBoundaryBlameStack) {
            ((IBoundaryBlameStack)((Object)stack)).setComponentMetricPropagateFlag(component, flag);
        }
    }

    public final void addMapComponent(IStackType type, String component) {
        this.addMapComponent(this.getCurrentThreadStack(true), type, component);
    }

    public final void addMapComponent(IBlameStack stack, IStackType type, String component) {
        stack.addMapComponent(type, component);
    }

    public final void addMapComponent(IStackType type, String component, String paramName, String paramVal) {
        this.addMapComponent(this.getCurrentThreadStack(true), type, component, paramName, paramVal);
    }

    public final void addMapComponent(IBlameStack stack, IStackType type, String component, String paramName, String paramVal) {
        stack.addMapComponent(type, component, paramName, paramVal);
    }

    public final void addMapComponent(IStackType type, String component, HashMap params) {
        this.addMapComponent(this.getCurrentThreadStack(true), type, component, params);
    }

    public final void addMapComponent(IBlameStack stack, IStackType type, String component, HashMap params) {
        stack.addMapComponent(type, component, params);
    }

    public void teardown() {
        IBlameStack stack = this.getCurrentThreadStack(false);
        if (stack != null) {
            this.internalTeardown(stack);
        }
    }

    public final void removeMapComponent(IStackType type, String component) {
        this.removeMapComponent(this.getCurrentThreadStack(true), type, component);
    }

    public final void removeMapComponent(IBlameStack stack, IStackType type, String component) {
        if (stack != null) {
            stack.removeMapComponent(type, component);
            this.checkEmptyStack(component, stack);
        }
    }

    public final void removeMapComponent(IStackType type, String component, IComponentParameterCallback callback) {
        this.removeMapComponent(this.getCurrentThreadStack(true), type, component, callback);
    }

    public final void removeMapComponent(IBlameStack stack, IStackType type, String component, IComponentParameterCallback callback) {
        if (stack != null && stack instanceof IAppMapStack) {
            ((IAppMapStack)stack).removeMapComponent(type, component, callback);
            this.checkEmptyStack(component, stack);
        }
    }

    private final void checkEmptyStack(String component, IBlameStack stack) {
        if (stack.IBlameStack_isEmpty()) {
            this.internalTeardown(stack);
        } else if (this.fAgent.IAgent_getModuleFeedback().isTraceEnabled()) {
            this.fAgent.IAgent_getModuleFeedback().trace("Remove Map component for component " + component + " on Thread " + Thread.currentThread().getName() + " Stack not empty " + stack.toString());
        }
    }

    private final void internalTeardown(IBlameStack stack) {
        stack.IBlameStack_tearDown();
        ComponentTracerThreadLocal tLocal = (ComponentTracerThreadLocal)fStackReference.get();
        tLocal.teardownStacks();
        if (this.isAgentOldMode()) {
            CrossProcessCorrelationAdmin.invalidateCrossProcessDataCache();
        }
        this.invalidateCrossProcessDataCache();
    }

    public final BlameStackSnapshot getSnapshot(String component) {
        return this.getSnapshot(this.getCurrentThreadStack(), component);
    }

    public final BlameStackSnapshot getSnapshot(IBlameStack stack, String component) {
        if (stack != null) {
            return stack.IBlameStack_getSnapshot(component);
        }
        return BlameStackSnapshot.kEmptyBlameStackSnapshot;
    }

    public static final SharedCrossProcessData staticGetCrossProcessDataCache() {
        return CrossProcessCorrelationAdmin.getCrossProcessCorrelationCache();
    }

    public final SharedCrossProcessData getCrossProcessDataCache() {
        return CrossProcessCorrelationAdmin.getCrossProcessCorrelationCache();
    }

    public void invalidateCrossProcessDataCache() {
        Assertion.wilyAssert(false, "This method is deprecated and calling this method is a NOOP");
    }

    public final IBlameStack getCurrentThreadStack() {
        return this.getCurrentThreadStack(false);
    }

    public final IBlameStack getCurrentThreadStack(boolean createIfNecessary) {
        IBlameStack stack = null;
        ComponentTracerThreadLocal tLocal = (ComponentTracerThreadLocal)fStackReference.get();
        if (tLocal == null && (createIfNecessary || !this.isAgentOldMode())) {
            tLocal = new ComponentTracerThreadLocal(this.fDefaultBlameStackAllocator);
            fStackReference.set(tLocal);
            if (!this.isAgentOldMode()) {
                createIfNecessary = true;
            }
        }
        if (tLocal != null) {
            stack = tLocal.getThreadStack(this.fBlameStackAllocators, this.fSnapshotPolicy, createIfNecessary);
        }
        return stack;
    }

    public void initializeBlame() {
        String blameType;
        IndexedProperties props = this.fAgent.IAgent_getIndexedProperties();
        this.fUseBoundaryBlame = true;
        if (props != null && (blameType = props.getProperty("introscope.agent.blame.type")) != null) {
            this.fUseBoundaryBlame = blameType.equalsIgnoreCase("boundary");
        }
        this.setUseBoundaryBlame(this.fUseBoundaryBlame);
    }

    public void setUseBoundaryBlame(boolean useBoundaryBlame) {
        if (useBoundaryBlame) {
            BoundaryBlameStackAllocator boundaryStackAllocator = new BoundaryBlameStackAllocator(this);
            this.fDefaultBlameStackAllocator = boundaryStackAllocator;
            this.addFeatureChangeListener(boundaryStackAllocator);
            boundaryStackAllocator.addAllocatorChangeListener(this);
            if (!this.fAddedDefaultFeatureFactory) {
                this.addFeatureFactory(new DefaultBackendFeatureFactory());
                this.fAddedDefaultFeatureFactory = true;
            }
        } else {
            BasicBlameStackAllocator basicStackAllocator = new BasicBlameStackAllocator(this);
            this.fDefaultBlameStackAllocator = basicStackAllocator;
            this.addFeatureChangeListener(basicStackAllocator);
            basicStackAllocator.addAllocatorChangeListener(this);
        }
        this.fBlameStackAllocators.addBlameStackAllocator(this.fDefaultBlameStackAllocator);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void addFeatureFactory(IBlameStackFeatureFactory featureFactory) {
        List list = featureFactories;
        synchronized (list) {
            featureFactories.add(featureFactory);
        }
        list = this.fFeatureChangeListeners;
        synchronized (list) {
            for (IFeatureChangeListener listener : this.fFeatureChangeListeners) {
                listener.featureListChanged(this);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void removeFeatureFactory(IBlameStackFeatureFactory featureFactory) {
        List list = featureFactories;
        synchronized (list) {
            featureFactories.remove(featureFactory);
        }
        list = this.fFeatureChangeListeners;
        synchronized (list) {
            for (IFeatureChangeListener listener : this.fFeatureChangeListeners) {
                listener.featureListChanged(this);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public List getFeatureFactories() {
        List list = featureFactories;
        synchronized (list) {
            return new ArrayList(featureFactories);
        }
    }

    public void registerBlameStackFeatureService() {
        if (!this.fUseBoundaryBlame) {
            this.addBlameStackAllocator(new BlameStackFeatureBlameStackAllocator(this));
        }
    }

    public boolean noteBoundaryError() {
        IBlameStack bs;
        boolean result = false;
        if (this.isAgentOldMode() && this.fUseBoundaryBlame && (bs = this.getCurrentThreadStack()) != null) {
            result = bs.noteBoundaryError() | result;
        }
        return result;
    }

    public final String[] getDefaultBackendData() {
        if (this.fUseBoundaryBlame) {
            return this.getDefaultBackendData(this.getCurrentThreadStack());
        }
        return null;
    }

    public final String[] getDefaultBackendData(IBlameStack bs) {
        String[] result = null;
        if (this.fUseBoundaryBlame && bs != null) {
            result = bs.getDefaultBackendData();
        }
        return result;
    }

    public final void setDefaultBackendComponent(String componentToReplace, String backendComponent) {
        IBlameStack bs;
        if (this.fUseBoundaryBlame && (bs = this.getCurrentThreadStack()) != null) {
            bs.setDefaultBackendComponent(componentToReplace, backendComponent);
        }
    }

    public final BlameStackSnapshot getDefaultBackendSnapshot() {
        if (this.fUseBoundaryBlame) {
            return this.getDefaultBackendSnapshot(this.getCurrentThreadStack());
        }
        return null;
    }

    public final BlameStackSnapshot getDefaultBackendSnapshot(IBlameStack bs) {
        BlameStackSnapshot result = null;
        if (this.fUseBoundaryBlame && bs != null) {
            result = bs.getDefaultBackendSnapshot();
        }
        return result;
    }

    public final void allocatorChanged(IBlameStackAllocator allocator) {
        this.fBlameStackAllocators.allocatorChanged(allocator);
    }

    public final boolean isURLTracingContext() {
        Boolean indicator = (Boolean)fURLContextIndicator.get();
        return indicator;
    }

    public final void setInURLTracingContext() {
        fURLContextIndicator.set(Boolean.TRUE);
    }

    public final void clearInURLTracingContext() {
        fURLContextIndicator.set(Boolean.FALSE);
    }

    public final boolean isEJBTracingContext() {
        Boolean indicator = (Boolean)fEJBContextIndicator.get();
        return indicator;
    }

    public final void setInEJBTracingContext() {
        fEJBContextIndicator.set(Boolean.TRUE);
    }

    public final void clearInEJBTracingContext() {
        fEJBContextIndicator.set(Boolean.FALSE);
    }

    public int debug_getBlameStackAllocatorCount() {
        return this.fBlameStackAllocators.size() + 1;
    }

    public IBlameStackAllocator debug_getDefaultBlameStackAllocator() {
        return this.fDefaultBlameStackAllocator;
    }

    IBlameStack debug_getCurrentThreadStack() {
        return this.getCurrentThreadStack(true);
    }

    public void debug_reinitialize() {
        fStackReference.set(null);
    }

    public final boolean peekLastMapComponentWasMe(IStackType stackType, String component) {
        return this.peekLastMapComponentWasMe(this.getCurrentThreadStack(true), stackType, component);
    }

    public final boolean peekLastMapComponentWasMe(IBlameStack stack, IStackType stackType, String component) {
        if (stack != null && stack instanceof IAppMapStack) {
            return ((IAppMapStack)stack).peekLastMapComponentWasMe(stackType, component);
        }
        return false;
    }

    public final boolean getSamplingSkipFlag(IBlameStack stack) {
        return this.fSamplingHelper.getSamplingSkipFlag(stack);
    }

    public final boolean checkSamplingCounter() {
        return this.fSamplingHelper.checkSamplingCounter();
    }

    public final void setSamplingSkipFlag(IBlameStack stack, boolean b) {
        this.fSamplingHelper.setSamplingSkipFlag(stack, b);
    }

    public final boolean setSamplingTracer(InvocationData data, int tracerIndex) {
        return this.fSamplingHelper.setSamplingTracer(data, tracerIndex);
    }

    public void popMapComponent(IBlameStack stack, IStackType stackType, String component) {
        stack.popMapComponent(stackType, component);
    }

    public final boolean isAgentOldMode() {
        return this.fAgentOldMode;
    }

    public static void setDefaultBoundaryBlameStackHelperProvider(IBoundaryBlameStackHelperProvider defaultProvider) {
        ComponentTracer.defaultProvider = defaultProvider;
    }

    public static IBoundaryBlameStackHelperProvider getDefaultBoundaryBlameStackHelperProvider() {
        return defaultProvider;
    }

    private static class AllocatorListElement {
        IBlameStackAllocator allocator;
        long timestamp;

        AllocatorListElement(IBlameStackAllocator allocator, long timestamp) {
            this.allocator = allocator;
            this.setTimestamp(timestamp);
        }

        void setTimestamp(long timestamp) {
            this.timestamp = timestamp;
        }
    }

    private static class ComponentTracerThreadLocal {
        private IBlameStackAllocator defaultAllocator;
        private IBlameStack defaultStack;
        private CompoundBlameStack compoundStack;
        private IBlameStack currentThreadStack;
        private long timestamp;
        private boolean hasCompoundDelegates;
        private boolean hasTorndown;

        ComponentTracerThreadLocal(IBlameStackAllocator defaultAllocator) {
            this.defaultAllocator = defaultAllocator;
            this.timestamp = -1L;
            this.currentThreadStack = null;
            this.hasTorndown = true;
        }

        public void teardownStacks() {
            this.hasTorndown = true;
        }

        void setDefaultAllocator(IBlameStackAllocator defaultAllocator) {
            this.defaultAllocator = defaultAllocator;
        }

        private boolean update(TimestampedAllocatorList timestampedAllocatorList, BlameStackSnapshotPolicy policy) {
            boolean result = false;
            if (this.defaultAllocator != null) {
                result = true;
                boolean hasUpdated = false;
                if (this.hasAnyAllocatorChanged(timestampedAllocatorList)) {
                    if (this.hasAllocatorListSizeChanged(timestampedAllocatorList)) {
                        this.updateFullBlameStack(timestampedAllocatorList, policy);
                        hasUpdated = true;
                    } else {
                        int allocatorListSize = timestampedAllocatorList.size();
                        int i = 0;
                        while (i < allocatorListSize) {
                            AllocatorListElement elem = timestampedAllocatorList.getElementAt(i);
                            if (this.timestamp < elem.timestamp) {
                                IBlameStack newlyAllocatedStack = timestampedAllocatorList.allocateStackAt(i, policy);
                                this.updateDelegateStackAt(i, newlyAllocatedStack);
                                if (elem.allocator.equals(this.defaultAllocator)) {
                                    this.defaultStack = newlyAllocatedStack;
                                    this.compoundStack.setDefaultDelegate(this.defaultStack);
                                }
                                hasUpdated = true;
                            }
                            ++i;
                        }
                    }
                }
                if (hasUpdated) {
                    this.timestamp = MasterClock.currentTimeMillis();
                }
            }
            return result;
        }

        private void updateDelegateStackAt(int i, IBlameStack newlyAllocatedStack) {
            this.compoundStack.setDelegateAt(i, newlyAllocatedStack);
        }

        private boolean hasAllocatorListSizeChanged(TimestampedAllocatorList timestampedAllocatorList) {
            return this.timestamp < timestampedAllocatorList.listSizeTimestamp;
        }

        private boolean hasAnyAllocatorChanged(TimestampedAllocatorList timestampedAllocatorList) {
            return this.timestamp < timestampedAllocatorList.allocatorChangeTimestamp;
        }

        private boolean updateFullBlameStack(TimestampedAllocatorList timestampedAllocatorList, BlameStackSnapshotPolicy policy) {
            boolean result = false;
            this.hasCompoundDelegates = false;
            if (this.defaultAllocator != null) {
                result = true;
                this.timestamp = timestampedAllocatorList.listSizeTimestamp;
                if (this.compoundStack == null) {
                    this.compoundStack = new CompoundBlameStack();
                } else {
                    this.compoundStack.clearDelegates();
                }
                int i = 0;
                while (i < timestampedAllocatorList.size()) {
                    IBlameStack stack = timestampedAllocatorList.allocateStackAt(i, policy);
                    this.compoundStack.addDelegate(stack);
                    AllocatorListElement elem = timestampedAllocatorList.getElementAt(i);
                    if (elem.allocator.equals(this.defaultAllocator)) {
                        this.defaultStack = stack;
                        this.compoundStack.setDefaultDelegate(this.defaultStack);
                    }
                    this.hasCompoundDelegates = true;
                    ++i;
                }
            }
            return result;
        }

        IBlameStack getThreadStack(TimestampedAllocatorList timestampedAllocatorList, BlameStackSnapshotPolicy policy, boolean createIfNecessary) {
            if (this.hasTorndown && createIfNecessary) {
                if (this.update(timestampedAllocatorList, policy)) {
                    this.currentThreadStack = !this.hasCompoundDelegates ? this.defaultStack : this.compoundStack;
                } else {
                    this.currentThreadStack = NullBlameStack.getInstance();
                    this.hasCompoundDelegates = false;
                    this.defaultStack = this.currentThreadStack;
                }
                this.hasTorndown = false;
            }
            return this.currentThreadStack;
        }
    }

    private static class TimestampedAllocatorList
    implements IAllocatorChangeListener {
        long listSizeTimestamp;
        long allocatorChangeTimestamp;
        List allocators = new ArrayList();

        TimestampedAllocatorList() {
            this.allocatorChangeTimestamp = this.listSizeTimestamp = MasterClock.currentTimeMillis();
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        void addBlameStackAllocator(IBlameStackAllocator allocator) {
            List list = this.allocators;
            synchronized (list) {
                this.allocatorChangeTimestamp = this.listSizeTimestamp = MasterClock.currentTimeMillis();
                this.allocators.add(new AllocatorListElement(allocator, this.listSizeTimestamp));
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        void removeBlameStackAllocator(IBlameStackAllocator allocator) {
            List list = this.allocators;
            synchronized (list) {
                Iterator it = this.allocators.iterator();
                boolean wasRemoved = false;
                while (!wasRemoved && it.hasNext()) {
                    AllocatorListElement elem = (AllocatorListElement)it.next();
                    if (!elem.allocator.equals(allocator)) continue;
                    it.remove();
                    wasRemoved = true;
                }
                if (wasRemoved) {
                    this.allocatorChangeTimestamp = this.listSizeTimestamp = MasterClock.currentTimeMillis();
                }
            }
        }

        public boolean contains(IBlameStackAllocator allocator) {
            return this.find(allocator) != null;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public void allocatorChanged(IBlameStackAllocator allocator) {
            List list = this.allocators;
            synchronized (list) {
                AllocatorListElement elem = this.find(allocator);
                if (elem != null) {
                    elem.timestamp = this.allocatorChangeTimestamp = MasterClock.currentTimeMillis();
                }
            }
        }

        private AllocatorListElement find(IBlameStackAllocator allocator) {
            AllocatorListElement result = null;
            int i = 0;
            while (result == null && i < this.allocators.size()) {
                AllocatorListElement elem = (AllocatorListElement)this.allocators.get(i);
                if (elem.allocator.equals(allocator)) {
                    result = elem;
                }
                ++i;
            }
            return result;
        }

        int size() {
            return this.allocators.size();
        }

        IBlameStack allocateStackAt(int index, BlameStackSnapshotPolicy policy) {
            Assertion.wilyAssert(false);
            AllocatorListElement elem = (AllocatorListElement)this.allocators.get(index);
            IBlameStack stack = elem.allocator.allocateBlameStack(policy);
            return stack;
        }

        public AllocatorListElement getElementAt(int i) {
            return (AllocatorListElement)this.allocators.get(i);
        }
    }
}

