/*
 * Decompiled with CFR 0.152.
 */
package com.wily.introscope.agent.dns;

import com.wily.introscope.agent.IAgent;
import com.wily.introscope.agent.dns.DnsQueryProviderDefault;
import com.wily.introscope.agent.dns.IDnsRawService;
import com.wily.introscope.agent.dns.IDnsService;
import com.wily.util.feedback.IModuleFeedbackChannel;
import com.wily.util.feedback.Module;
import com.wily.util.properties.hot.ConfigurationManager;
import com.wily.util.properties.hot.PositiveIntegerConfigurationProperty;
import java.net.InetAddress;
import java.util.concurrent.Callable;
import java.util.concurrent.ExecutionException;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Executors;
import java.util.concurrent.Future;
import java.util.concurrent.ThreadFactory;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.TimeoutException;
import java.util.concurrent.atomic.AtomicInteger;

public class DnsServiceExecutor
implements IDnsService {
    public static final Module kDnaServiceExecutor_LogName = new Module("DnsServiceExecutor");
    public static final int kDnsServiceExecutor_WaitInMs_Default = 200;
    private final IAgent fAgent;
    private final IModuleFeedbackChannel fFeedback;
    private final ExecutorService fExecutor;
    private final int fThreadPoolSize;
    private final IDnsRawService fDnsQueryProvider;
    private volatile int fWaitInMillisecondsMax;
    private volatile boolean fActive;
    private volatile boolean fTimeoutLogged;

    public DnsServiceExecutor(IAgent agent, Integer threadPoolSize) {
        this.fAgent = agent;
        this.fFeedback = this.fAgent.IAgent_getModuleFeedback();
        this.fThreadPoolSize = threadPoolSize;
        DnsServiceThreadFactory tf = new DnsServiceThreadFactory();
        this.fExecutor = Executors.newCachedThreadPool(tf);
        if (this.fFeedback == null) {
            throw new NullPointerException("fFeedback is null");
        }
        this.fDnsQueryProvider = new DnsQueryProviderDefault();
        this.fWaitInMillisecondsMax = 200;
        this.fActive = false;
        this.configureParameters();
    }

    private void configureParameters() {
        if (this.fAgent != null) {
            ConfigurationManager configurationManager = this.fAgent.IAgent_getConfigurationManager();
            PositiveIntegerConfigurationProperty waitTimeProperty = new PositiveIntegerConfigurationProperty("introscope.agent.dns.lookup.max.wait.in.milliseconds", new Integer(200), "Agent_DNS_WaitTime", this.fFeedback, kDnaServiceExecutor_LogName, this.fAgent.IAgent_getStringLocalizer()){

                @Override
                public void set(Object value) {
                    DnsServiceExecutor.this.setWaitInMillisecondsMax((Integer)value);
                }
            };
            configurationManager.add(waitTimeProperty, true);
        }
    }

    public boolean isActive() {
        return this.fActive;
    }

    @Override
    public void start() {
        this.fActive = true;
    }

    @Override
    public void stop() {
        if (this.fExecutor.isShutdown()) {
            this.fActive = false;
            return;
        }
        boolean timeOutHappened = false;
        try {
            this.fActive = false;
            this.fExecutor.shutdown();
            timeOutHappened = this.fExecutor.awaitTermination(this.fWaitInMillisecondsMax, TimeUnit.MILLISECONDS);
            if (timeOutHappened) {
                this.fExecutor.shutdownNow();
                this.fFeedback.warn(kDnaServiceExecutor_LogName, "timeout during normal DNS thread shut down. The DNS threads are forced to shut down");
            }
        }
        catch (InterruptedException ex) {
            this.fFeedback.error(kDnaServiceExecutor_LogName, ex.getMessage());
        }
        catch (Exception ex) {
            this.fFeedback.error(kDnaServiceExecutor_LogName, ex.getMessage());
        }
    }

    public int getWaitInMillisecondsMax() {
        return this.fWaitInMillisecondsMax;
    }

    public void setWaitInMillisecondsMax(int inValue) {
        this.fWaitInMillisecondsMax = inValue;
    }

    @Override
    public String getDnsHostNameByIPAddr(String ipAddress) throws TimeoutException {
        if (!this.fActive) {
            return ipAddress;
        }
        final String inIpAddress = ipAddress;
        Callable<String> dnsQuery = new Callable<String>(){

            @Override
            public String call() {
                String dnsName = DnsServiceExecutor.this.fDnsQueryProvider.getDnsHostNameByIPAddr(inIpAddress);
                return dnsName;
            }
        };
        Future<String> future = this.fExecutor.submit(dnsQuery);
        try {
            String returnedDnsName = future.get(this.fWaitInMillisecondsMax, TimeUnit.MILLISECONDS);
            return returnedDnsName;
        }
        catch (TimeoutException ex) {
            if (!this.fTimeoutLogged) {
                this.fFeedback.warn(kDnaServiceExecutor_LogName, "Failed to obtain host name in " + this.fWaitInMillisecondsMax + " ms. Consider changing property " + "introscope.agent.dns.lookup.max.wait.in.milliseconds");
                this.fTimeoutLogged = true;
            }
            throw ex;
        }
        catch (InterruptedException ex) {
            this.fFeedback.error(kDnaServiceExecutor_LogName, "get DNS name by IP address string " + ex.getMessage());
        }
        catch (ExecutionException ex) {
            this.fFeedback.error(kDnaServiceExecutor_LogName, "get DNS name by IP address string " + ex.getMessage());
        }
        future.cancel(true);
        return ipAddress;
    }

    @Override
    public String getDnsHostNameByIPAddr(InetAddress ipAddress) throws TimeoutException {
        if (!this.fActive) {
            try {
                return ipAddress.getHostAddress();
            }
            catch (Exception e) {
                this.fFeedback.info("Exception occured in DnsServiceExecutor.getDnsHostNameByIPAddr() ");
                this.fFeedback.debug(e);
                String defaultIP = this.fAgent.IAgent_getIndexedProperties().getProperty("introscope.agent.defaultIP", null);
                this.fFeedback.info("DnsServiceExecutor.getDnsHostNameByIPAddr() returning defaultIP = " + defaultIP);
                return defaultIP;
            }
        }
        final InetAddress inIpAddress = ipAddress;
        Callable<String> dnsQuery = new Callable<String>(){

            @Override
            public String call() {
                String dnsName = DnsServiceExecutor.this.fDnsQueryProvider.getDnsHostNameByIPAddr(inIpAddress);
                return dnsName;
            }
        };
        Future<String> future = this.fExecutor.submit(dnsQuery);
        try {
            String returnedDnsName = future.get(this.fWaitInMillisecondsMax, TimeUnit.MILLISECONDS);
            return returnedDnsName;
        }
        catch (TimeoutException ex) {
            if (!this.fTimeoutLogged) {
                this.fFeedback.warn(kDnaServiceExecutor_LogName, "Failed to obtain host name in " + this.fWaitInMillisecondsMax + " ms. Consider changing property " + "introscope.agent.dns.lookup.max.wait.in.milliseconds");
                this.fTimeoutLogged = true;
            }
            throw ex;
        }
        catch (InterruptedException ex) {
            this.fFeedback.warn(kDnaServiceExecutor_LogName, "get DNS name by IP address  " + ex.getMessage());
        }
        catch (ExecutionException ex) {
            this.fFeedback.warn(kDnaServiceExecutor_LogName, "get DNS name by IP address " + ex.getMessage());
        }
        future.cancel(true);
        try {
            return ipAddress.getHostAddress();
        }
        catch (Exception e) {
            this.fFeedback.info("Exception occured in DnsServiceExecutor.getDnsHostNameByIPAddr() ");
            this.fFeedback.debug(e);
            String defaultIP = this.fAgent.IAgent_getIndexedProperties().getProperty("introscope.agent.defaultIP", null);
            this.fFeedback.info("DnsServiceExecutor.getDnsHostNameByIPAddr() returning defaultIP = " + defaultIP);
            return defaultIP;
        }
    }

    @Override
    public InetAddress getIPAddressByDnsHostName(String dnsHostName) {
        if (!this.fActive) {
            return null;
        }
        final String inDnsName = dnsHostName;
        Callable<InetAddress> ipQuery = new Callable<InetAddress>(){

            @Override
            public InetAddress call() {
                InetAddress ipAddress = DnsServiceExecutor.this.fDnsQueryProvider.getIPAddressByDnsHostName(inDnsName);
                return ipAddress;
            }
        };
        Future<InetAddress> future = this.fExecutor.submit(ipQuery);
        try {
            InetAddress returnedIpAddress = future.get(this.fWaitInMillisecondsMax, TimeUnit.MILLISECONDS);
            return returnedIpAddress;
        }
        catch (TimeoutException timeoutException) {
            return null;
        }
        catch (InterruptedException ex) {
            this.fFeedback.error(kDnaServiceExecutor_LogName, "get IP address by DNS name " + ex.getMessage());
        }
        catch (ExecutionException ex) {
            this.fFeedback.error(kDnaServiceExecutor_LogName, "get IP address by DNS name" + ex.getMessage());
        }
        future.cancel(true);
        return null;
    }

    @Override
    public String trimDomain(String fqdn) {
        return this.fDnsQueryProvider.trimDomain(fqdn);
    }

    static class DnsServiceThreadFactory
    implements ThreadFactory {
        final ThreadGroup group;
        final AtomicInteger threadNumber = new AtomicInteger(1);

        DnsServiceThreadFactory() {
            SecurityManager s = System.getSecurityManager();
            this.group = s != null ? s.getThreadGroup() : Thread.currentThread().getThreadGroup();
        }

        @Override
        public Thread newThread(Runnable r) {
            Thread t = new Thread(this.group, r, "Agent DNS Service " + this.threadNumber.getAndIncrement(), 0L);
            t.setDaemon(true);
            if (t.getPriority() != 5) {
                t.setPriority(5);
            }
            return t;
        }
    }
}

