/*
 * Decompiled with CFR 0.152.
 */
package com.wily.introscope.agent.exception;

import java.io.OutputStream;
import java.io.PrintStream;

final class StackTracePrintStream
extends PrintStream {
    private static final String kLineSeparatorPropertyName = "line.separator";
    private final char[] fLineSeparator = System.getProperty("line.separator").toCharArray();
    private int fCursor = 0;
    private char[] fChars;
    private int fCharCount;

    public StackTracePrintStream(OutputStream dummy, int initialSize) {
        super(dummy);
        this.fChars = new char[initialSize];
        this.fCharCount = initialSize;
    }

    public synchronized void print(char[] data) {
        while (this.fCursor + data.length > this.fCharCount) {
            this.growBuffer();
        }
        System.arraycopy(data, 0, this.fChars, this.fCursor, data.length);
        this.fCursor += data.length;
    }

    public synchronized void print(String s) {
        if (s == null) {
            s = "null";
        }
        int length = s.length();
        while (this.fCursor + length > this.fCharCount) {
            this.growBuffer();
        }
        s.getChars(0, length, this.fChars, this.fCursor);
        this.fCursor += length;
    }

    public synchronized void print(Object obj) {
        this.print(String.valueOf(obj));
    }

    public synchronized void println(char[] data) {
        this.print(data);
        this.printSeparator();
    }

    public synchronized void println(String s) {
        this.print(s);
        this.printSeparator();
    }

    public synchronized void println(Object obj) {
        this.print(obj);
        this.printSeparator();
    }

    public synchronized void println() {
        this.printSeparator();
    }

    private void printSeparator() {
        this.print(this.fLineSeparator);
    }

    private void growBuffer() {
        int newSize = this.fCharCount * 2;
        char[] newBuffer = new char[newSize];
        System.arraycopy(this.fChars, 0, newBuffer, 0, this.fCharCount);
        this.fCharCount = newSize;
        this.fChars = newBuffer;
    }

    public String getString() {
        return new String(this.fChars, 0, this.fCursor);
    }

    public void reset() {
        this.fCursor = 0;
    }

    public void flush() {
    }
}

