/*
 * Decompiled with CFR 0.152.
 */
package com.wily.introscope.agent.probe.lang;

import com.wily.introscope.agent.AgentNotAvailableException;
import com.wily.introscope.agent.AgentShim;
import com.wily.introscope.agent.IAgent;
import com.wily.introscope.agent.probe.lang.IManagedThread;
import com.wily.introscope.agent.probe.lang.ManagedThread;
import com.wily.introscope.agent.stat.DataAccumulatorFactory;
import com.wily.introscope.agent.stat.IIntegerAverageDataAccumulator;
import com.wily.util.WilyStringBuilder;
import com.wily.util.adt.WeakHashSet;
import com.wily.util.feedback.IModuleFeedbackChannel;
import com.wily.util.feedback.Module;
import com.wily.util.heartbeat.ITimestampedRunnable;
import com.wily.util.heartbeat.IntervalHeartbeat;
import com.wily.util.properties.hot.IntegerConfigurationProperty;
import com.wily.wilyassert.Assertion;
import java.util.HashMap;
import java.util.Iterator;
import java.util.Map;

public class ThreadMonitor {
    private final WeakHashSet fThreads = new WeakHashSet();
    private static boolean fAgentNotAvailable = false;
    private static IAgent fAgent = null;
    private static DataAccumulatorFactory sFactory = null;
    private static IModuleFeedbackChannel fFeedback;
    private static final Module sModule;
    private static int fMaxThreadsLimit;
    private static int fDefaultMaxThreadsLimit;
    private static String kMaxThreadMonitoringLimitProperty;
    private static int kThreadMonitoringStopWarnInterval;
    private long fLastWarningLogTime = 0L;
    private static ThreadGroup fRootThreadGroup;

    static {
        sModule = new Module("ThreadMonitor");
        fMaxThreadsLimit = 5000;
        fDefaultMaxThreadsLimit = 5000;
        kMaxThreadMonitoringLimitProperty = "com.wily.introscope.agent.threadMonitor.maxThreadsLimit";
        kThreadMonitoringStopWarnInterval = 300000;
        fRootThreadGroup = null;
        try {
            fAgent = AgentShim.getAgent();
            sFactory = fAgent.IAgent_getDataAccumulatorFactory();
            fFeedback = fAgent.IAgent_getModuleFeedback();
        }
        catch (AgentNotAvailableException agentNotAvailableException) {
            fAgentNotAvailable = true;
        }
    }

    public ThreadMonitor() {
        try {
            IntervalHeartbeat heartBeat = fAgent.IAgent_getThreadMonitorHeartbeat();
            if (heartBeat != null) {
                ThreadCountingBehavior heartbeatBehavior = new ThreadCountingBehavior();
                heartBeat.addBehavior((ITimestampedRunnable)heartbeatBehavior, "Introscope Thread Monitor", true, 7500L, false);
            }
        }
        catch (Exception e) {
            fFeedback.error("Cannot run Thread Monitor", e);
            return;
        }
        try {
            fAgent.IAgent_getConfigurationManager().add(new ThreadMonitorMaxThreadLimitProperty(fAgent));
            fMaxThreadsLimit = fAgent.IAgent_getIndexedProperties().getIntProperty(kMaxThreadMonitoringLimitProperty, fDefaultMaxThreadsLimit);
        }
        catch (Exception exception) {
            fMaxThreadsLimit = fDefaultMaxThreadsLimit;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void add(IManagedThread t) {
        if (!fAgentNotAvailable && this.fThreads != null) {
            Object object = this.getThreadMonitorLock();
            synchronized (object) {
                int size = this.fThreads.size();
                if (size <= fMaxThreadsLimit) {
                    this.fThreads.add(t);
                } else {
                    long currentTime = System.currentTimeMillis();
                    if (this.fLastWarningLogTime == 0L || currentTime - this.fLastWarningLogTime > (long)kThreadMonitoringStopWarnInterval) {
                        WilyStringBuilder msgBfr = new WilyStringBuilder(400);
                        msgBfr.append("Total number of threads (");
                        msgBfr.append(size);
                        msgBfr.append(") being monitored exceeded the threshold limit of ");
                        msgBfr.append(fMaxThreadsLimit);
                        msgBfr.append(" . This situation will lead to inaccurate thread count values. Set higher value for ");
                        msgBfr.append(kMaxThreadMonitoringLimitProperty);
                        msgBfr.append(" to monitor more number of threads and restart the application");
                        fFeedback.error(msgBfr.toString());
                        this.fLastWarningLogTime = currentTime;
                    }
                }
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void remove(IManagedThread t) {
        Object object = this.getThreadMonitorLock();
        synchronized (object) {
            boolean wasThere = this.fThreads.remove(t);
            Assertion.wilyAssert(wasThere);
        }
    }

    protected Object getThreadMonitorLock() {
        return this;
    }

    private static int getTotalThreadCount() {
        int totalThreadCount = 0;
        if (fRootThreadGroup == null) {
            ThreadGroup parentGroup;
            ThreadGroup rootGroup = Thread.currentThread().getThreadGroup();
            while ((parentGroup = rootGroup.getParent()) != null) {
                rootGroup = parentGroup;
            }
            fRootThreadGroup = rootGroup;
            if (fFeedback.isDebugEnabled()) {
                fFeedback.debug(sModule, "Root ThreadGroup is" + fRootThreadGroup.getName());
            }
        }
        totalThreadCount = fRootThreadGroup.activeCount();
        return totalThreadCount;
    }

    public class ThreadCountingBehavior
    implements ITimestampedRunnable {
        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public void ITimestampedRunnable_execute(long nowInMillis) {
            WeakHashSet listCopy;
            boolean isVerboseEnabled = fFeedback.isVerboseEnabled();
            Object object = ThreadMonitor.this.getThreadMonitorLock();
            synchronized (object) {
                listCopy = new WeakHashSet(ThreadMonitor.this.fThreads);
            }
            HashMap<String, Integer> threadCounts = new HashMap<String, Integer>(16);
            Iterator iter = listCopy.iterator();
            StringBuffer monitoredThreads = new StringBuffer();
            while (iter.hasNext()) {
                try {
                    ManagedThread t = (ManagedThread)iter.next();
                    if (t != null && t.isAlive()) {
                        Integer tCount = (Integer)threadCounts.get(t.getfThreadClassName());
                        if (tCount == null) {
                            threadCounts.put(t.getfThreadClassName(), new Integer(1));
                        } else {
                            threadCounts.put(t.getfThreadClassName(), new Integer(tCount + 1));
                        }
                        if (!isVerboseEnabled) continue;
                        monitoredThreads.append("[").append(t.getName()).append(", ").append(t.getfThreadClassName()).append("]");
                        continue;
                    }
                    ThreadMonitor.this.remove(t);
                }
                catch (Exception exception) {}
            }
            if (fFeedback.isVerboseEnabled()) {
                fFeedback.verbose(sModule, "Monitored Threads are :" + monitoredThreads.toString());
            }
            Iterator entries = threadCounts.entrySet().iterator();
            while (entries.hasNext()) {
                try {
                    Map.Entry entry = entries.next();
                    String className = (String)entry.getKey();
                    int tCount = (Integer)entry.getValue();
                    IIntegerAverageDataAccumulator accumulator = sFactory.safeGetIntegerAverageDataAccumulator("Threads|" + className + ":" + "Active Threads");
                    accumulator.IIntegerAggregatingDataAccumulator_recordDataPoint(tCount);
                }
                catch (Exception exception) {}
            }
            int totalThreadCount = 0;
            try {
                totalThreadCount = ThreadMonitor.getTotalThreadCount();
            }
            catch (Exception exception) {}
            if (totalThreadCount > 0) {
                IIntegerAverageDataAccumulator totalActiveThreadCounter = sFactory.safeGetIntegerAverageDataAccumulator("Threads:Active Threads");
                totalActiveThreadCounter.IIntegerAggregatingDataAccumulator_recordDataPoint(totalThreadCount);
            }
        }
    }

    static final class ThreadMonitorMaxThreadLimitProperty
    extends IntegerConfigurationProperty {
        public ThreadMonitorMaxThreadLimitProperty(IAgent agent) {
            super(kMaxThreadMonitoringLimitProperty, new Integer(fDefaultMaxThreadsLimit), fFeedback, sModule, fAgent.IAgent_getStringLocalizer());
        }

        public void set(Object newValue) {
            try {
                fMaxThreadsLimit = (Integer)newValue;
            }
            catch (Exception exception) {
                fFeedback.debug(sModule, "An exception occured in setting Max Thread Limit for thread montor");
            }
        }
    }
}

