/*
 * Decompiled with CFR 0.152.
 */
package com.wily.introscope.agent.probe.net;

import com.wily.introscope.agent.LazyMetricNameProvider;
import com.wily.introscope.agent.probe.net.SocketMonitor;
import com.wily.introscope.agent.stat.DataAccumulatorFactory;
import com.wily.introscope.agent.stat.ILongIntervalCounterDataAccumulator;
import com.wily.introscope.agent.trace.InvocationData;

public final class ServerSocketMonitor
extends SocketMonitor {
    private final ILongIntervalCounterDataAccumulator fAcceptsPerInterval;

    public ServerSocketMonitor(int port) {
        super(null, port);
        DataAccumulatorFactory factory = this.getDataAccumulatorFactory();
        this.fAcceptsPerInterval = this.createAcceptsPerIntervalAccumulator(factory);
    }

    protected String calculateResourceName(String host, int port) {
        return "Sockets|Server|Port " + port;
    }

    private final ILongIntervalCounterDataAccumulator createAcceptsPerIntervalAccumulator(DataAccumulatorFactory factory) {
        if (factory != null) {
            return factory.safeGetLongIntervalCounterDataAccumulator(String.valueOf(this.getResourceName()) + ":" + "Accepts Per Interval");
        }
        return null;
    }

    public void eventAccept() {
        if (this.shouldMeter(this.fAcceptsPerInterval)) {
            this.fAcceptsPerInterval.ILongIntervalCounterDataAccumulator_addSingleIncident();
        }
    }

    protected void delegateAnnotateBlameStack(Object key, LazyMetricNameProvider lazyMetricNameProvider, InvocationData data, boolean alsoDoAppMap) {
    }

    protected String getBackendResource() {
        return null;
    }

    protected boolean shouldAddToMap() {
        return false;
    }
}

