/*
 * Decompiled with CFR 0.152.
 */
package com.wily.introscope.agent.recording;

import com.wily.introscope.agent.recording.IRemoveMetricDataListener;
import com.wily.introscope.agent.recording.MetricExclusionFilter;
import com.wily.util.feedback.IModuleFeedbackChannel;
import com.wily.util.feedback.Module;
import com.wily.util.heartbeat.IRegisteredBehavior;
import com.wily.util.heartbeat.ITimestampedRunnable;
import com.wily.util.heartbeat.IntervalHeartbeat;
import com.wily.util.properties.hot.BooleanConfigurationProperty;
import com.wily.util.properties.hot.ConfigurationManager;
import com.wily.util.properties.hot.ConfigurationProperty;
import com.wily.util.properties.hot.IntegerConfigurationProperty;
import com.wily.util.properties.hot.PositiveIntegerConfigurationProperty;
import com.wily.util.text.IStringLocalizer;
import java.util.ArrayList;
import java.util.List;

public class RemoveMetricDataWatcher
implements ITimestampedRunnable {
    private final List listeners = new ArrayList(3);
    private final IntervalHeartbeat heartbeat;
    private volatile IRegisteredBehavior behavior;
    private volatile boolean removeMetricOn;
    private volatile int timeInterval;
    private volatile int dataChunk;
    private volatile MetricExclusionFilter fMetricExclusionFilter;
    private volatile int fMetricRemovalTimesliceIntervals;
    private boolean bAllowBelowDefaults;

    public RemoveMetricDataWatcher(IntervalHeartbeat heartbeat, ConfigurationManager configManager, Module module, IModuleFeedbackChannel feedback, IStringLocalizer localizer, boolean bAllowBelowDefaults) {
        this.heartbeat = heartbeat;
        this.bAllowBelowDefaults = bAllowBelowDefaults;
        this.defineConfigurationProperties(configManager, module, feedback, localizer);
    }

    private void defineConfigurationProperties(ConfigurationManager configManager, Module module, IModuleFeedbackChannel feedback, IStringLocalizer localizer) {
        configManager.add(new BooleanConfigurationProperty("introscope.agent.metricAging.turnOn", Boolean.FALSE, "Agent_Metric_Aging", feedback, module, localizer){

            public void set(Object value) {
                if (value != null) {
                    RemoveMetricDataWatcher.this.removeMetricOn = (Boolean)value;
                }
            }
        });
        configManager.add(new IntegerConfigurationProperty("introscope.agent.metricAging.heartbeatInterval", new Integer(86400), "Agent_Metric_Aging_Interval", "Hot_Property_Units_Seconds", false, false, feedback, module, localizer){

            public boolean validate(Object value) {
                if ((Integer)value < 86400 && !RemoveMetricDataWatcher.this.bAllowBelowDefaults) {
                    throw new IllegalArgumentException("Value cannot be below the default value");
                }
                if (RemoveMetricDataWatcher.this.heartbeat.getMinimumPeriodInMillis() != 86400L) {
                    this.getFeedback().warn("The aging heartbeat has been set to " + RemoveMetricDataWatcher.this.heartbeat.getMinimumPeriodInMillis() + " and validation of the proposed value " + value + " for the property " + "introscope.agent.metricAging.heartbeatInterval" + " is not possible. The property value will be accepted as is");
                    return true;
                }
                return value == null || (Integer)value >= 120;
            }

            public void set(Object value) {
                RemoveMetricDataWatcher.this.timeInterval = (Integer)value;
            }
        });
        configManager.add(new PositiveIntegerConfigurationProperty("introscope.agent.metricAging.dataChunk", new Integer(500), "Agent_Metric_Aging_DataChunk", null, true, false, feedback, module, localizer){

            public void set(Object value) {
                RemoveMetricDataWatcher.this.dataChunk = (Integer)value;
            }
        });
        configManager.add(new ConfigurationProperty("introscope.agent.metricAging.metricExclude.ignore", new ArrayList(), "Agent_Metric_Aging_Exclusion_List", null, true, false, true, feedback, module, localizer){

            public Object convert(String s) {
                return s.trim();
            }

            public void set(Object value) {
                RemoveMetricDataWatcher.this.fMetricExclusionFilter = new MetricExclusionFilter(((List)value).toArray(new String[0]));
            }
        });
        configManager.add(new PositiveIntegerConfigurationProperty("introscope.agent.metricAging.numberTimeslices", new Integer(180000), "Agent_Metric_Aging_Timeslice_Intervals", null, true, false, feedback, module, localizer){

            public boolean validate(Object value) {
                if ((Integer)value < 180000 && !RemoveMetricDataWatcher.this.bAllowBelowDefaults) {
                    throw new IllegalArgumentException("Value cannot be below the default value");
                }
                return true;
            }

            public void set(Object value) {
                RemoveMetricDataWatcher.this.fMetricRemovalTimesliceIntervals = (Integer)value * 2;
            }
        });
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void ITimestampedRunnable_execute(long nowInMillis) {
        if (!this.removeMetricOn) {
            return;
        }
        ArrayList iterateOn = null;
        List list = this.listeners;
        synchronized (list) {
            if (this.listeners.size() > 0) {
                iterateOn = new ArrayList(this.listeners);
            }
        }
        if (iterateOn != null) {
            for (IRemoveMetricDataListener listener : iterateOn) {
                listener.setUpdateTimestamp(System.currentTimeMillis());
                listener.removeMetricData(this.dataChunk, this.fMetricExclusionFilter, this.fMetricRemovalTimesliceIntervals);
                listener.setUpdateTimestamp(System.currentTimeMillis());
            }
        }
    }

    public void shutdown() {
        if (this.behavior != null) {
            this.behavior.close();
        }
    }

    public void startBehavior() {
        this.behavior = this.heartbeat.addBehavior((ITimestampedRunnable)this, "Remove Metric Data", true, (long)(this.timeInterval * 1000), false);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void addListener(IRemoveMetricDataListener listener) {
        boolean shouldStartBehavior = false;
        RemoveMetricDataWatcher removeMetricDataWatcher = this;
        synchronized (removeMetricDataWatcher) {
            if (this.listeners.size() == 0) {
                shouldStartBehavior = true;
            }
            this.listeners.add(listener);
        }
        if (shouldStartBehavior) {
            this.startBehavior();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean removeListener(IRemoveMetricDataListener listener) {
        boolean result = false;
        boolean stopBehavior = false;
        RemoveMetricDataWatcher removeMetricDataWatcher = this;
        synchronized (removeMetricDataWatcher) {
            if (this.listeners.size() > 0) {
                result = this.listeners.remove(listener);
                if (this.listeners.size() == 0) {
                    stopBehavior = true;
                }
            }
        }
        if (stopBehavior) {
            this.shutdown();
        }
        return result;
    }

    protected int getTimeInterval() {
        return this.timeInterval;
    }
}

