/*
 * Decompiled with CFR 0.152.
 */
package com.wily.introscope.agent.service;

import com.wily.introscope.agent.IAgent;
import com.wily.introscope.agent.service.ASimpleService;
import java.util.Map;

public abstract class AReflectionDelegatingService
extends ASimpleService {
    private final String fDelegateServiceName;
    private final String fDelegateClassName;
    private final ClassLoader fDelegateClassLoader;

    protected AReflectionDelegatingService(String delegateName, String delegateClassName, ClassLoader delegateClassLoader) {
        super(String.valueOf(delegateName) + " Delegator");
        this.fDelegateServiceName = delegateName;
        this.fDelegateClassName = delegateClassName;
        this.fDelegateClassLoader = delegateClassLoader;
    }

    private final String getDelegateServiceName() {
        return this.fDelegateServiceName;
    }

    private final String getDelegateServiceClassName() {
        return this.fDelegateClassName;
    }

    private final ClassLoader getDelegateServiceClassLoader() {
        return this.fDelegateClassLoader;
    }

    protected final void doStartService(IAgent agent, Map parameters) {
        if (this.environmentProbeAllowsDelegateLoad(agent)) {
            try {
                agent.IAgent_getServiceAdministrator().registerServiceSync(agent, this.getDelegateServiceName(), this.getDelegateServiceClassName(), this.getDelegateServiceClassLoader(), parameters);
            }
            catch (Throwable t) {
                this.handleInvocationException(agent, t);
            }
        }
    }

    private final boolean environmentProbeAllowsDelegateLoad(IAgent agent) {
        return this.doShouldAttemptDelegateLoad(agent);
    }

    private final void handleInvocationException(IAgent agent, Throwable t) {
        this.doHandleDelegateLoadException(agent, t);
    }

    protected abstract boolean doShouldAttemptDelegateLoad(IAgent var1);

    protected abstract void doHandleDelegateLoadException(IAgent var1, Throwable var2);
}

