/*
 * Decompiled with CFR 0.152.
 */
package com.wily.introscope.agent.trace;

import com.wily.introscope.agent.AgentNotAvailableException;
import com.wily.introscope.agent.AgentShim;
import com.wily.introscope.agent.IAgent;
import com.wily.introscope.spec.metric.BadlyFormedNameException;
import com.wily.introscope.spec.metric.MetricNotFoundException;
import com.wily.util.IConfigurationListener;
import com.wily.util.extension.IPlugin;
import com.wily.util.feedback.Module;
import com.wily.util.properties.IndexedProperties;
import com.wily.util.properties.hot.BooleanConfigurationProperty;
import com.wily.util.properties.hot.ConfigurationProperty;
import com.wily.util.properties.hot.PositiveIntegerConfigurationProperty;
import com.wily.util.properties.hot.PositiveLongConfigurationProperty;
import java.io.BufferedReader;
import java.io.File;
import java.io.FileNotFoundException;
import java.io.FileReader;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Formatter;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.regex.Pattern;
import java.util.regex.PatternSyntaxException;

public final class BTThreadLocalAdministrator {
    private static IAgent fAgent;
    private static final Module kModule;
    public static final String kSustainabilityBaseMetricName = "Agent Stats|Sustainability|Browser Agent Business Transaction";
    public static final char kBrowserAgentCommaChar = ',';
    private static String jarLocation;
    private static final String SNIPPET_FILE_EXT_NAME = "basnippet";
    private static final String APP_ID_KEY_PATTERN = "[a-zA-Z0-9]+";
    private static volatile boolean autoInjectionEnabled;
    private static boolean sustainabilityMetricsOn;
    private static int throttleResponseLimit;
    private static volatile boolean headFilterPresenceCheckEnabled;
    private static volatile boolean tailFilterPresenceCheckEnabled;
    private static long snippetMaxSearchingLength;
    private static volatile int maxSearchCounter;
    private static volatile HashSet maxSearchReachedUrls;
    private static int searchingMethodHierarchyMaxDepth;
    private static boolean encodingEnabled;
    private static int autoskipInstrumentClassDepth;
    private static boolean responseDecorationEnabled;
    private static int responseCookieExpirationTime;
    private static String responseDecorationIncludeURLsRegex;
    private static Pattern responseDecorationIncludeURLsRegexPattern;
    private static boolean apmDataResponseDecorationEnabled;
    private static String dxcServerHost;
    private static int dxcServerPort;
    private static boolean dxcServerSSLEnabled;
    private static final String PROPERTYNAME_CORGUIDENABLED = "introscope.agent.browseragent.corguid.enabled";
    private static boolean corguidEnabled;
    private static final String dxcServerHostReplacementPattern = "{host}";
    private static final String dxcServerPortReplacementPattern = "{port}";
    private static final String dxcServerSSLEnabledPattern = "{protocol}";
    private static final String extensionJarTracerName = "BRTM Tracer";
    private static final String appGroupPrefix = "introscope.agent.browseragent.autoInjection";
    private static volatile String appGroupKeys;
    private static final String snippetLocationSuffix = "snippetLocation";
    private static final String includeURLsRegexSuffix = "includeURLsRegex";
    private static final String propSeparator = ".";
    private static List snippetLocationList;
    private static List snippetCodeList;
    private static List includeURLsRegexList;
    private static List compiledPatternList;
    private static List snippetCodeWithCorrelationList;
    private static IConfigurationListener configListener;
    private static String excludeResponseContentPatterns;
    private static String[] excludeResponseContentPatternsList;
    public static boolean reInitialize;
    private static List browserSupportList;
    private static String BROWSER_LIST_PROPERTY;
    private static final String SCRIPT_TAG_START = "<script";
    private static final String SNIPPET_CORRELATION_STRING = " x-apm-ba-response-bt=\"<correlation>\" ";
    private static String COOKIE_CONTENTTYPE_PROPERTY;
    private static volatile String cookieContentType;
    private static volatile String[] cookieContentTypeArray;
    private static final String oldResponseCookieEnabled = "introscope.agent.browseragent.responseCookieEnabled";
    private static final String oldResponseCookieExpirationTime = "introscope.agent.browseragent.responseCookie.expirationTime";
    private static final String oldResponseCookieIncludeURLsRegex = "introscope.agent.browseragent.responseCookie.includeURLsRegex";
    private static final String oldCookieAPMDataEnabledName = "introscope.agent.browseragent.responseCookie.apmData.enabled";
    private ThreadLocal stackData = new ThreadLocal(){

        public Object initialValue() {
            return new HashMap();
        }
    };

    static {
        kModule = new Module("BrowserAgent");
        jarLocation = null;
        autoInjectionEnabled = false;
        sustainabilityMetricsOn = true;
        throttleResponseLimit = 1000;
        headFilterPresenceCheckEnabled = true;
        tailFilterPresenceCheckEnabled = true;
        snippetMaxSearchingLength = 32768L;
        maxSearchCounter = 0;
        maxSearchReachedUrls = new HashSet();
        searchingMethodHierarchyMaxDepth = 3;
        encodingEnabled = false;
        autoskipInstrumentClassDepth = 1;
        responseDecorationEnabled = false;
        responseCookieExpirationTime = 3;
        responseDecorationIncludeURLsRegex = null;
        responseDecorationIncludeURLsRegexPattern = null;
        apmDataResponseDecorationEnabled = true;
        dxcServerHost = "localhost";
        dxcServerPort = 80;
        dxcServerSSLEnabled = false;
        corguidEnabled = false;
        appGroupKeys = null;
        snippetLocationList = new ArrayList();
        snippetCodeList = new ArrayList();
        includeURLsRegexList = new ArrayList();
        compiledPatternList = new ArrayList();
        snippetCodeWithCorrelationList = new ArrayList();
        excludeResponseContentPatterns = null;
        excludeResponseContentPatternsList = null;
        reInitialize = true;
        browserSupportList = new ArrayList();
        BROWSER_LIST_PROPERTY = "introscope.agent.browseragent.browserlist";
        COOKIE_CONTENTTYPE_PROPERTY = "introscope.agent.browseragent.response.decoration.cookie.contenttype";
        cookieContentType = "text/html";
        cookieContentTypeArray = null;
    }

    public static boolean isReInitialize() {
        return reInitialize;
    }

    public static void setReInitialize(boolean value) {
        reInitialize = value;
    }

    private BTThreadLocalAdministrator() {
        try {
            fAgent = AgentShim.getAgent();
        }
        catch (AgentNotAvailableException agentNotAvailableException) {
            return;
        }
        boolean isUsingOldConfig = fAgent.IAgent_getComponentTracer().isAgentOldMode();
        if (!isUsingOldConfig) {
            this.initializeBAProperties();
        }
    }

    public static BTThreadLocalAdministrator getInstance() {
        return BTThreadLocalAdministratorInstance.kInstance;
    }

    public Object get(String key) {
        HashMap dataInstance = (HashMap)this.stackData.get();
        return dataInstance.get(key);
    }

    public String getString(String key) {
        Object value = this.get(key);
        return value instanceof String ? (String)value : null;
    }

    public void insert(String key, Object value) {
        if (key != null && value != null) {
            HashMap dataInstance = (HashMap)this.stackData.get();
            dataInstance.put(key, value);
        }
    }

    public void remove(String key) {
        if (key != null) {
            HashMap dataInstance = (HashMap)this.stackData.get();
            dataInstance.remove(key);
        }
    }

    public void flush() {
        HashMap dataInstance = (HashMap)this.stackData.get();
        dataInstance.clear();
    }

    public boolean isSustainabilityMetricEnabled() {
        return sustainabilityMetricsOn;
    }

    public String[] getExcludeResponseContentPatterns() {
        if (excludeResponseContentPatternsList != null && excludeResponseContentPatternsList.length > 0) {
            return excludeResponseContentPatternsList;
        }
        if (excludeResponseContentPatterns == null) {
            return null;
        }
        excludeResponseContentPatternsList = excludeResponseContentPatterns.split(String.valueOf(','));
        return excludeResponseContentPatternsList;
    }

    public int getThrottleLimit() {
        return throttleResponseLimit;
    }

    public int getSearchingMethodHierarchyMaxDepth() {
        return searchingMethodHierarchyMaxDepth;
    }

    public long getMaxResponseContentLengthForSearching() {
        return snippetMaxSearchingLength;
    }

    public boolean shouldCheckForHeadFilterPresence() {
        return headFilterPresenceCheckEnabled;
    }

    public void setHeadFilterPresenceCheckEnabled(boolean status) {
        headFilterPresenceCheckEnabled = status;
    }

    public boolean shouldCheckForTailFilterPresence() {
        return tailFilterPresenceCheckEnabled;
    }

    public void setTailFilterPresenceCheckEnabled(boolean status) {
        tailFilterPresenceCheckEnabled = status;
    }

    public void increaseMaxSearchCountAndRecordUrl(String url) {
        ++maxSearchCounter;
        maxSearchReachedUrls.add(url);
    }

    public void resetMaxSearchCountAndUrl() {
        maxSearchCounter = 0;
        maxSearchReachedUrls.clear();
    }

    public int getMaxSearchCount() {
        return maxSearchCounter;
    }

    public String getMaxSearchUrls() {
        return maxSearchReachedUrls.toString();
    }

    public boolean isEncodingSupport() {
        return encodingEnabled;
    }

    public int getAutoskipInstrumentClassDepth() {
        return autoskipInstrumentClassDepth;
    }

    private static void logErrorMessages(String message) {
        fAgent.IAgent_getModuleFeedback().error(kModule, message);
    }

    private static void logInfoMessages(String message) {
        if (fAgent.IAgent_getModuleFeedback().isInfoEnabled(kModule)) {
            fAgent.IAgent_getModuleFeedback().info(kModule, message);
        }
    }

    private static void logWarnMessages(String message) {
        if (fAgent.IAgent_getModuleFeedback().isWarningEnabled(kModule)) {
            fAgent.IAgent_getModuleFeedback().warn(kModule, message);
        }
    }

    private static void logDebugMessages(String message) {
        if (fAgent.IAgent_getModuleFeedback().isDebugEnabled(kModule)) {
            fAgent.IAgent_getModuleFeedback().debug(kModule, message);
        }
    }

    private static void logTraceMessages(String message) {
        if (fAgent.IAgent_getModuleFeedback().isTraceEnabled(kModule)) {
            fAgent.IAgent_getModuleFeedback().trace(kModule, message);
        }
    }

    private void initializeBAProperties() {
        excludeResponseContentPatterns = fAgent.IAgent_getIndexedProperties().getProperty("introscope.agent.browseragent.autoInjection.excludeResponseContentPatterns", null);
        this.setBrowserSupportList();
        this.setBAExtJarLocation();
        fAgent.IAgent_getConfigurationManager().add(new AuotInjectionEnabledProperty(fAgent), true);
        fAgent.IAgent_getConfigurationManager().add(new AutoInjectionSnippetThrottleResponseLimitProperty(fAgent), true);
        fAgent.IAgent_getConfigurationManager().add(new HeadFilterPresenceCheckProperty(fAgent), true);
        fAgent.IAgent_getConfigurationManager().add(new TailFilterPresenceCheckProperty(fAgent), true);
        fAgent.IAgent_getConfigurationManager().add(new MaxResponseContentLengthForSearchingProperty(fAgent), true);
        fAgent.IAgent_getConfigurationManager().add(new SearchingMethodHierarchyMaxDepthProperty(fAgent), true);
        fAgent.IAgent_getConfigurationManager().add(new EncodingSupportEnabledProperty(fAgent), true);
        fAgent.IAgent_getConfigurationManager().add(new AutoskipInstrumentclassDepthProperty(fAgent), true);
        fAgent.IAgent_getConfigurationManager().add(new SustainabilityMetricsProperty(fAgent), true);
        fAgent.IAgent_getConfigurationManager().add(new CorguidEnabledProperty(fAgent), true);
        fAgent.IAgent_getConfigurationManager().add(new CookieContentTypeProperty(fAgent), true);
        this.setResponseDecorationProperties();
    }

    private void setResponseDecorationProperties() {
        IConfigurationListener responseDecorationConfigListener = new IConfigurationListener(){

            public void onChange(IndexedProperties props) {
                this.checkResponseDecorationEnabled(props);
                this.checkAPMDataResponseDecorationEnabled(props);
                this.checkResponseDecorationCookieExpireTime(props);
                this.checkResponseDecorationIncludeURLRegex(props);
            }

            private void checkResponseDecorationIncludeURLRegex(IndexedProperties props) {
                boolean changedFromOldProperty = false;
                String newValue = null;
                if (props.containsKey("introscope.agent.browseragent.response.decoration.includeURLsRegex")) {
                    newValue = props.getTrimmedProperty("introscope.agent.browseragent.response.decoration.includeURLsRegex");
                } else if (props.containsKey(BTThreadLocalAdministrator.oldResponseCookieIncludeURLsRegex)) {
                    newValue = props.getTrimmedProperty(BTThreadLocalAdministrator.oldResponseCookieIncludeURLsRegex);
                    changedFromOldProperty = true;
                }
                if (newValue != null && !newValue.equals(responseDecorationIncludeURLsRegex)) {
                    responseDecorationIncludeURLsRegex = newValue;
                    StringBuilder sbuf = new StringBuilder();
                    Formatter fmt = new Formatter(sbuf);
                    String propertyLogFormat = "The %3$s property is set to %2$s.";
                    if (responseDecorationIncludeURLsRegex.trim().length() > 0) {
                        responseDecorationIncludeURLsRegexPattern = BTThreadLocalAdministrator.this.getRegexPattern(responseDecorationIncludeURLsRegex);
                        if (changedFromOldProperty) {
                            propertyLogFormat = "The deprecated %1$s property is set to %2$s and is being processed as %3$s = %2$s.";
                        }
                        if (responseDecorationIncludeURLsRegexPattern == null) {
                            responseDecorationIncludeURLsRegexPattern = null;
                            propertyLogFormat = changedFromOldProperty ? "The deprecated %1$s property is not in the correct format. Please follow the user documentation and use %3$s property." : "The %3$s property is not in the correct format. Please follow the user documentation.";
                        }
                    } else {
                        responseDecorationIncludeURLsRegex = null;
                        responseDecorationIncludeURLsRegexPattern = null;
                        propertyLogFormat = changedFromOldProperty ? "The deprecated %1$s property is set to empty and is being processed as %3$s" : "The %3$s property is set to empty.";
                    }
                    fmt.format(propertyLogFormat, BTThreadLocalAdministrator.oldResponseCookieIncludeURLsRegex, responseDecorationIncludeURLsRegex, "introscope.agent.browseragent.response.decoration.includeURLsRegex");
                    BTThreadLocalAdministrator.logInfoMessages(sbuf.toString());
                    if (sustainabilityMetricsOn) {
                        fAgent.IAgent_getDataAccumulatorFactory().safeGetStringEveryEventDataAccumulator("Agent Stats|Sustainability|Browser Agent Business Transaction:introscope.agent.browseragent.response.decoration.includeURLsRegex").IStringEveryEventDataAccumulator_addString(responseDecorationIncludeURLsRegex == null ? "" : responseDecorationIncludeURLsRegex);
                    }
                }
            }

            private void checkResponseDecorationCookieExpireTime(IndexedProperties props) {
                boolean changedFromOldProperty = false;
                boolean contained = false;
                int newExpireTime = -1;
                if (props.containsKey("introscope.agent.browseragent.response.decoration.cookie.expirationTime")) {
                    newExpireTime = props.getIntProperty("introscope.agent.browseragent.response.decoration.cookie.expirationTime");
                    contained = true;
                } else if (props.containsKey(BTThreadLocalAdministrator.oldResponseCookieExpirationTime)) {
                    newExpireTime = props.getIntProperty(BTThreadLocalAdministrator.oldResponseCookieExpirationTime);
                    changedFromOldProperty = true;
                    contained = true;
                }
                if (contained && newExpireTime != responseCookieExpirationTime) {
                    StringBuffer sbuf = new StringBuffer();
                    Formatter fmt = new Formatter(sbuf);
                    String propertyLogFormat = "The %3$s property is set to %2$d.";
                    if (newExpireTime > 0) {
                        responseCookieExpirationTime = newExpireTime;
                        if (changedFromOldProperty) {
                            propertyLogFormat = "The deprecated %1$s property is set to %2$d and is being processed as %3$s = %2$d.";
                        }
                    } else {
                        responseCookieExpirationTime = 3;
                        propertyLogFormat = changedFromOldProperty ? "The deprecated %1$s property cannot be set to a negative value, this property will be set to the default value. Please follow the user documentation and use %3$s property." : "The %3$s property cannot be set to a negative value, this property will be set to the default value. Please follow the user documentation.";
                    }
                    fmt.format(propertyLogFormat, BTThreadLocalAdministrator.oldResponseCookieExpirationTime, responseCookieExpirationTime, "introscope.agent.browseragent.response.decoration.cookie.expirationTime");
                    BTThreadLocalAdministrator.logInfoMessages(sbuf.toString());
                    if (sustainabilityMetricsOn) {
                        fAgent.IAgent_getDataAccumulatorFactory().safeGetIntegerFluctuatingCounterDataAccumulator("Agent Stats|Sustainability|Browser Agent Business Transaction:introscope.agent.browseragent.response.decoration.cookie.expirationTime").IIntegerCounterDataAccumulator_setValue(responseCookieExpirationTime);
                    }
                }
            }

            private void checkAPMDataResponseDecorationEnabled(IndexedProperties props) {
                boolean changedFromOldProperty = false;
                String newAPMDataResponseDecorationEnabled = null;
                if (props.containsKey("introscope.agent.browseragent.response.decoration.apmData.enabled")) {
                    newAPMDataResponseDecorationEnabled = props.getTrimmedProperty("introscope.agent.browseragent.response.decoration.apmData.enabled");
                } else if (props.containsKey(BTThreadLocalAdministrator.oldCookieAPMDataEnabledName)) {
                    newAPMDataResponseDecorationEnabled = props.getTrimmedProperty(BTThreadLocalAdministrator.oldCookieAPMDataEnabledName);
                    changedFromOldProperty = true;
                }
                if (newAPMDataResponseDecorationEnabled != null && !newAPMDataResponseDecorationEnabled.equalsIgnoreCase(String.valueOf(apmDataResponseDecorationEnabled)) && (newAPMDataResponseDecorationEnabled.equalsIgnoreCase("true") || newAPMDataResponseDecorationEnabled.equalsIgnoreCase("false"))) {
                    apmDataResponseDecorationEnabled = Boolean.valueOf(newAPMDataResponseDecorationEnabled);
                    if (apmDataResponseDecorationEnabled) {
                        if (sustainabilityMetricsOn) {
                            fAgent.IAgent_getDataAccumulatorFactory().safeGetIntegerFluctuatingCounterDataAccumulator("Agent Stats|Sustainability|Browser Agent Business Transaction:introscope.agent.browseragent.response.decoration.apmData.enabled").IIntegerCounterDataAccumulator_setValue(1);
                        }
                        BTThreadLocalAdministrator.logInfoMessages("APM Data Response Decoration is enabled");
                    } else {
                        if (sustainabilityMetricsOn) {
                            fAgent.IAgent_getDataAccumulatorFactory().safeGetIntegerFluctuatingCounterDataAccumulator("Agent Stats|Sustainability|Browser Agent Business Transaction:introscope.agent.browseragent.response.decoration.apmData.enabled").IIntegerCounterDataAccumulator_setValue(0);
                        }
                        BTThreadLocalAdministrator.logInfoMessages("APM Data Response Decoration is disabled");
                    }
                    if (changedFromOldProperty) {
                        StringBuffer sbuf = new StringBuffer();
                        Formatter fmt = new Formatter(sbuf);
                        String propertyLogFormat = "The deprecated %1$s property is set to %2$b and is being processed as %3$s = %2$b.";
                        fmt.format(propertyLogFormat, BTThreadLocalAdministrator.oldCookieAPMDataEnabledName, apmDataResponseDecorationEnabled, "introscope.agent.browseragent.response.decoration.apmData.enabled");
                        BTThreadLocalAdministrator.logInfoMessages(sbuf.toString());
                    }
                }
            }

            private void checkResponseDecorationEnabled(IndexedProperties props) {
                boolean changedFromOldProperty = false;
                String newResponseDecorationEnabled = null;
                if (props.containsKey("introscope.agent.browseragent.response.decoration.enabled")) {
                    newResponseDecorationEnabled = props.getTrimmedProperty("introscope.agent.browseragent.response.decoration.enabled");
                } else if (props.containsKey(BTThreadLocalAdministrator.oldResponseCookieEnabled)) {
                    newResponseDecorationEnabled = props.getTrimmedProperty(BTThreadLocalAdministrator.oldResponseCookieEnabled);
                    changedFromOldProperty = true;
                }
                if (newResponseDecorationEnabled != null && !newResponseDecorationEnabled.equalsIgnoreCase(String.valueOf(responseDecorationEnabled)) && (newResponseDecorationEnabled.equalsIgnoreCase("true") || newResponseDecorationEnabled.equalsIgnoreCase("false"))) {
                    reInitialize = true;
                    responseDecorationEnabled = Boolean.valueOf(newResponseDecorationEnabled);
                    if (responseDecorationEnabled) {
                        if (sustainabilityMetricsOn) {
                            fAgent.IAgent_getDataAccumulatorFactory().safeGetIntegerFluctuatingCounterDataAccumulator("Agent Stats|Sustainability|Browser Agent Business Transaction:introscope.agent.browseragent.response.decoration.enabled").IIntegerCounterDataAccumulator_setValue(1);
                        }
                        BTThreadLocalAdministrator.logInfoMessages("Response Decoration is enabled");
                    } else {
                        if (sustainabilityMetricsOn) {
                            fAgent.IAgent_getDataAccumulatorFactory().safeGetIntegerFluctuatingCounterDataAccumulator("Agent Stats|Sustainability|Browser Agent Business Transaction:introscope.agent.browseragent.response.decoration.enabled").IIntegerCounterDataAccumulator_setValue(0);
                        }
                        BTThreadLocalAdministrator.logInfoMessages("Response Decoration is disabled");
                    }
                    if (changedFromOldProperty) {
                        StringBuffer sbuf = new StringBuffer();
                        Formatter fmt = new Formatter(sbuf);
                        String propertyLogFormat = "The deprecated %1$s property is set to %2$b and is being processed as %3$s = %2$b.";
                        fmt.format(propertyLogFormat, BTThreadLocalAdministrator.oldResponseCookieEnabled, responseDecorationEnabled, "introscope.agent.browseragent.response.decoration.enabled");
                        BTThreadLocalAdministrator.logInfoMessages(sbuf.toString());
                    }
                }
            }
        };
        fAgent.addConfigurationListener(responseDecorationConfigListener);
    }

    private void setBrowserSupportList() {
        String browsers = fAgent.IAgent_getConfigurationManager().getProperty(BROWSER_LIST_PROPERTY);
        if (browsers == null) {
            browserSupportList.add("Unsupported|opera");
            browserSupportList.add("Unsupported|opr");
            browserSupportList.add("Edge|edge|edge/|12");
            browserSupportList.add("IE|msie|msie |9");
            browserSupportList.add("IE|trident|rv:|9");
            browserSupportList.add("Chrome|chrome|chrome/|30");
            browserSupportList.add("Chrome|crios|crios/|30");
            browserSupportList.add("Chrome|crmo|crmo/|30");
            browserSupportList.add("Firefox|firefox|firefox/|30");
            browserSupportList.add("Firefox|iceweasel|iceweasel/|30");
            browserSupportList.add("Safari|safari|version/|9");
        } else {
            String[] items;
            String[] stringArray = items = browsers.split(",");
            int n = items.length;
            int n2 = 0;
            while (n2 < n) {
                String item = stringArray[n2];
                browserSupportList.add(item.trim());
                ++n2;
            }
        }
    }

    public List getBrowserSupportList() {
        return browserSupportList;
    }

    public void stopReportSustainabilityMetrics() {
        try {
            fAgent.IAgent_getDataAccumulatorFactory().removeMetric("Agent Stats|Sustainability|Browser Agent Business Transaction:introscope.agent.browseragent.autoInjectionEnabled");
            fAgent.IAgent_getDataAccumulatorFactory().removeMetric("Agent Stats|Sustainability|Browser Agent Business Transaction:introscope.agent.browseragent.response.decoration.enabled");
            fAgent.IAgent_getDataAccumulatorFactory().removeMetric("Agent Stats|Sustainability|Browser Agent Business Transaction:introscope.agent.browseragent.response.decoration.includeURLsRegex");
            fAgent.IAgent_getDataAccumulatorFactory().removeMetric("Agent Stats|Sustainability|Browser Agent Business Transaction:introscope.agent.browseragent.autoInjection.snippet.maxSearchingLength");
            fAgent.IAgent_getDataAccumulatorFactory().removeMetric("Agent Stats|Sustainability|Browser Agent Business Transaction:introscope.agent.browseragent.autoInjection.appID");
            fAgent.IAgent_getDataAccumulatorFactory().removeMetric("Agent Stats|Sustainability|Browser Agent Business Transaction:introscope.agent.browseragent.autoInjection.throttleResponseLimit");
            fAgent.IAgent_getDataAccumulatorFactory().removeMetric("Agent Stats|Sustainability|Browser Agent Business Transaction:introscope.agent.browseragent.response.decoration.cookie.expirationTime");
            fAgent.IAgent_getDataAccumulatorFactory().removeMetric("Agent Stats|Sustainability|Browser Agent Business Transaction:introscope.agent.browseragent.contentencoding.enabled");
            fAgent.IAgent_getDataAccumulatorFactory().removeMetric("Agent Stats|Sustainability|Browser Agent Business Transaction:introscope.agent.browseragent.autoInjection.responseCount");
            fAgent.IAgent_getDataAccumulatorFactory().removeMetric("Agent Stats|Sustainability|Browser Agent Business Transaction:introscope.agent.browseragent.autoInjection.snippet.maxSearchingReached.count");
            fAgent.IAgent_getDataAccumulatorFactory().removeMetric("Agent Stats|Sustainability|Browser Agent Business Transaction:introscope.agent.browseragent.unsupportedBrowsers.count");
            fAgent.IAgent_getDataAccumulatorFactory().removeMetric("Agent Stats|Sustainability|Browser Agent Business Transaction:" + COOKIE_CONTENTTYPE_PROPERTY);
        }
        catch (BadlyFormedNameException e) {
            BTThreadLocalAdministrator.logTraceMessages("BadlyFormedNameException:" + e.getMessage());
        }
        catch (MetricNotFoundException e) {
            BTThreadLocalAdministrator.logTraceMessages("MetricNotFoundException:" + e.getMessage());
        }
    }

    public void startReportingSustainabilityMetrics() {
        if (autoInjectionEnabled) {
            fAgent.IAgent_getDataAccumulatorFactory().safeGetIntegerFluctuatingCounterDataAccumulator("Agent Stats|Sustainability|Browser Agent Business Transaction:introscope.agent.browseragent.autoInjectionEnabled").IIntegerCounterDataAccumulator_setValue(1);
        } else {
            fAgent.IAgent_getDataAccumulatorFactory().safeGetIntegerFluctuatingCounterDataAccumulator("Agent Stats|Sustainability|Browser Agent Business Transaction:introscope.agent.browseragent.autoInjectionEnabled").IIntegerCounterDataAccumulator_setValue(0);
        }
        if (responseDecorationEnabled) {
            fAgent.IAgent_getDataAccumulatorFactory().safeGetIntegerFluctuatingCounterDataAccumulator("Agent Stats|Sustainability|Browser Agent Business Transaction:introscope.agent.browseragent.response.decoration.enabled").IIntegerCounterDataAccumulator_setValue(1);
        } else {
            fAgent.IAgent_getDataAccumulatorFactory().safeGetIntegerFluctuatingCounterDataAccumulator("Agent Stats|Sustainability|Browser Agent Business Transaction:introscope.agent.browseragent.response.decoration.enabled").IIntegerCounterDataAccumulator_setValue(0);
        }
        fAgent.IAgent_getDataAccumulatorFactory().safeGetStringEveryEventDataAccumulator("Agent Stats|Sustainability|Browser Agent Business Transaction:introscope.agent.browseragent.response.decoration.includeURLsRegex").IStringEveryEventDataAccumulator_addString(responseDecorationIncludeURLsRegex == null ? "" : responseDecorationIncludeURLsRegex);
        fAgent.IAgent_getDataAccumulatorFactory().safeGetStringEveryEventDataAccumulator("Agent Stats|Sustainability|Browser Agent Business Transaction:introscope.agent.browseragent.autoInjection.appID").IStringEveryEventDataAccumulator_addString(appGroupKeys == null ? "" : appGroupKeys);
        fAgent.IAgent_getDataAccumulatorFactory().safeGetLongFluctuatingCounterDataAccumulator("Agent Stats|Sustainability|Browser Agent Business Transaction:introscope.agent.browseragent.autoInjection.snippet.maxSearchingLength").ILongCounterDataAccumulator_setValue(snippetMaxSearchingLength);
        fAgent.IAgent_getDataAccumulatorFactory().safeGetIntegerFluctuatingCounterDataAccumulator("Agent Stats|Sustainability|Browser Agent Business Transaction:introscope.agent.browseragent.autoInjection.throttleResponseLimit").IIntegerCounterDataAccumulator_setValue(throttleResponseLimit);
        fAgent.IAgent_getDataAccumulatorFactory().safeGetIntegerFluctuatingCounterDataAccumulator("Agent Stats|Sustainability|Browser Agent Business Transaction:introscope.agent.browseragent.response.decoration.cookie.expirationTime").IIntegerCounterDataAccumulator_setValue(responseCookieExpirationTime);
        if (encodingEnabled) {
            fAgent.IAgent_getDataAccumulatorFactory().safeGetIntegerFluctuatingCounterDataAccumulator("Agent Stats|Sustainability|Browser Agent Business Transaction:introscope.agent.browseragent.contentencoding.enabled").IIntegerCounterDataAccumulator_setValue(1);
        } else {
            fAgent.IAgent_getDataAccumulatorFactory().safeGetIntegerFluctuatingCounterDataAccumulator("Agent Stats|Sustainability|Browser Agent Business Transaction:introscope.agent.browseragent.contentencoding.enabled").IIntegerCounterDataAccumulator_setValue(0);
        }
        fAgent.IAgent_getDataAccumulatorFactory().safeGetStringEveryEventDataAccumulator("Agent Stats|Sustainability|Browser Agent Business Transaction:" + COOKIE_CONTENTTYPE_PROPERTY).IStringEveryEventDataAccumulator_addString(cookieContentType == null ? "" : cookieContentType);
    }

    private Pattern getRegexPattern(String regex) {
        Pattern pattern = null;
        if (regex != null) {
            try {
                pattern = Pattern.compile(regex);
            }
            catch (PatternSyntaxException patternSyntaxException) {
                BTThreadLocalAdministrator.logWarnMessages("Regex pattern: " + regex + " is illegal.");
            }
        }
        BTThreadLocalAdministrator.logDebugMessages(new StringBuffer().append("getRegexPattern(String regex)::pattern: ").append(pattern).toString());
        return pattern;
    }

    /*
     * Enabled aggressive exception aggregation
     */
    private static synchronized String getSnippetCode(String filePath) {
        String snippetCode = null;
        try {
            if (filePath != null && filePath.length() > 0) {
                File file = new File(filePath);
                if (!file.isAbsolute()) {
                    if (jarLocation != null && jarLocation.length() > 0) {
                        String jarPath = jarLocation.substring(0, jarLocation.lastIndexOf(File.separator));
                        file = new File(String.valueOf(jarPath) + File.separator + filePath);
                        filePath = file.getAbsolutePath();
                    } else {
                        BTThreadLocalAdministrator.logWarnMessages("Can not get the snippet file location because of the missing browser agent extension jar");
                    }
                }
                if (file != null && file.length() > 0L) {
                    String line;
                    if (!file.canRead()) {
                        BTThreadLocalAdministrator.logErrorMessages(String.valueOf(filePath) + ", this snippet file is not readable.");
                        return null;
                    }
                    String ext = BTThreadLocalAdministrator.getExtension(file);
                    if (ext == null || !ext.equalsIgnoreCase(SNIPPET_FILE_EXT_NAME)) {
                        BTThreadLocalAdministrator.logErrorMessages(String.valueOf(filePath) + ", this snippet file does not have correct extension.");
                        return null;
                    }
                    BufferedReader input = new BufferedReader(new FileReader(file));
                    StringBuffer buf = new StringBuffer();
                    while ((line = input.readLine()) != null) {
                        buf.append(line);
                        buf.append('\n');
                    }
                    snippetCode = buf.toString().trim();
                    if (snippetCode.length() < 1) {
                        BTThreadLocalAdministrator.logErrorMessages(String.valueOf(filePath) + ", the snippet file is empty.");
                        return null;
                    }
                    BTThreadLocalAdministrator.logInfoMessages("Found the snippet file in " + filePath);
                    return BTThreadLocalAdministrator.getReplacedSnippetCode(snippetCode);
                }
                BTThreadLocalAdministrator.logErrorMessages(String.valueOf(filePath) + ", this snippet file is empty or not readable.");
                return null;
            }
            BTThreadLocalAdministrator.logErrorMessages("The snippet file path is empty.");
            return null;
        }
        catch (FileNotFoundException fileNotFoundException) {
            BTThreadLocalAdministrator.logErrorMessages(String.valueOf(filePath) + ", this snippet file is not found.");
            return null;
        }
        catch (IOException iOException) {
            BTThreadLocalAdministrator.logErrorMessages(String.valueOf(filePath) + ", this snippet file could not be initialized.");
            return null;
        }
        catch (SecurityException securityException) {
            BTThreadLocalAdministrator.logErrorMessages(String.valueOf(filePath) + ", security denied access.");
            return null;
        }
        catch (Exception exception) {
            BTThreadLocalAdministrator.logErrorMessages(String.valueOf(filePath) + ", this snippet file could not be initialized.");
            return null;
        }
    }

    private static String getReplacedSnippetCode(String snippetCode) {
        snippetCode = String.valueOf(dxcServerSSLEnabled).equalsIgnoreCase("false") ? snippetCode.replace(dxcServerSSLEnabledPattern, "http") : snippetCode.replace(dxcServerSSLEnabledPattern, "https");
        snippetCode = snippetCode.replace(dxcServerHostReplacementPattern, dxcServerHost);
        snippetCode = snippetCode.replace(dxcServerPortReplacementPattern, String.valueOf(dxcServerPort));
        return snippetCode;
    }

    private static String getExtension(File file) {
        if (file == null) {
            return null;
        }
        String name = file.getName();
        int index = name.lastIndexOf(46);
        if (index == -1) {
            return null;
        }
        return name.substring(index + 1);
    }

    private void removeSnippetProperties() {
        if (configListener != null) {
            fAgent.removeConfigurationListener(configListener);
            configListener = null;
        }
        appGroupKeys = null;
        dxcServerSSLEnabled = false;
        dxcServerHost = "localhost";
        dxcServerPort = 80;
        snippetLocationList = new ArrayList();
        snippetCodeList = new ArrayList();
        includeURLsRegexList = new ArrayList();
        compiledPatternList = new ArrayList();
        snippetCodeWithCorrelationList = new ArrayList();
    }

    private void initializeSnippetProperties() {
        dxcServerHost = this.setDXCServerHost(fAgent.IAgent_getIndexedProperties());
        dxcServerPort = this.setDXCServerPort(fAgent.IAgent_getIndexedProperties());
        dxcServerSSLEnabled = this.setDXCServerSSLEnabled(fAgent.IAgent_getIndexedProperties());
        appGroupKeys = fAgent.IAgent_getIndexedProperties().getTrimmedProperty("introscope.agent.browseragent.autoInjection.appID");
        if (appGroupKeys != null && appGroupKeys.length() == 0) {
            appGroupKeys = null;
        }
        if (sustainabilityMetricsOn) {
            fAgent.IAgent_getDataAccumulatorFactory().safeGetStringEveryEventDataAccumulator("Agent Stats|Sustainability|Browser Agent Business Transaction:introscope.agent.browseragent.autoInjection.appID").IStringEveryEventDataAccumulator_addString(appGroupKeys == null ? "" : appGroupKeys);
        }
        if (appGroupKeys == null) {
            BTThreadLocalAdministrator.logWarnMessages("introscope.agent.browseragent.autoInjection.appID is not provided");
            return;
        }
        this.initializeLists();
        if (configListener == null) {
            configListener = new IConfigurationListener(){

                /*
                 * WARNING - Removed try catching itself - possible behaviour change.
                 * Enabled force condition propagation
                 * Lifted jumps to return sites
                 */
                public void onChange(IndexedProperties props) {
                    if (!autoInjectionEnabled) return;
                    String changedAppIDs = props.getTrimmedProperty("introscope.agent.browseragent.autoInjection.appID");
                    String changedDXCHost = BTThreadLocalAdministrator.this.setDXCServerHost(props);
                    int changedDXCPort = BTThreadLocalAdministrator.this.setDXCServerPort(props);
                    boolean changedDXCSSLEnabled = BTThreadLocalAdministrator.this.setDXCServerSSLEnabled(props);
                    if (changedAppIDs != null && changedAppIDs.length() == 0) {
                        changedAppIDs = null;
                    }
                    if (changedAppIDs == null && appGroupKeys != null) {
                        Class<BTThreadLocalAdministrator> clazz = BTThreadLocalAdministrator.class;
                        synchronized (BTThreadLocalAdministrator.class) {
                            appGroupKeys = changedAppIDs;
                            BTThreadLocalAdministrator.resetLists();
                            // ** MonitorExit[var6_6] (shouldn't be in output)
                            if (sustainabilityMetricsOn) {
                                fAgent.IAgent_getDataAccumulatorFactory().safeGetStringEveryEventDataAccumulator("Agent Stats|Sustainability|Browser Agent Business Transaction:introscope.agent.browseragent.autoInjection.appID").IStringEveryEventDataAccumulator_addString(appGroupKeys == null ? "" : appGroupKeys);
                            }
                            BTThreadLocalAdministrator.logWarnMessages("introscope.agent.browseragent.autoInjection.appID is not provided or invalid");
                            return;
                        }
                    }
                    if (changedAppIDs != null && appGroupKeys == null) {
                        Class<BTThreadLocalAdministrator> clazz = BTThreadLocalAdministrator.class;
                        synchronized (BTThreadLocalAdministrator.class) {
                            appGroupKeys = changedAppIDs;
                            BTThreadLocalAdministrator.resetLists();
                            dxcServerSSLEnabled = changedDXCSSLEnabled;
                            dxcServerHost = changedDXCHost;
                            dxcServerPort = changedDXCPort;
                            BTThreadLocalAdministrator.this.initializeLists();
                            // ** MonitorExit[var6_7] (shouldn't be in output)
                            if (sustainabilityMetricsOn) {
                                fAgent.IAgent_getDataAccumulatorFactory().safeGetStringEveryEventDataAccumulator("Agent Stats|Sustainability|Browser Agent Business Transaction:introscope.agent.browseragent.autoInjection.appID").IStringEveryEventDataAccumulator_addString(appGroupKeys == null ? "" : appGroupKeys);
                            }
                            BTThreadLocalAdministrator.logInfoMessages("Value of the property introscope.agent.browseragent.autoInjection.appID has changed");
                            return;
                        }
                    }
                    if (changedAppIDs != null && appGroupKeys != null) {
                        if (!changedAppIDs.equals(appGroupKeys)) {
                            Class<BTThreadLocalAdministrator> clazz = BTThreadLocalAdministrator.class;
                            synchronized (BTThreadLocalAdministrator.class) {
                                appGroupKeys = changedAppIDs;
                                BTThreadLocalAdministrator.resetLists();
                                dxcServerSSLEnabled = changedDXCSSLEnabled;
                                dxcServerHost = changedDXCHost;
                                dxcServerPort = changedDXCPort;
                                BTThreadLocalAdministrator.this.initializeLists();
                                // ** MonitorExit[var6_8] (shouldn't be in output)
                                if (sustainabilityMetricsOn) {
                                    fAgent.IAgent_getDataAccumulatorFactory().safeGetStringEveryEventDataAccumulator("Agent Stats|Sustainability|Browser Agent Business Transaction:introscope.agent.browseragent.autoInjection.appID").IStringEveryEventDataAccumulator_addString(appGroupKeys == null ? "" : appGroupKeys);
                                }
                                BTThreadLocalAdministrator.logInfoMessages("Value of the property introscope.agent.browseragent.autoInjection.appID has changed");
                                return;
                            }
                        }
                        Class<BTThreadLocalAdministrator> clazz = BTThreadLocalAdministrator.class;
                        synchronized (BTThreadLocalAdministrator.class) {
                            BTThreadLocalAdministrator.reEvaluateLists(changedAppIDs, changedDXCSSLEnabled, changedDXCHost, changedDXCPort, props);
                            // ** MonitorExit[var6_9] (shouldn't be in output)
                            return;
                        }
                    }
                    dxcServerSSLEnabled = changedDXCSSLEnabled;
                    dxcServerHost = changedDXCHost;
                    dxcServerPort = changedDXCPort;
                }
            };
            fAgent.addConfigurationListener(configListener);
        }
    }

    private boolean setDXCServerSSLEnabled(IndexedProperties props) {
        String isSSLEnabled = props.getTrimmedProperty("introscope.agent.browseragent.ssl.enable");
        if (isSSLEnabled != null && isSSLEnabled.length() > 0 && Boolean.valueOf(isSSLEnabled) | Boolean.valueOf(isSSLEnabled) == false) {
            return Boolean.valueOf(isSSLEnabled);
        }
        return false;
    }

    private String setDXCServerHost(IndexedProperties props) {
        String host = props.getTrimmedProperty("introscope.agent.browseragent.dxchost");
        if (host != null && host.length() > 0) {
            return host;
        }
        return "localhost";
    }

    private int setDXCServerPort(IndexedProperties props) {
        String port = props.getTrimmedProperty("introscope.agent.browseragent.dxcport");
        if (port != null && port.length() > 0 && Integer.valueOf(port) > 0 && Integer.valueOf(port) <= 65535) {
            return Integer.valueOf(port);
        }
        BTThreadLocalAdministrator.logWarnMessages(String.valueOf(port) + " is invalid for " + "introscope.agent.browseragent.dxcport" + ", the value only allows numbers between 0 and 65535");
        return 80;
    }

    private void initializeLists() {
        String groupKeys = appGroupKeys;
        if (groupKeys != null && groupKeys.length() > 0) {
            String[] strtok = groupKeys.split(",");
            int i = 0;
            while (i < strtok.length) {
                String key = strtok[i].trim();
                String prefixWithKey = "introscope.agent.browseragent.autoInjection." + key;
                String appGroupSnippetLocationProp = String.valueOf(prefixWithKey) + propSeparator + snippetLocationSuffix;
                String appGroupIncludeURLsRegexProp = String.valueOf(prefixWithKey) + propSeparator + includeURLsRegexSuffix;
                String appGroupSnippetLocation = null;
                String appGroupIncludeURLsRegex = null;
                if (BTThreadLocalAdministrator.onlyContainsLetterAndNumber(key)) {
                    appGroupSnippetLocation = fAgent.IAgent_getIndexedProperties().getTrimmedProperty(appGroupSnippetLocationProp);
                    appGroupIncludeURLsRegex = fAgent.IAgent_getIndexedProperties().getTrimmedProperty(appGroupIncludeURLsRegexProp);
                }
                if (appGroupSnippetLocation != null && appGroupSnippetLocation.length() == 0) {
                    appGroupSnippetLocation = null;
                }
                if (appGroupIncludeURLsRegex != null && appGroupIncludeURLsRegex.length() == 0) {
                    appGroupIncludeURLsRegex = null;
                }
                includeURLsRegexList.add(i, appGroupIncludeURLsRegex);
                snippetLocationList.add(i, appGroupSnippetLocation);
                if (appGroupIncludeURLsRegex == null) {
                    BTThreadLocalAdministrator.logWarnMessages("Value for the property " + appGroupIncludeURLsRegexProp + " is not provided or invalid");
                    compiledPatternList.add(i, null);
                } else {
                    try {
                        Pattern compiledPattern = Pattern.compile(appGroupIncludeURLsRegex);
                        compiledPatternList.add(i, compiledPattern);
                    }
                    catch (PatternSyntaxException patternSyntaxException) {
                        BTThreadLocalAdministrator.logErrorMessages("PatternSyntaxException is thrown for " + appGroupIncludeURLsRegexProp + ", check your syntax. Pattern will be ignored");
                        compiledPatternList.add(i, null);
                    }
                }
                if (appGroupSnippetLocation == null) {
                    BTThreadLocalAdministrator.logWarnMessages("Value for the property " + appGroupSnippetLocationProp + " is not provided or invalid");
                    snippetCodeList.add(i, null);
                    snippetCodeWithCorrelationList.add(i, null);
                } else {
                    String snippetCode = BTThreadLocalAdministrator.getSnippetCode(appGroupSnippetLocation);
                    if (snippetCode == null) {
                        BTThreadLocalAdministrator.logWarnMessages("Value for the property " + appGroupSnippetLocationProp + " is not provided or invalid");
                        snippetCodeList.add(i, null);
                        snippetCodeWithCorrelationList.add(i, null);
                    } else {
                        snippetCodeList.add(i, snippetCode);
                        snippetCodeWithCorrelationList.add(i, BTThreadLocalAdministrator.getSnippetCodeWithCorrelationReplacement(snippetCode));
                    }
                }
                ++i;
            }
        }
    }

    private static boolean onlyContainsLetterAndNumber(String key) {
        Pattern p = Pattern.compile(APP_ID_KEY_PATTERN);
        if (p.matcher(key).matches()) {
            return true;
        }
        BTThreadLocalAdministrator.logWarnMessages(String.valueOf(key) + " is invalid for " + "introscope.agent.browseragent.autoInjection.appID" + ", the value only allows numbers and letters");
        return false;
    }

    private static void resetLists() {
        snippetLocationList = new ArrayList();
        snippetCodeList = new ArrayList();
        includeURLsRegexList = new ArrayList();
        compiledPatternList = new ArrayList();
        snippetCodeWithCorrelationList = new ArrayList();
    }

    private static void reEvaluateLists(String groupKeys, boolean changedDXCSSLEnabled, String changedDXCHost, int changedDXCPort, IndexedProperties props) {
        ArrayList<String> localSnippetLocationList = new ArrayList<String>();
        ArrayList<String> localSnippetCodeList = new ArrayList<String>();
        ArrayList<String> localIncludeURLsRegexList = new ArrayList<String>();
        ArrayList<Pattern> localCompiledPatternList = new ArrayList<Pattern>();
        ArrayList<String> localSnippetCodeWithCorrelationList = new ArrayList<String>();
        boolean changedSnippetLocation = false;
        boolean changedIncludeURLsRegex = false;
        if (groupKeys != null && groupKeys.length() > 0) {
            String[] strtok = groupKeys.split(",");
            int i = 0;
            while (i < strtok.length) {
                String key = strtok[i].trim();
                String prefixWithKey = "introscope.agent.browseragent.autoInjection." + key;
                String appGroupSnippetLocationProp = String.valueOf(prefixWithKey) + propSeparator + snippetLocationSuffix;
                String appGroupIncludeURLsRegexProp = String.valueOf(prefixWithKey) + propSeparator + includeURLsRegexSuffix;
                String appGroupSnippetLocation = null;
                String appGroupIncludeURLsRegex = null;
                if (BTThreadLocalAdministrator.onlyContainsLetterAndNumber(key)) {
                    appGroupSnippetLocation = props.getTrimmedProperty(appGroupSnippetLocationProp);
                    appGroupIncludeURLsRegex = props.getTrimmedProperty(appGroupIncludeURLsRegexProp);
                }
                if (appGroupIncludeURLsRegex != null && appGroupIncludeURLsRegex.length() == 0) {
                    appGroupIncludeURLsRegex = null;
                }
                if (appGroupIncludeURLsRegex == null) {
                    if (includeURLsRegexList.get(i) != null) {
                        BTThreadLocalAdministrator.logWarnMessages("Value of the property " + appGroupIncludeURLsRegexProp + " is not provided or invalid");
                        changedIncludeURLsRegex = true;
                    }
                    localCompiledPatternList.add(i, null);
                } else if (!appGroupIncludeURLsRegex.equals((String)includeURLsRegexList.get(i))) {
                    BTThreadLocalAdministrator.logTraceMessages("Value of the property " + appGroupIncludeURLsRegexProp + " has changed");
                    changedIncludeURLsRegex = true;
                    try {
                        Pattern compiledPattern = Pattern.compile(appGroupIncludeURLsRegex);
                        localCompiledPatternList.add(i, compiledPattern);
                    }
                    catch (PatternSyntaxException patternSyntaxException) {
                        BTThreadLocalAdministrator.logErrorMessages("PatternSyntaxException is thrown for " + appGroupIncludeURLsRegexProp + ", check your syntax. Pattern will be ignored");
                        localCompiledPatternList.add(i, null);
                    }
                } else {
                    localCompiledPatternList.add(i, (Pattern)compiledPatternList.get(i));
                }
                if (appGroupSnippetLocation != null && appGroupSnippetLocation.length() == 0) {
                    appGroupSnippetLocation = null;
                }
                if (appGroupSnippetLocation == null) {
                    if (snippetLocationList.get(i) != null) {
                        BTThreadLocalAdministrator.logWarnMessages("Value for the property " + appGroupSnippetLocationProp + " is not provided or invalid");
                        changedSnippetLocation = true;
                    }
                    localSnippetCodeList.add(i, null);
                    localSnippetCodeWithCorrelationList.add(i, null);
                } else if (!appGroupSnippetLocation.equals((String)snippetLocationList.get(i)) || dxcServerSSLEnabled != changedDXCSSLEnabled || !dxcServerHost.equals(changedDXCHost) || dxcServerPort != changedDXCPort) {
                    BTThreadLocalAdministrator.logTraceMessages("Value of the property " + appGroupSnippetLocationProp + " or DxC server URL has changed");
                    changedSnippetLocation = true;
                    dxcServerSSLEnabled = changedDXCSSLEnabled;
                    dxcServerHost = changedDXCHost;
                    dxcServerPort = changedDXCPort;
                    String snippetCode = BTThreadLocalAdministrator.getSnippetCode(appGroupSnippetLocation);
                    if (snippetCode == null) {
                        BTThreadLocalAdministrator.logWarnMessages("Value for the property " + appGroupSnippetLocationProp + " is not provided or invalid");
                        localSnippetCodeList.add(i, null);
                        localSnippetCodeWithCorrelationList.add(i, null);
                    } else {
                        localSnippetCodeList.add(i, snippetCode);
                        localSnippetCodeWithCorrelationList.add(i, BTThreadLocalAdministrator.getSnippetCodeWithCorrelationReplacement(snippetCode));
                    }
                } else {
                    localSnippetCodeList.add(i, (String)snippetCodeList.get(i));
                    localSnippetCodeWithCorrelationList.add(i, (String)snippetCodeWithCorrelationList.get(i));
                }
                localSnippetLocationList.add(i, appGroupSnippetLocation);
                localIncludeURLsRegexList.add(i, appGroupIncludeURLsRegex);
                ++i;
            }
            if (changedIncludeURLsRegex) {
                includeURLsRegexList = localIncludeURLsRegexList;
                compiledPatternList = localCompiledPatternList;
            }
            if (changedSnippetLocation) {
                snippetLocationList = localSnippetLocationList;
                snippetCodeList = localSnippetCodeList;
                snippetCodeWithCorrelationList = localSnippetCodeWithCorrelationList;
            }
        }
    }

    private void setBAExtJarLocation() {
        IPlugin[] plugins;
        IPlugin[] iPluginArray = plugins = fAgent.IAgent_getExtensionAdministrator().getAgentPluginsByType("tracer");
        int n = plugins.length;
        int n2 = 0;
        while (n2 < n) {
            IPlugin plugin = iPluginArray[n2];
            if (extensionJarTracerName.equalsIgnoreCase(plugin.IPlugin_getName())) {
                jarLocation = plugin.IPlugin_getOwningExtension().IExtension_getSource();
                break;
            }
            ++n2;
        }
        if (jarLocation == null) {
            BTThreadLocalAdministrator.logWarnMessages("Can not find the browser agent extension jar.");
        } else {
            BTThreadLocalAdministrator.logInfoMessages("Found the browser agent extension jar in " + jarLocation);
        }
    }

    public String getBAExtJarLocation() {
        return jarLocation;
    }

    public boolean isAutoInjectionEnabled() {
        return autoInjectionEnabled;
    }

    public Boolean isResponseDecorationEnabled() {
        return responseDecorationEnabled;
    }

    public Boolean isResponseDecorationAPMDataEnabled() {
        if (apmDataResponseDecorationEnabled && responseDecorationEnabled) {
            return true;
        }
        return false;
    }

    public List getSnippetCodeList() {
        return snippetCodeList;
    }

    public List getSnippetCodeWithCorrelationList() {
        return snippetCodeWithCorrelationList;
    }

    public List getCompiledPatternList() {
        return compiledPatternList;
    }

    public Pattern getResponseDecorationIncludeURLsRegexPattern() {
        return responseDecorationIncludeURLsRegexPattern;
    }

    public static int getResponseCookieExpirationTime() {
        return responseCookieExpirationTime;
    }

    private static String getSnippetCodeWithCorrelationReplacement(String source) {
        if (source != null) {
            int index = source.toLowerCase().lastIndexOf(SCRIPT_TAG_START) + 7;
            source = String.valueOf(source.substring(0, index)) + SNIPPET_CORRELATION_STRING + source.substring(index + 1);
        }
        return source;
    }

    public String[] getCookieContentTypeArray() {
        return cookieContentTypeArray;
    }

    public boolean isCorguidEnabled() {
        return corguidEnabled;
    }

    /* synthetic */ BTThreadLocalAdministrator(BTThreadLocalAdministrator bTThreadLocalAdministrator) {
        this();
    }

    final class AuotInjectionEnabledProperty
    extends BooleanConfigurationProperty {
        private AuotInjectionEnabledProperty(IAgent agent) {
            super("introscope.agent.browseragent.autoInjectionEnabled", new Boolean(false), "Enables/Disables Auto Snippet Injection for Browser Agent", true, false, agent.IAgent_getModuleFeedback(), kModule, agent.IAgent_getStringLocalizer());
        }

        public void set(Object newValue) {
            reInitialize = true;
            autoInjectionEnabled = (Boolean)newValue;
            if (autoInjectionEnabled) {
                if (sustainabilityMetricsOn) {
                    fAgent.IAgent_getDataAccumulatorFactory().safeGetIntegerFluctuatingCounterDataAccumulator("Agent Stats|Sustainability|Browser Agent Business Transaction:introscope.agent.browseragent.autoInjectionEnabled").IIntegerCounterDataAccumulator_setValue(1);
                }
                BTThreadLocalAdministrator.this.initializeSnippetProperties();
                BTThreadLocalAdministrator.logDebugMessages("Auto Snippet Injection is enabled");
            } else {
                if (sustainabilityMetricsOn) {
                    fAgent.IAgent_getDataAccumulatorFactory().safeGetIntegerFluctuatingCounterDataAccumulator("Agent Stats|Sustainability|Browser Agent Business Transaction:introscope.agent.browseragent.autoInjectionEnabled").IIntegerCounterDataAccumulator_setValue(0);
                }
                BTThreadLocalAdministrator.this.removeSnippetProperties();
                BTThreadLocalAdministrator.logDebugMessages("Auto Snippet Injection is disabled");
            }
        }
    }

    final class AutoInjectionSnippetThrottleResponseLimitProperty
    extends PositiveIntegerConfigurationProperty {
        private AutoInjectionSnippetThrottleResponseLimitProperty(IAgent agent) {
            super("introscope.agent.browseragent.autoInjection.throttleResponseLimit", new Integer(1000), agent.IAgent_getModuleFeedback(), kModule, agent.IAgent_getStringLocalizer());
        }

        public void set(Object newValue) {
            throttleResponseLimit = (Integer)newValue;
            reInitialize = true;
            if (throttleResponseLimit >= 0) {
                BTThreadLocalAdministrator.logDebugMessages(new StringBuffer().append("introscope.agent.browseragent.autoInjection.throttleResponseLimit").append(" is set to ").append(throttleResponseLimit).toString());
            } else {
                BTThreadLocalAdministrator.logDebugMessages(new StringBuffer().append("introscope.agent.browseragent.autoInjection.throttleResponseLimit").append(" cannot be set to a negative value ").append(throttleResponseLimit).append(", this property will be set to the default value ").append(1000).toString());
                throttleResponseLimit = 1000;
            }
            if (sustainabilityMetricsOn) {
                fAgent.IAgent_getDataAccumulatorFactory().safeGetIntegerFluctuatingCounterDataAccumulator("Agent Stats|Sustainability|Browser Agent Business Transaction:introscope.agent.browseragent.autoInjection.throttleResponseLimit").IIntegerCounterDataAccumulator_setValue(throttleResponseLimit);
            }
        }
    }

    final class AutoskipInstrumentclassDepthProperty
    extends PositiveIntegerConfigurationProperty {
        private AutoskipInstrumentclassDepthProperty(IAgent agent) {
            super("introscope.agent.browseragent.instrumentclass.autoskip.depth", new Integer(1), agent.IAgent_getModuleFeedback(), kModule, agent.IAgent_getStringLocalizer());
        }

        public void set(Object newValue) {
            autoskipInstrumentClassDepth = (Integer)newValue;
            BTThreadLocalAdministrator.logDebugMessages(new StringBuffer().append("introscope.agent.browseragent.instrumentclass.autoskip.depth").append(" is set to ").append(autoskipInstrumentClassDepth).toString());
        }
    }

    private static final class BTThreadLocalAdministratorInstance {
        public static final BTThreadLocalAdministrator kInstance = new BTThreadLocalAdministrator(null);

        private BTThreadLocalAdministratorInstance() {
        }
    }

    final class CookieContentTypeProperty
    extends ConfigurationProperty {
        private CookieContentTypeProperty(IAgent agent) {
            super(COOKIE_CONTENTTYPE_PROPERTY, cookieContentType, agent.IAgent_getModuleFeedback(), kModule, agent.IAgent_getStringLocalizer());
        }

        public void set(Object newValue) {
            cookieContentType = ((String)newValue).trim();
            BTThreadLocalAdministrator.logDebugMessages(new StringBuffer().append(COOKIE_CONTENTTYPE_PROPERTY).append(" is set to ").append(cookieContentType).toString());
            if (cookieContentType != null && ".*".equalsIgnoreCase(cookieContentType)) {
                cookieContentTypeArray = null;
            } else {
                cookieContentTypeArray = cookieContentType.split(",");
            }
            if (sustainabilityMetricsOn) {
                fAgent.IAgent_getDataAccumulatorFactory().safeGetStringEveryEventDataAccumulator("Agent Stats|Sustainability|Browser Agent Business Transaction:" + COOKIE_CONTENTTYPE_PROPERTY).IStringEveryEventDataAccumulator_addString(cookieContentType == null ? "" : cookieContentType);
            }
        }
    }

    final class CorguidEnabledProperty
    extends BooleanConfigurationProperty {
        private CorguidEnabledProperty(IAgent agent) {
            super(BTThreadLocalAdministrator.PROPERTYNAME_CORGUIDENABLED, Boolean.FALSE, "Enables/Disables sending corguid for Browser Agent", true, false, agent.IAgent_getModuleFeedback(), kModule, agent.IAgent_getStringLocalizer());
        }

        public void set(Object newValue) {
            corguidEnabled = (Boolean)newValue;
        }
    }

    final class EncodingSupportEnabledProperty
    extends BooleanConfigurationProperty {
        private EncodingSupportEnabledProperty(IAgent agent) {
            super("introscope.agent.browseragent.contentencoding.enabled", new Boolean(false), "Enables/Disables encoding support property for browser agent", true, false, agent.IAgent_getModuleFeedback(), kModule, agent.IAgent_getStringLocalizer());
        }

        public void set(Object newValue) {
            encodingEnabled = (Boolean)newValue;
            if (encodingEnabled) {
                BTThreadLocalAdministrator.logDebugMessages("Content encoding support is enabled");
                if (sustainabilityMetricsOn) {
                    fAgent.IAgent_getDataAccumulatorFactory().safeGetIntegerFluctuatingCounterDataAccumulator("Agent Stats|Sustainability|Browser Agent Business Transaction:introscope.agent.browseragent.contentencoding.enabled").IIntegerCounterDataAccumulator_setValue(1);
                }
            } else {
                BTThreadLocalAdministrator.logDebugMessages("Content encoding support is disabled");
                if (sustainabilityMetricsOn) {
                    fAgent.IAgent_getDataAccumulatorFactory().safeGetIntegerFluctuatingCounterDataAccumulator("Agent Stats|Sustainability|Browser Agent Business Transaction:introscope.agent.browseragent.contentencoding.enabled").IIntegerCounterDataAccumulator_setValue(0);
                }
            }
        }
    }

    final class HeadFilterPresenceCheckProperty
    extends BooleanConfigurationProperty {
        private HeadFilterPresenceCheckProperty(IAgent agent) {
            super("introscope.agent.browseragent.checkHeadFilterPresence.enabled", new Boolean(true), "Enables/Disables head filter presence check for Browser Agent", true, false, agent.IAgent_getModuleFeedback(), kModule, agent.IAgent_getStringLocalizer());
        }

        public void set(Object newValue) {
            headFilterPresenceCheckEnabled = (Boolean)newValue;
            if (headFilterPresenceCheckEnabled) {
                BTThreadLocalAdministrator.logDebugMessages("Head filter presence check is enabled");
            } else {
                BTThreadLocalAdministrator.logDebugMessages("Head filter presence check is disabled");
            }
        }
    }

    final class MaxResponseContentLengthForSearchingProperty
    extends PositiveLongConfigurationProperty {
        private MaxResponseContentLengthForSearchingProperty(IAgent agent) {
            super("introscope.agent.browseragent.autoInjection.snippet.maxSearchingLength", new Long(32768L), agent.IAgent_getModuleFeedback(), kModule, agent.IAgent_getStringLocalizer());
        }

        public void set(Object newValue) {
            snippetMaxSearchingLength = (Long)newValue;
            if (snippetMaxSearchingLength >= 0L) {
                BTThreadLocalAdministrator.logDebugMessages(new StringBuffer().append("introscope.agent.browseragent.autoInjection.snippet.maxSearchingLength").append(" is set to ").append(snippetMaxSearchingLength).toString());
            } else {
                BTThreadLocalAdministrator.logDebugMessages(new StringBuffer().append("introscope.agent.browseragent.autoInjection.snippet.maxSearchingLength").append(" cannot be set to a negative value ").append(snippetMaxSearchingLength).append(", this property will be set to the default value ").append(32768L).toString());
                snippetMaxSearchingLength = 32768L;
            }
            if (sustainabilityMetricsOn) {
                fAgent.IAgent_getDataAccumulatorFactory().safeGetLongFluctuatingCounterDataAccumulator("Agent Stats|Sustainability|Browser Agent Business Transaction:introscope.agent.browseragent.autoInjection.snippet.maxSearchingLength").ILongCounterDataAccumulator_setValue(snippetMaxSearchingLength);
            }
        }
    }

    final class SearchingMethodHierarchyMaxDepthProperty
    extends PositiveIntegerConfigurationProperty {
        private SearchingMethodHierarchyMaxDepthProperty(IAgent agent) {
            super("introscope.agent.browseragent.searchingmethodhierarchy.max.depth", new Integer(3), agent.IAgent_getModuleFeedback(), kModule, agent.IAgent_getStringLocalizer());
        }

        public void set(Object newValue) {
            searchingMethodHierarchyMaxDepth = (Integer)newValue;
            if (searchingMethodHierarchyMaxDepth >= 0) {
                BTThreadLocalAdministrator.logDebugMessages(new StringBuffer().append("introscope.agent.browseragent.searchingmethodhierarchy.max.depth").append(" is set to ").append(searchingMethodHierarchyMaxDepth).toString());
            } else {
                BTThreadLocalAdministrator.logDebugMessages(new StringBuffer().append("introscope.agent.browseragent.searchingmethodhierarchy.max.depth").append(" cannot be set to a negative value ").append(searchingMethodHierarchyMaxDepth).append(", this property will be set to the default value ").append(3).toString());
                searchingMethodHierarchyMaxDepth = 3;
            }
        }
    }

    final class SustainabilityMetricsProperty
    extends BooleanConfigurationProperty {
        private SustainabilityMetricsProperty(IAgent agent) {
            super("introscope.agent.browseragent.sustainabilityMetrics.enabled", new Boolean(true), "Enables/Disables Sustainability Metrics for Browser Agent", true, false, agent.IAgent_getModuleFeedback(), kModule, agent.IAgent_getStringLocalizer());
        }

        public void set(Object newValue) {
            sustainabilityMetricsOn = (Boolean)newValue;
            reInitialize = true;
            if (sustainabilityMetricsOn) {
                BTThreadLocalAdministrator.this.startReportingSustainabilityMetrics();
                fAgent.IAgent_getDataAccumulatorFactory().safeGetIntegerFluctuatingCounterDataAccumulator("Agent Stats|Sustainability|Browser Agent Business Transaction:introscope.agent.browseragent.sustainabilityMetrics.enabled").IIntegerCounterDataAccumulator_setValue(1);
                BTThreadLocalAdministrator.logDebugMessages("Sustainability Metrics is enabled");
            } else {
                BTThreadLocalAdministrator.this.stopReportSustainabilityMetrics();
                fAgent.IAgent_getDataAccumulatorFactory().safeGetIntegerFluctuatingCounterDataAccumulator("Agent Stats|Sustainability|Browser Agent Business Transaction:introscope.agent.browseragent.sustainabilityMetrics.enabled").IIntegerCounterDataAccumulator_setValue(0);
                BTThreadLocalAdministrator.logDebugMessages("Sustainability Metrics is disabled");
            }
        }
    }

    final class TailFilterPresenceCheckProperty
    extends BooleanConfigurationProperty {
        private TailFilterPresenceCheckProperty(IAgent agent) {
            super("introscope.agent.browseragent.checkTailFilterPresence.enabled", new Boolean(true), "Enables/Disables tail filter presence check for Browser Agent", true, false, agent.IAgent_getModuleFeedback(), kModule, agent.IAgent_getStringLocalizer());
        }

        public void set(Object newValue) {
            tailFilterPresenceCheckEnabled = (Boolean)newValue;
            if (tailFilterPresenceCheckEnabled) {
                BTThreadLocalAdministrator.logDebugMessages("Tail filter presence check is enabled");
            } else {
                BTThreadLocalAdministrator.logDebugMessages("Tail filter Presence check is disabled");
            }
        }
    }
}

