/*
 * Decompiled with CFR 0.152.
 */
package com.wily.introscope.agent.trace;

import com.wily.introscope.agent.IAgent;
import com.wily.introscope.agent.extension.DuplicateDynamicClassException;
import com.wily.introscope.agent.extension.ExtensionAdministrator;
import com.wily.introscope.agent.extension.InstantiableDynamicClassLookup;
import com.wily.introscope.agent.extension.InvalidDynamicClassException;
import com.wily.introscope.agent.trace.INameFormatter;
import com.wily.introscope.agent.trace.NameFormatterOSGiLoader;
import com.wily.introscope.agent.transformer.dynamic.AInstrumentationHelper;
import com.wily.util.extension.ExtensionUtilities;
import com.wily.util.extension.IPlugin;
import com.wily.util.feedback.IValidationFeedbackChannel;
import com.wily.util.text.IStringLocalizer;
import com.wily.wilyassert.Assertion;

final class NameFormatterLoader
extends InstantiableDynamicClassLookup {
    private static final String kNameFormatterPluginType = "nameformatter";
    private static final int kCurrentNameFormatterPluginVersion = 1;
    private static final Class[] kNameFormatterConstructorParameterTypes = new Class[]{IAgent.class};
    private IValidationFeedbackChannel fValidationFeedbackChannel;

    public NameFormatterLoader(IAgent agent) {
        super(agent, INameFormatter.class, kNameFormatterConstructorParameterTypes);
        if (AInstrumentationHelper.isValidate()) {
            this.fValidationFeedbackChannel = AInstrumentationHelper.getValidationFeedbackChannel();
        }
        this.loadNameFormatterPlugins();
    }

    protected Object[] getConstructorParameters(IAgent dynamicAgent) {
        return new Object[]{dynamicAgent};
    }

    public INameFormatter loadNameFormatter(String nameFormatterName) {
        return (INameFormatter)this.load(nameFormatterName);
    }

    private void loadNameFormatterPlugins() {
        ExtensionAdministrator extensionAdministrator = this.getAgent().IAgent_getExtensionAdministrator();
        Assertion.wilyAssert(false);
        IPlugin[] plugins = extensionAdministrator.getAgentPluginsByType(kNameFormatterPluginType);
        int i = 0;
        while (i < plugins.length) {
            this.loadNameFormatterPlugin(plugins[i]);
            ++i;
        }
        extensionAdministrator.setGlobalPluginCallbackByType(kNameFormatterPluginType, new IPlugin.IPluginCallback(){

            public void onUnload(IPlugin p) {
            }

            public void onLoad(IPlugin p) {
                NameFormatterLoader.this.loadNameFormatterPlugin(p);
            }
        });
    }

    private void loadNameFormatterPlugin(IPlugin plugin) {
        Class nameFormatterClass = ExtensionUtilities.loadEntryPointClass(this.getModuleFeedback(), this.getStringLocalizer(), plugin, 1, INameFormatter.class, this.fValidationFeedbackChannel);
        if (nameFormatterClass != null) {
            IStringLocalizer nameFormatterLocalizer = plugin.IPlugin_getOwningExtension().IExtension_getStringLocalizer(this.getStringLocalizer());
            try {
                this.register(plugin, nameFormatterClass.getName(), nameFormatterClass, nameFormatterLocalizer);
                this.getModuleFeedback().verbose(this.getStringLocalizer().IStringLocalizer_getFormattedLocalizedString("Agent_Tracer_Factory_Name_Formatter_Plugin_Registered_Message", plugin.IPlugin_getOwningExtension().IExtension_getName(), plugin.IPlugin_getName()));
            }
            catch (DuplicateDynamicClassException ddce) {
                String errorMessage = this.getStringLocalizer().IStringLocalizer_getFormattedLocalizedString("Agent_Tracer_Factory_Name_Formatter_Plugin_Duplicate_Message", plugin.IPlugin_getOwningExtension().IExtension_getSource(), plugin.IPlugin_getOwningExtension().IExtension_getName(), plugin.IPlugin_getName());
                this.logErrorValidationFeedback(errorMessage, ddce);
                this.getModuleFeedback().error(errorMessage);
                this.getModuleFeedback().verbose(ddce);
            }
            catch (InvalidDynamicClassException idce) {
                String errorMessage = this.getStringLocalizer().IStringLocalizer_getFormattedLocalizedString("Agent_Tracer_Factory_Name_Formatter_Plugin_Invalid_Message", plugin.IPlugin_getOwningExtension().IExtension_getSource(), plugin.IPlugin_getOwningExtension().IExtension_getName(), plugin.IPlugin_getName());
                this.logErrorValidationFeedback(errorMessage, idce);
                this.getModuleFeedback().error(errorMessage);
                this.getModuleFeedback().verbose(idce);
            }
        }
    }

    public void addAllExtensions(NameFormatterOSGiLoader nameFormatterOSGiLoader) {
        super.addAllExtensions(nameFormatterOSGiLoader);
    }

    private void logErrorValidationFeedback(String message, Throwable cause) {
        if (this.fValidationFeedbackChannel != null) {
            this.fValidationFeedbackChannel.error(message, cause);
        }
    }
}

