/*
 * Decompiled with CFR 0.152.
 */
package com.wily.introscope.agent.trace;

import com.wily.introscope.agent.IAgent;
import com.wily.introscope.agent.stat.IIntegerFluctuatingCounterDataAccumulator;
import com.wily.introscope.agent.trace.ASingleInstanceTracerFactory;
import com.wily.introscope.agent.trace.InvocationData;
import com.wily.introscope.agent.trace.ProbeIdentification;
import com.wily.introscope.agent.trace.ReentrancyLevel;
import com.wily.util.heartbeat.IRegisteredBehavior;
import com.wily.util.heartbeat.ITimestampedRunnable;
import com.wily.util.properties.AttributeListing;
import com.wily.util.task.ASimpleExecutableItem;
import com.wily.wilyassert.Assertion;
import java.lang.ref.ReferenceQueue;
import java.lang.ref.WeakReference;
import java.util.HashMap;
import java.util.Map;

public final class SimpleInstanceCounter
extends ASingleInstanceTracerFactory {
    private static final InstanceSet[] kZeroLengthInstanceSetArray = new InstanceSet[0];
    private static ReferenceQueue sReferenceQueue;
    private static Map sClassToInstanceMap;
    private static IRegisteredBehavior sBehavior;
    private static IAgent fAgent;
    private static long sInstanceTrackingLimit;
    private static final String kTrackingProperty = "com.wily.introscope.agent.simpleInstanceCounter.referenceTrackingLimit";
    private static final int kInstanceTrackingClamp = 25000;
    private final InstanceSet fInstanceSet;

    private static synchronized void initialize(IAgent agent) {
        fAgent = agent;
        if (sBehavior == null) {
            sReferenceQueue = new ReferenceQueue();
            sClassToInstanceMap = new HashMap();
            sInstanceTrackingLimit = agent.IAgent_getIndexedProperties().getLongProperty(kTrackingProperty, 25000L);
            sBehavior = agent.IAgent_getConfigHeartbeat().addBehavior((ITimestampedRunnable)new InstanceCountingBehavior(agent), "Simple Instance Counter", true, 7500L, true);
        }
    }

    public SimpleInstanceCounter(IAgent agent, AttributeListing parameters, ProbeIdentification probe, Object sampleTracedObject) {
        super(agent, parameters, probe, sampleTracedObject);
        SimpleInstanceCounter.initialize(agent);
        this.fInstanceSet = SimpleInstanceCounter.getInstanceSet(probe.getRuntimeFullClassName());
    }

    public boolean ITracerFactory_isShutoff() {
        return false;
    }

    public final ReentrancyLevel ITracerFactory_getReentrancyLevel() {
        return ReentrancyLevel.kNone;
    }

    public void ITracer_startTrace(int tracerIndex, InvocationData data) {
    }

    public void ITracer_finishTrace(int tracerIndex, InvocationData data) {
        Object returnValue;
        boolean nameCheck;
        Object instance = data.getInvocationObject();
        this.fInstanceSet.noticeMetricName(fAgent, this.formatParameterizedName(data));
        if (instance != null && (nameCheck = instance.getClass().getName().equals(this.fInstanceSet.fClassName))) {
            this.fInstanceSet.noticeInstance(instance);
        }
        if (data.hasMethodResultAvailable() && (returnValue = data.getInvocationReturnValueAsObject()) != null) {
            this.fInstanceSet.noticeInstance(returnValue);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static InstanceSet getInstanceSet(String className) {
        Map map = sClassToInstanceMap;
        synchronized (map) {
            InstanceSet instanceSet = (InstanceSet)sClassToInstanceMap.get(className);
            if (instanceSet == null) {
                instanceSet = new InstanceSet(className);
                sClassToInstanceMap.put(className, instanceSet);
            }
            return instanceSet;
        }
    }

    private static void updateInstanceCounts(IAgent agent) {
        InstanceReference reference = (InstanceReference)sReferenceQueue.poll();
        while (reference != null) {
            reference.fInstanceSet.removeInstance(reference);
            reference = (InstanceReference)sReferenceQueue.poll();
        }
        SimpleInstanceCounter.updateCountMetrics(agent);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static void updateCountMetrics(IAgent agent) {
        InstanceSet[] instanceSets;
        Map map = sClassToInstanceMap;
        synchronized (map) {
            instanceSets = sClassToInstanceMap.values().toArray(kZeroLengthInstanceSetArray);
        }
        int i = 0;
        while (i < instanceSets.length) {
            instanceSets[i].updateCounters();
            ++i;
        }
    }

    static void debug_updateInstanceCounts(IAgent agent) {
        SimpleInstanceCounter.updateInstanceCounts(agent);
    }

    private static final class InstanceCountingBehavior
    implements ITimestampedRunnable {
        private final IAgent fAgent;

        public InstanceCountingBehavior(IAgent agent) {
            this.fAgent = agent;
        }

        public void ITimestampedRunnable_execute(long nowInMillis) {
            this.fAgent.IAgent_getSharedAsyncQueue().IExecutionQueue_addExecutableItem(new ASimpleExecutableItem(){

                public void IExecutableItem_execute() {
                    SimpleInstanceCounter.updateInstanceCounts(InstanceCountingBehavior.this.fAgent);
                }
            });
        }
    }

    private static final class InstanceReference
    extends WeakReference {
        public final InstanceSet fInstanceSet;
        private final int fHashCode;
        public InstanceReference fNext;

        public InstanceReference(Object instance, int hashCode, InstanceSet instanceSet, ReferenceQueue referenceQueue) {
            super(instance, referenceQueue);
            this.fInstanceSet = instanceSet;
            this.fHashCode = hashCode;
        }

        public boolean equals(Object o) {
            Object u;
            if (this == o) {
                return true;
            }
            if (!(o instanceof InstanceReference)) {
                return false;
            }
            Object t = this.get();
            return t == (u = ((InstanceReference)o).get());
        }

        public int hashCode() {
            return this.fHashCode;
        }
    }

    private static final class InstanceSet {
        private static final IIntegerFluctuatingCounterDataAccumulator[] kZeroLengthMetricArray = new IIntegerFluctuatingCounterDataAccumulator[0];
        private static final int kDefaultInitialCapacity = 95;
        private static final float kLoadFactor = 0.75f;
        private static final int kWarnLogLimit = 20;
        private static int sWarnLoggerCount = 0;
        public final String fClassName;
        private IIntegerFluctuatingCounterDataAccumulator[] fMetrics;
        private InstanceReference[] fTable;
        private int fCount;
        private IAgent myagent = null;

        public InstanceSet(String className) {
            this.fClassName = className;
            this.fMetrics = kZeroLengthMetricArray;
            this.fTable = new InstanceReference[95];
            this.fCount = 0;
        }

        private Object getMetricLock() {
            return this;
        }

        private Object getInstanceLock() {
            return this;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public void noticeMetricName(IAgent agent, String metricName) {
            this.myagent = agent;
            IIntegerFluctuatingCounterDataAccumulator counter = agent.IAgent_getDataAccumulatorFactory().safeGetIntegerFluctuatingCounterDataAccumulator(metricName);
            Object object = this.getMetricLock();
            synchronized (object) {
                boolean containsCounter = false;
                int i = 0;
                while (i < this.fMetrics.length) {
                    if (this.fMetrics[i].equals(counter)) {
                        containsCounter = true;
                    }
                    ++i;
                }
                if (!containsCounter) {
                    IIntegerFluctuatingCounterDataAccumulator[] newMetrics = new IIntegerFluctuatingCounterDataAccumulator[this.fMetrics.length + 1];
                    System.arraycopy(this.fMetrics, 0, newMetrics, 0, this.fMetrics.length);
                    newMetrics[this.fMetrics.length] = counter;
                    this.fMetrics = newMetrics;
                }
            }
        }

        public void updateCounters() {
            IIntegerFluctuatingCounterDataAccumulator[] metrics = this.fMetrics;
            int count = this.size();
            int i = 0;
            while (i < metrics.length) {
                metrics[i].IIntegerCounterDataAccumulator_setValue(count);
                ++i;
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        private int size() {
            Object object = this.getInstanceLock();
            synchronized (object) {
                return this.fCount;
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public void noticeInstance(Object instance) {
            if ((long)this.fCount > sInstanceTrackingLimit) {
                if (sWarnLoggerCount < 20) {
                    this.myagent.IAgent_getModuleFeedback().warn("SimpleInstanceCounter: while tracking instances of type " + instance.getClass().getName() + " , too many instances are being tracked in a " + " short interval. Clamp limit of " + sInstanceTrackingLimit + " has reached and " + " tracking new instances will stop. To raise clamp limit, add property " + SimpleInstanceCounter.kTrackingProperty);
                    ++sWarnLoggerCount;
                }
                return;
            }
            Object object = this.getInstanceLock();
            synchronized (object) {
                int hashcode = System.identityHashCode(instance);
                if (!this.contains(instance, hashcode)) {
                    InstanceReference reference = new InstanceReference(instance, hashcode, this, sReferenceQueue);
                    this.add(reference);
                }
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public void removeInstance(InstanceReference reference) {
            Object object = this.getInstanceLock();
            synchronized (object) {
                this.remove(reference);
            }
        }

        private void add(InstanceReference value) {
            int index = (value.hashCode() & Integer.MAX_VALUE) % this.fTable.length;
            value.fNext = this.fTable[index];
            this.fTable[index] = value;
            ++this.fCount;
            if ((float)this.fCount > (float)this.fTable.length * 0.75f) {
                this.rehash();
            }
        }

        private void remove(InstanceReference value) {
            int index = (value.hashCode() & Integer.MAX_VALUE) % this.fTable.length;
            InstanceReference previous = null;
            InstanceReference reference = this.fTable[index];
            while (reference != null) {
                if (reference == value) {
                    if (previous == null) {
                        this.fTable[index] = reference.fNext;
                    } else {
                        previous.fNext = reference.fNext;
                    }
                    --this.fCount;
                    return;
                }
                previous = reference;
                reference = reference.fNext;
            }
            Assertion.wilyFail("should never try and remove an instance reference not in the set");
        }

        private boolean contains(Object instance, int hashcode) {
            InstanceReference reference = this.fTable[(hashcode & Integer.MAX_VALUE) % this.fTable.length];
            while (reference != null) {
                if (reference.get() == instance) {
                    return true;
                }
                reference = reference.fNext;
            }
            return false;
        }

        private void rehash() {
            InstanceReference[] newTable = new InstanceReference[this.fTable.length * 2 + 1];
            int i = 0;
            while (i < this.fTable.length) {
                InstanceReference reference = this.fTable[i];
                InstanceReference nextReference = null;
                while (reference != null) {
                    InstanceReference newNext;
                    nextReference = reference.fNext;
                    int newIndex = (reference.hashCode() & Integer.MAX_VALUE) % newTable.length;
                    reference.fNext = newNext = newTable[newIndex];
                    newTable[newIndex] = reference;
                    reference = nextReference;
                }
                ++i;
            }
            this.fTable = newTable;
        }
    }
}

