/*
 * Decompiled with CFR 0.152.
 */
package com.wily.introscope.agent.trace.hc2;

import com.wily.introscope.agent.IAgent;
import com.wily.introscope.agent.trace.ICachedNameFormatter;
import com.wily.introscope.agent.trace.InvocationData;
import com.wily.introscope.agent.trace.ProbeIdentification;
import com.wily.util.StringUtils;

public class DomainNameFormatter
implements ICachedNameFormatter {
    private static final String DOMAIN_PLACE_HOLDER = "{domain}";
    private static final char PACKAGE_SEPARATOR = '.';
    private static final String NUMBER_SEGMENTS_PROPERTY_KEY = "introscope.agent.domainNameFormatter.segments";
    private static final int DEFAULT_NUMBER_SEGMENTS = 3;
    private final int numSegments;

    public DomainNameFormatter(IAgent agent) {
        String segments = agent.IAgent_getIndexedProperties().getProperty(NUMBER_SEGMENTS_PROPERTY_KEY);
        this.numSegments = segments != null ? Integer.valueOf(segments) : 3;
    }

    public DomainNameFormatter() {
        this(3);
    }

    public DomainNameFormatter(int numSegments) {
        this.numSegments = numSegments;
    }

    @Override
    public String INameFormatter_format(String name, InvocationData data) {
        return this.ICachedNameFormatter_format(name, data.getProbeInformation().getProbeIdentification(), data.getInvocationObject());
    }

    @Override
    public String ICachedNameFormatter_format(String name, ProbeIdentification probe, Object sampleTracedObject) {
        String pkgName;
        if (name != null && name.indexOf(DOMAIN_PLACE_HOLDER, 0) >= 0 && (pkgName = probe.getRuntimePackageName()) != null) {
            name = StringUtils.replace(name, DOMAIN_PLACE_HOLDER, this.getDomainName(pkgName));
        }
        return name;
    }

    private String getDomainName(String pkgName) {
        int len = pkgName.length();
        int lastIndex = 0;
        int index = len;
        int segCount = 0;
        int fromIndex = 0;
        do {
            lastIndex = index;
            index = pkgName.indexOf(46, fromIndex);
            fromIndex = index + 1;
        } while (index != -1 && ++segCount <= this.numSegments);
        if (segCount < this.numSegments) {
            lastIndex = len;
        }
        return pkgName.substring(0, lastIndex);
    }
}

