/*
 * Decompiled with CFR 0.152.
 */
package com.wily.introscope.agent.trace.hc2;

import com.wily.introscope.agent.trace.cas.IGathererElement;
import com.wily.introscope.agent.trace.cas.ISharedElement;
import com.wily.introscope.agent.trace.hc2.MetricGathererWrapper;

public class SaturationGathererWrapper
extends MetricGathererWrapper {
    private static final SaturationGathererWrapper kConsumedInstancer = new SaturationGathererWrapper(true);
    private static final SaturationGathererWrapper kNonConsumedInstancer = new SaturationGathererWrapper(false);
    private static final HCSaturatingCounter kNullEngine = new HCSaturatingCounter();
    private final HCSaturatingCounter engine;

    public static SaturationGathererWrapper getFactory(boolean shouldBeConsumed) {
        return shouldBeConsumed ? kConsumedInstancer : kNonConsumedInstancer;
    }

    private SaturationGathererWrapper(boolean shouldBeConsumedOnRead) {
        this(shouldBeConsumedOnRead, true);
    }

    private SaturationGathererWrapper(boolean shouldBeConsumedOnRead, boolean isOnlyInstancer) {
        super(shouldBeConsumedOnRead);
        this.engine = isOnlyInstancer ? kNullEngine : new HCSaturatingCounter();
    }

    @Override
    public void setValue(long value) {
        this.getEngine().setValueUnsync(value);
    }

    @Override
    public long getValue() {
        return this.getEngine().getValue();
    }

    private HCSaturatingCounter getEngine() {
        return this.engine;
    }

    @Override
    public IGathererElement getInstance() {
        return null;
    }

    @Override
    public final ISharedElement getSharedElementInstance() {
        return new SaturationGathererWrapper(this.shouldBeConsumendOnRead(), false);
    }

    @Override
    public long getCount() {
        return this.getEngine().fCount;
    }

    @Override
    public long getMaximum() {
        return this.getEngine().fMaximum;
    }

    @Override
    public long getMinimum() {
        return this.getEngine().fMinimum;
    }

    @Override
    protected void specificCombine(ISharedElement offered) {
        this.getEngine().add(offered.getValue(), offered.getCount(), offered.getMinimum(), offered.getMaximum());
    }

    @Override
    protected void forceSpecificCombine(ISharedElement offered) {
        this.getEngine().forceAdd(offered.getValue(), offered.getCount(), offered.getMinimum(), offered.getMaximum());
    }

    @Override
    public void reset() {
        this.getEngine().reset();
    }

    @Override
    public void combineValue(long i) {
        this.getEngine().addInstance(i);
    }

    @Override
    protected void decrease() {
        this.getEngine().addInstance(this.getEngine().getValue() - 1L);
    }

    @Override
    protected void increase() {
        this.getEngine().addInstance(this.getEngine().getValue() - 1L);
    }

    public String toString() {
        return String.valueOf(super.toString()) + ";" + this.getEngine().toString();
    }

    @Override
    public void resetMinMax() {
        this.getEngine().fMinimum = 0L;
        this.getEngine().fMaximum = 0L;
        this.getEngine().fCount = 0L;
    }

    private static class HCSaturatingCounter {
        long fValue;
        long fCount;
        long fMinimum;
        long fMaximum;

        public void add(long delta, long count, long otherMinimum, long otherMaximum) {
            if (count == 0L) {
                return;
            }
            this.forceAdd(delta, count, otherMinimum, otherMaximum);
        }

        public void forceAdd(long delta, long count, long otherMinimum, long otherMaximum) {
            if (this.fCount == 0L) {
                this.fValue = delta;
            } else if (delta > this.fValue) {
                this.fValue = delta;
            }
            if (this.fCount == 0L || otherMinimum < this.fMinimum) {
                this.fMinimum = otherMinimum;
            }
            if (this.fValue < this.fMinimum) {
                this.fMinimum = this.fValue;
            }
            if (this.fCount == 0L || otherMaximum > this.fMaximum) {
                this.fMaximum = otherMaximum;
            }
            if (this.fValue > this.fMaximum) {
                this.fMaximum = this.fValue;
            }
            this.incrementDataPointCountNonSync(count);
        }

        public void reset() {
            this.fValue = 0L;
            this.fCount = 0L;
            this.fMinimum = 0L;
            this.fMaximum = 0L;
        }

        public HCSaturatingCounter getBookmark() {
            HCSaturatingCounter result = new HCSaturatingCounter();
            result.fCount = this.fCount;
            result.fValue = this.fValue;
            result.fMinimum = this.fMinimum;
            result.fMaximum = this.fMaximum;
            return result;
        }

        public long getValue() {
            return this.fValue;
        }

        public long getMinimum() {
            return this.fMinimum;
        }

        public long getMaximum() {
            return this.fMaximum;
        }

        protected void directSetIntMinimum(long minimum) {
            this.fMinimum = minimum;
        }

        protected void directSetIntMaximum(long maximum) {
            this.fMaximum = maximum;
        }

        public void addInstance(long delta) {
            this.setValueUnsync(delta);
        }

        void setValueUnsync(long value) {
            this.fValue = this.fCount == 0L ? value : Math.max(this.fValue, value);
            this.syncSinglePointBounds(value);
            this.incrementDataPointCountNonSync();
        }

        protected void syncSinglePointBounds(long value) {
            if (this.fCount > 0L) {
                if (value > this.fMaximum) {
                    this.fMaximum = value;
                }
                if (value < this.fMinimum) {
                    this.fMinimum = value;
                }
            } else {
                this.fMinimum = value;
                this.fMaximum = value;
            }
        }

        protected final void incrementDataPointCountNonSync() {
            ++this.fCount;
        }

        protected final void incrementDataPointCountNonSync(long deltaCount) {
            this.fCount += deltaCount;
        }

        public String toString() {
            return String.valueOf(this.fValue) + ";" + this.fCount + ";" + this.fMaximum + ";" + this.fMinimum;
        }
    }
}

