/*
 * Decompiled with CFR 0.152.
 */
package com.wily.introscope.agent.trace.hc2;

import com.wily.introscope.agent.trace.cas.AbstractTransactionElement;
import com.wily.introscope.agent.trace.cas.IChildEditor;
import com.wily.introscope.agent.trace.cas.IChildRead;
import com.wily.introscope.agent.trace.cas.IEditableTransactionElement;
import com.wily.introscope.agent.trace.cas.ITransactionElement;
import com.wily.introscope.agent.trace.cas.SetElement;
import com.wily.introscope.agent.trace.cas.impl.AChildReadEditorStack;
import com.wily.introscope.agent.trace.hc2.WilyTransactionStructure;
import com.wily.util.feedback.IModuleFeedbackChannel;

class VerifyAgingChildrenEditor
implements IChildEditor {
    private final boolean isTraceEnabled;
    private final long nowInMillis;
    private final IModuleFeedbackChannel feedback;
    private final long cutoffDate;
    private final int agingAttemptCount;

    VerifyAgingChildrenEditor(IModuleFeedbackChannel feedback, long nowInMillis, long cutoff, int agingAttempt) {
        this.nowInMillis = nowInMillis;
        this.cutoffDate = cutoff;
        this.agingAttemptCount = agingAttempt;
        this.feedback = feedback;
        this.isTraceEnabled = feedback.isTraceEnabled(WilyTransactionStructure.kWilyHarvestingModule);
    }

    @Override
    public boolean removeElement(ITransactionElement e, Object key) {
        ITransactionElement element = e;
        if (element instanceof SetElement) {
            element = ((SetElement)element).getElement();
        }
        if (element instanceof AbstractTransactionElement) {
            AbstractTransactionElement operativeElement = (AbstractTransactionElement)element;
            if (this.nowInMillis - e.lastTouched() >= this.cutoffDate) {
                int agingCount = operativeElement.increaseAgingCount();
                if (this.isTraceEnabled) {
                    this.feedback.trace(WilyTransactionStructure.kWilyHarvestingModule, String.valueOf(e.toString()) + " is aging out candidate. The aging count is " + agingCount);
                }
                if (agingCount > this.agingAttemptCount) {
                    if (this.isTraceEnabled) {
                        this.feedback.trace(WilyTransactionStructure.kWilyHarvestingModule, String.valueOf(e.toString()) + " is aging out.");
                    }
                    return true;
                }
            } else {
                operativeElement.resetAgingCount();
            }
        }
        return false;
    }

    @Override
    public void onPostRemove(ITransactionElement removed) {
        AChildReadEditorStack stack = new AChildReadEditorStack();
        stack.push(removed);
        IChildRead read = stack.getEditor();
        while (!stack.isEmpty()) {
            ITransactionElement e = (ITransactionElement)stack.pop();
            if (e == null) continue;
            e.notifyRemoved();
            if (!(e instanceof IEditableTransactionElement)) continue;
            IEditableTransactionElement ee = (IEditableTransactionElement)((Object)e);
            ee.offerChildrenForRead(read);
            ee.clearAllChildren();
        }
    }
}

