/*
 * Decompiled with CFR 0.152.
 */
package com.wily.introscope.agent.trace.nio;

import com.wily.introscope.agent.IAgent;
import com.wily.introscope.agent.stat.IIntegerRateDataAccumulator;
import com.wily.introscope.agent.trace.ABundledTracerFactory;
import com.wily.introscope.agent.trace.ITracer;
import com.wily.introscope.agent.trace.InvocationData;
import com.wily.introscope.agent.trace.ProbeIdentification;
import com.wily.introscope.agent.trace.ReentrancyLevel;
import com.wily.introscope.agent.trace.nio.DatagramChannelMap;
import com.wily.util.properties.AttributeListing;
import com.wily.wilyassert.Assertion;
import java.net.InetSocketAddress;
import java.nio.ByteBuffer;
import java.nio.channels.DatagramChannel;

public final class DatagramReceiveMethodResultRateTracer
extends ABundledTracerFactory
implements ITracer {
    private static final String POSITION_BEFORE = "position-before";
    private final ReentrancyLevel fReentrancyLevel = this.calculateReentrancyLevel(ReentrancyLevel.kNone);

    public DatagramReceiveMethodResultRateTracer(IAgent agent, AttributeListing parameters, ProbeIdentification probe, Object sampleTracedObject) {
        super(agent, parameters, probe, sampleTracedObject);
    }

    protected final IIntegerRateDataAccumulator createDataAccumulator(String formattedMetricName) {
        return this.getDataAccumulatorFactory().safeGetIntegerRateDataAccumulator(formattedMetricName);
    }

    @Override
    public final ReentrancyLevel ITracerFactory_getReentrancyLevel() {
        return this.fReentrancyLevel;
    }

    @Override
    public final boolean ITracerFactory_isShutoff() {
        return false;
    }

    @Override
    public final ITracer ITracerFactory_allocateTracer(int tracerIndex, InvocationData data) {
        Object invocationObject = data.getInvocationObject();
        if (invocationObject instanceof DatagramChannel && data.hasInvocationParametersAvailable() && data.getInvocationParameterAsObject(0) instanceof ByteBuffer) {
            return this;
        }
        Assertion.wilyAssert("Instrumentation error: instrumented object is not a DatagramChannel or does not have parameter of type ByteBuffer");
        return null;
    }

    @Override
    public final void ITracer_startTrace(int tracerIndex, InvocationData data) {
        ByteBuffer buffer = (ByteBuffer)data.getInvocationParameterAsObject(0);
        data.put(POSITION_BEFORE, buffer.position());
    }

    protected final IIntegerRateDataAccumulator createDataAccumulator(InvocationData data) {
        Object result;
        DatagramChannel channel = (DatagramChannel)data.getInvocationObject();
        if (data.hasMethodResultAvailable() && (result = data.getInvocationReturnValueAsObject()) != null) {
            if (result instanceof InetSocketAddress) {
                String formattedName;
                InetSocketAddress remoteAddress = (InetSocketAddress)result;
                if (DatagramChannelMap.isRequired(channel, remoteAddress, this.getAgent()) && (formattedName = this.formatParameterizedName(data)) != null) {
                    return this.createDataAccumulator(formattedName);
                }
            } else {
                Assertion.wilyAssert("Instrumentation error: instrumented method return value is not an InetSocketAddress");
            }
        }
        return null;
    }

    @Override
    public final void ITracer_finishTrace(int tracerIndex, InvocationData data) {
        if (data.isSocketClamped()) {
            return;
        }
        IIntegerRateDataAccumulator rate = this.createDataAccumulator(data);
        if (rate != null && !rate.IDataAccumulator_isShutOff()) {
            ByteBuffer buffer = (ByteBuffer)data.getInvocationParameterAsObject(0);
            Integer positionBefore = (Integer)data.get(POSITION_BEFORE);
            if (positionBefore != null) {
                int bytesRead = buffer.position() - positionBefore;
                rate.IIntegerRateDataAccumulator_addBatchIncidents(bytesRead);
            } else {
                Assertion.wilyAssert("Instrumentation error: property position-before missing");
            }
        }
    }

    @Override
    public final void ITracerFactory_releaseTracer(int tracerIndex, ITracer tracer) {
    }
}

