/*
 * Decompiled with CFR 0.152.
 */
package com.wily.introscope.agent.trace.parameter;

import com.wily.introscope.agent.trace.parameter.Parameter;
import com.wily.util.StringUtils;

public abstract class CoreParameters {
    private CoreParameters() {
    }

    public static String replacePipesColonsWithUnderscoreAndRemoveTrailingSpaces(String s) {
        return StringUtils.removeTrailingSpaces(s.replace(':', '_').replace('|', '_'));
    }

    public static final class BooleanParameter
    extends Parameter {
        private boolean fValue;

        public void setValue(boolean value) {
            this.fValue = value;
        }

        public boolean isExpectedType(boolean value) {
            return true;
        }

        public String getExpectedType() {
            return "boolean";
        }

        public Object toObject() {
            return this.fValue ? Boolean.TRUE : Boolean.FALSE;
        }

        public String toString() {
            return String.valueOf(this.fValue);
        }

        public void reset() {
            this.fValue = false;
        }
    }

    public static final class CharParameter
    extends Parameter {
        private char fValue;

        public void setValue(char value) {
            this.fValue = value;
        }

        public boolean isExpectedType(char value) {
            return true;
        }

        public String getExpectedType() {
            return "char";
        }

        public Object toObject() {
            return new Character(this.fValue);
        }

        public String toString() {
            return CoreParameters.replacePipesColonsWithUnderscoreAndRemoveTrailingSpaces(String.valueOf(this.fValue));
        }

        public void reset() {
            this.fValue = '\u0000';
        }
    }

    public static final class DoubleParameter
    extends Parameter {
        private double fValue;

        public void setValue(double value) {
            this.fValue = value;
        }

        public boolean isExpectedType(double value) {
            return true;
        }

        public String getExpectedType() {
            return "double";
        }

        public Object toObject() {
            return new Double(this.fValue);
        }

        public String toString() {
            return String.valueOf(this.fValue);
        }

        public void reset() {
            this.fValue = 0.0;
        }
    }

    public static final class FloatParameter
    extends Parameter {
        private float fValue;

        public void setValue(float value) {
            this.fValue = value;
        }

        public boolean isExpectedType(float value) {
            return true;
        }

        public String getExpectedType() {
            return "float";
        }

        public Object toObject() {
            return new Float(this.fValue);
        }

        public String toString() {
            return String.valueOf(this.fValue);
        }

        public void reset() {
            this.fValue = 0.0f;
        }
    }

    public static final class ObjectParameter
    extends Parameter {
        private Object fValue;

        public void setValue(Object value) {
            this.fValue = value;
        }

        public boolean isExpectedType(Object value) {
            return true;
        }

        public String getExpectedType() {
            return "object";
        }

        public Object toObject() {
            return this.fValue;
        }

        public String toString() {
            try {
                return CoreParameters.replacePipesColonsWithUnderscoreAndRemoveTrailingSpaces(this.fValue.toString());
            }
            catch (ThreadDeath td) {
                throw td;
            }
            catch (Throwable throwable) {
                return "unable to get toString value";
            }
        }

        public void reset() {
            this.fValue = null;
        }
    }

    public static final class SInt16Parameter
    extends Parameter {
        private short fValue;

        public void setValue(short value) {
            this.fValue = value;
        }

        public boolean isExpectedType(short value) {
            return true;
        }

        public String getExpectedType() {
            return "SInt16";
        }

        public Object toObject() {
            return new Short(this.fValue);
        }

        public String toString() {
            return String.valueOf(this.fValue);
        }

        public void reset() {
            this.fValue = 0;
        }
    }

    public static final class SInt32Parameter
    extends Parameter {
        private int fValue;

        public void setValue(int value) {
            this.fValue = value;
        }

        public boolean isExpectedType(int value) {
            return true;
        }

        public String getExpectedType() {
            return "SInt32";
        }

        public Object toObject() {
            return new Integer(this.fValue);
        }

        public String toString() {
            return String.valueOf(this.fValue);
        }

        public void reset() {
            this.fValue = 0;
        }
    }

    public static final class SInt64Parameter
    extends Parameter {
        private long fValue;

        public void setValue(long value) {
            this.fValue = value;
        }

        public boolean isExpectedType(long value) {
            return true;
        }

        public String getExpectedType() {
            return "SInt64";
        }

        public Object toObject() {
            return new Long(this.fValue);
        }

        public String toString() {
            return String.valueOf(this.fValue);
        }

        public void reset() {
            this.fValue = 0L;
        }
    }

    public static final class SInt8Parameter
    extends Parameter {
        private byte fValue;

        public void setValue(byte value) {
            this.fValue = value;
        }

        public boolean isExpectedType(byte value) {
            return true;
        }

        public String getExpectedType() {
            return "SInt8";
        }

        public Object toObject() {
            return new Byte(this.fValue);
        }

        public String toString() {
            return CoreParameters.replacePipesColonsWithUnderscoreAndRemoveTrailingSpaces(String.valueOf(this.fValue));
        }

        public void reset() {
            this.fValue = 0;
        }
    }
}

