/*
 * Decompiled with CFR 0.152.
 */
package com.wily.introscope.agent.trace.servlet;

import com.wily.introscope.agent.trace.InvocationData;
import com.wily.introscope.agent.trace.servlet.RequestWrapper;
import com.wily.introscope.agent.trace.servlet.ServletInvocationDataHelper;
import com.wily.introscope.agent.trace.servlet.ServletWrapper;
import com.wily.util.feedback.IModuleFeedbackChannel;
import com.wily.util.feedback.Module;

public class ServletApplicationNameLoader
extends ServletInvocationDataHelper.ServletParameterErrorCounterDelegate {
    IModuleFeedbackChannel fFeedback;
    Module fModule;
    StringBuffer fBuffer;

    public ServletApplicationNameLoader(IModuleFeedbackChannel feedback, Module module, StringBuffer buffer) {
        this.fFeedback = feedback;
        this.fModule = module;
        this.fBuffer = buffer;
    }

    protected boolean doWithWrappers(InvocationData data, RequestWrapper rw, ServletWrapper sw) throws Throwable {
        String appName = ServletApplicationNameLoader.getAppNameFromServletContext(this.fFeedback, sw, rw);
        this.fBuffer.append(appName);
        this.resetErrorCount();
        return true;
    }

    protected void onError(Throwable t) {
        this.fFeedback.debug(this.fModule, "An error occurred while formatting servlet metrics: " + t);
        this.fFeedback.verbose(t);
    }

    protected void onMaxErrorLimitReached() {
    }

    public static String getAppNameFromServletContext(IModuleFeedbackChannel feedback, ServletWrapper servlet, RequestWrapper request) {
        try {
            String result = request.getApplicationNameFromServlet(servlet);
            if (result != null && result.equals("")) {
                result = "rootContext";
            }
            return result;
        }
        catch (ThreadDeath td) {
            throw td;
        }
        catch (Throwable t) {
            try {
                feedback.verbose(t);
                feedback.error("An error occurred getting the application name: " + t);
            }
            catch (ThreadDeath td2) {
                throw td2;
            }
            catch (Throwable throwable) {}
            return "UnknownApp";
        }
    }
}

