/*
 * Decompiled with CFR 0.152.
 */
package com.wily.introscope.agent.upgrade.merge.pbl;

import com.wily.introscope.agent.upgrade.merge.IMergeable;
import com.wily.introscope.agent.upgrade.merge.IRulesEngine;
import com.wily.introscope.agent.upgrade.merge.Line;
import com.wily.introscope.agent.upgrade.merge.pbl.Description;
import com.wily.introscope.agent.upgrade.merge.pbl.PBLKey;
import com.wily.introscope.agent.upgrade.merge.util.KMergeConstants;
import com.wily.introscope.agent.upgrade.merge.util.UpgradeUtil;
import java.io.BufferedReader;
import java.io.IOException;
import java.io.Writer;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.StringTokenizer;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class PBL
implements IMergeable<PBL> {
    private List<Line> fHeader = new ArrayList<Line>();
    private List<Description> fDescriptionList = new ArrayList<Description>();
    private List<PBLKey> fKeyList = new ArrayList<PBLKey>();

    public List<Line> getHeader() {
        return Collections.unmodifiableList(this.fHeader);
    }

    public void setHeader(List<Line> header) {
        this.fHeader.clear();
        for (Line line : header) {
            this.fHeader.add(line);
        }
    }

    public List<Description> getDescription() {
        return Collections.unmodifiableList(this.fDescriptionList);
    }

    public void setDescription(List<Description> description) {
        this.fDescriptionList.clear();
        for (Description dt : description) {
            this.fDescriptionList.add(dt);
        }
    }

    private int getKeyIndex(PBLKey key) {
        int i = 0;
        while (i < this.fKeyList.size()) {
            if (this.fKeyList.get(i).equals(key)) {
                return i;
            }
            ++i;
        }
        return -1;
    }

    public static PBL read(BufferedReader reader) throws IOException {
        PBL pbl = new PBL();
        int header = 0;
        ArrayList<Line> comments = new ArrayList<Line>();
        String line = null;
        int count = 0;
        while ((line = reader.readLine()) != null) {
            ++count;
            if (UpgradeUtil.isBlank(line)) {
                comments.add(new Line("", count));
                continue;
            }
            if (UpgradeUtil.isCompleteHashedLine(line)) {
                comments.add(new Line(line, count));
                if (header == 1) {
                    pbl.setHeader(comments);
                    comments.clear();
                }
                ++header;
                continue;
            }
            if (line.trim().startsWith("#")) {
                boolean success = PBL.isCommentedKey(pbl, line, comments);
                if (success) {
                    comments.clear();
                    continue;
                }
                comments.add(new Line(line, count));
                continue;
            }
            if (line.toString().contains("Description:")) {
                Description dt = new Description(Description.DescriptionType.DESCRIPTION, line.toString());
                if (comments.size() != 0) {
                    dt.setComment(comments);
                }
                pbl.fDescriptionList.add(dt);
                comments.clear();
                continue;
            }
            if (line.toString().contains("Title:")) {
                Description dt = new Description(Description.DescriptionType.TITLE, line.toString());
                if (comments.size() != 0) {
                    dt.setComment(comments);
                }
                pbl.fDescriptionList.add(dt);
                comments.clear();
                continue;
            }
            PBL.handleKey(pbl, line, comments, false);
            comments.clear();
        }
        return pbl;
    }

    @Override
    public void write(Writer writer) throws IOException {
        writer.write(this.getPbl());
        writer.flush();
    }

    private String getPbl() {
        StringBuilder strBldr = new StringBuilder();
        String newLine = System.getProperty("line.separator");
        for (Line line : this.fHeader) {
            strBldr.append(line).append(newLine);
        }
        for (Description dt : this.fDescriptionList) {
            List<Line> lines = dt.getComments();
            for (Line line : lines) {
                strBldr.append(line.getContent()).append(newLine);
            }
            strBldr.append(dt.getContent()).append(newLine);
        }
        for (PBLKey key : this.fKeyList) {
            List<Line> commentList = key.getComments();
            for (Line l : commentList) {
                strBldr.append(l.getContent());
                strBldr.append(KMergeConstants.kNewline);
            }
            if (key.isCommented()) {
                strBldr.append("#");
            }
            strBldr.append(key.getKey()).append(newLine);
        }
        return strBldr.toString();
    }

    private void addKey(PBLKey key) {
        this.fKeyList.add(key);
    }

    private static boolean handleKey(PBL pbl, String line, List<Line> comments, boolean b) {
        boolean success = false;
        line = line.trim();
        String modLine = "";
        int i = 0;
        while (i < line.length()) {
            if (line.charAt(i) != '#') {
                modLine = line.substring(i);
                break;
            }
            ++i;
        }
        PBLKey key = new PBLKey(modLine, b, comments);
        pbl.addKey(key);
        success = true;
        return success;
    }

    private static boolean isCommentedKey(PBL pbl, String line, List<Line> comments) {
        boolean success = false;
        StringTokenizer token = new StringTokenizer(line);
        if (token.countTokens() == 1 && line.toString().contains("pbd") && line.toString().startsWith("#")) {
            success = PBL.handleKey(pbl, line, comments, true);
        }
        return success;
    }

    public String toString() {
        StringBuilder strBldr = new StringBuilder("Class: Pbl\n");
        strBldr.append(this.getPbl());
        return strBldr.toString();
    }

    @Override
    public PBL merge(PBL otherPbl) {
        PBL mergedPbl = new PBL();
        mergedPbl.setHeader(otherPbl.fHeader);
        mergedPbl.setDescription(otherPbl.fDescriptionList);
        for (PBLKey key : this.fKeyList) {
            mergedPbl.addKey(key);
        }
        for (PBLKey key : otherPbl.fKeyList) {
            if (this.fKeyList.contains(key)) continue;
            mergedPbl.addKey(key);
        }
        return mergedPbl;
    }

    @Override
    public PBL merge(PBL otherPbl, IRulesEngine engine) {
        PBL mergedPbl = new PBL();
        mergedPbl.setHeader(otherPbl.fHeader);
        mergedPbl.setDescription(otherPbl.fDescriptionList);
        for (PBLKey key : this.fKeyList) {
            if (engine.isEntryDelete(IRulesEngine.MergeableType.PBL, key)) continue;
            if (otherPbl.fKeyList.contains(key)) {
                IRulesEngine.PreferenceType type = engine.getPreferredType(IRulesEngine.MergeableType.PBL, key);
                if (type == IRulesEngine.PreferenceType.CURRENT) {
                    mergedPbl.addKey(key);
                    continue;
                }
                if (type != IRulesEngine.PreferenceType.UPGRADE) continue;
                mergedPbl.addKey(otherPbl.fKeyList.get(this.getKeyIndex(key)));
                continue;
            }
            mergedPbl.addKey(key);
        }
        for (PBLKey otherKey : otherPbl.fKeyList) {
            if (this.fKeyList.contains(otherKey)) continue;
            mergedPbl.addKey(otherKey);
        }
        return mergedPbl;
    }
}

