/*
 * Decompiled with CFR 0.152.
 */
package com.wily.introscope.agent.upgrade.merge.rules;

import com.wily.introscope.agent.upgrade.merge.IMetadataEntry;
import com.wily.introscope.agent.upgrade.merge.IRulesEngine;
import com.wily.introscope.agent.upgrade.merge.MergeException;
import com.wily.introscope.agent.upgrade.merge.rules.PreferredEntryRule;
import com.wily.introscope.agent.upgrade.merge.rules.Rules;
import com.wily.introscope.agent.upgrade.merge.rules.RulesParser;

public class RulesEngine
implements IRulesEngine {
    private Rules fRules;

    public RulesEngine(String rulesFile) throws MergeException {
        RulesParser parser = new RulesParser(rulesFile);
        this.fRules = parser.getRules();
    }

    public boolean isDelete(IRulesEngine.MergeableType type, String fileName) {
        return this.fRules.hasDeleteFileRule(type, fileName);
    }

    public boolean isOverwrite(IRulesEngine.MergeableType type, String fileName) {
        return this.fRules.hasOverwriteFileRule(type, fileName);
    }

    public boolean isMerge(IRulesEngine.MergeableType type, String fileName) {
        return !this.fRules.hasNoMergeFileRule(type, fileName);
    }

    public boolean isEntryDelete(IRulesEngine.MergeableType type, IMetadataEntry entry) {
        return this.fRules.hasDeleteEntryRule(type, entry.getKey());
    }

    public IRulesEngine.PreferenceType getPreferredType(IRulesEngine.MergeableType type, IMetadataEntry entry) {
        IRulesEngine.PreferenceType preferred = IRulesEngine.PreferenceType.CURRENT;
        PreferredEntryRule rule = this.fRules.getPreferredEntryRule(type, entry.getKey());
        if (rule != null && (preferred = rule.getPreference()) == IRulesEngine.PreferenceType.INVALID) {
            preferred = IRulesEngine.PreferenceType.CURRENT;
        }
        return preferred;
    }
}

