/*
 * Decompiled with CFR 0.152.
 */
package com.wily.introscope.spec.agent.beans.dynamicinstrumentation;

import com.wily.isengard.messageprimitives.callback.Callback;
import com.wily.util.HashCodeUtils;
import java.io.Externalizable;
import java.io.IOException;
import java.io.ObjectInput;
import java.io.ObjectOutput;
import java.util.ArrayList;
import java.util.Collection;
import java.util.SortedSet;

public class DynamicInstrumentationResult
implements Cloneable,
Externalizable {
    private static final long serialVersionUID = 9L;
    public static final int kUndefinedStatus = -1;
    public static final int kNormalStatus = 0;
    public static final int kNullStatus = 1;
    public static final int kNormalNoopStatus = 2;
    public static final int kGenericErrorStatus = 100;
    public static final int kConnectionExceptionErrorStatus = 101;
    public static final int kDatabaseNotAvailableErrorStatus = 102;
    public static final int kDatabaseSQLExceptionStatus = 103;
    public static final int kUnableToRedefineClassStatus = 104;
    public static final int kOperationNotAvailable = 105;
    public static final int kServiceNotAvailable = 106;
    public static final int kClassNotFound = 107;
    public static final int kInvalidName = 108;
    public static final int kAgentNotConnected = 109;
    public static final int kDynamicInstrNotActive = 110;
    public static final int kServiceAvailable = 111;
    public static final int kServiceDisabled = 112;
    public static final int kInvalideDynamicInstrumentation = 113;
    public static final int kInvalidArgument = 114;
    public static final int kAgentBusy = 115;
    public static final int kNotAuthorized = 116;
    public static final int kUnsupportedClassRedefinition = 117;
    public static final DynamicInstrumentationResult kNullObject = new DynamicInstrumentationResult(1);
    public static final DynamicInstrumentationResult kNotImplemented = new DynamicInstrumentationResult(105);
    public static final DynamicInstrumentationResult kNotAvailable = new DynamicInstrumentationResult(106);
    public static final DynamicInstrumentationResult kAvailable = new DynamicInstrumentationResult(111);
    public static final DynamicInstrumentationResult connectionNotAvailable = new DynamicInstrumentationResult(106);
    public static final DynamicInstrumentationResult serviceNotAvailable = new DynamicInstrumentationResult(106);
    public static final String kEmptyString = "";
    public static final String[] kEmptyStringArray = new String[0];
    public static final Collection kEmptyCollection = new ArrayList(0);
    private int status = -1;
    private String agentName;
    private Throwable exception;
    private SortedSet codeCollection;
    private Collection availableTracers;
    private String causeVerbose;
    private Boolean isActive;
    private Boolean isLastResult;
    private Callback fCallback;

    public DynamicInstrumentationResult() {
        this.setStatus(-1);
        this.isLastResult = Boolean.TRUE;
    }

    public DynamicInstrumentationResult(int status) {
        this.setStatus(status);
        this.isLastResult = Boolean.TRUE;
    }

    public DynamicInstrumentationResult(Integer status) {
        this.setStatus(status);
        this.isLastResult = Boolean.TRUE;
    }

    public DynamicInstrumentationResult(Throwable t) {
        this(100);
        this.setException(t);
    }

    protected DynamicInstrumentationResult(DynamicInstrumentationResult result) {
        this.importAll(result);
    }

    public static DynamicInstrumentationResult getInstanceFromResult(DynamicInstrumentationResult input) {
        return new DynamicInstrumentationResult(input);
    }

    public void importAll(DynamicInstrumentationResult result) {
        this.setStatus(result.getStatus());
        this.setAgentName(result.getAgentName());
        this.setException(result.getException());
        this.setVerboseCause(result.causeVerbose);
        this.setCodeCollection(result.codeCollection);
        this.setActive(result.isActive);
        this.setAvailableTracers(result.availableTracers);
        this.setCallback(result.fCallback);
        this.isLastResult = result.isLastResult;
    }

    private String getAgentName() {
        return this.agentName;
    }

    public int getStatus() {
        return this.status;
    }

    public DynamicInstrumentationResult setStatus(int status) {
        this.status = status;
        return this;
    }

    public DynamicInstrumentationResult setAgentName(String name) {
        this.agentName = name;
        return this;
    }

    public void readExternal(ObjectInput in) throws IOException, ClassNotFoundException {
        this.status = in.readInt();
        this.agentName = (String)in.readObject();
        this.exception = (Throwable)in.readObject();
        this.causeVerbose = (String)in.readObject();
        this.isActive = (Boolean)in.readObject();
        this.codeCollection = (SortedSet)in.readObject();
        this.availableTracers = (Collection)in.readObject();
        this.fCallback = (Callback)in.readObject();
        this.isLastResult = (Boolean)in.readObject();
    }

    public void writeExternal(ObjectOutput out) throws IOException {
        out.writeInt(this.status);
        out.writeObject(this.agentName);
        out.writeObject(this.exception);
        out.writeObject(this.causeVerbose);
        out.writeObject(this.isActive);
        out.writeObject(this.codeCollection);
        out.writeObject(this.availableTracers);
        out.writeObject(this.fCallback);
        out.writeObject(this.isLastResult);
    }

    public String getErrorStatus() {
        return "Agent Name: " + this.agentName + "; Status: " + this.status + ", is Error " + this.isError() + "; " + this.causeVerbose;
    }

    public DynamicInstrumentationResult setException(Throwable e) {
        this.exception = e;
        return this;
    }

    public Throwable getException() {
        return this.exception;
    }

    public boolean isError() {
        return this.status < 0 || this.status >= 100 || this.exception != null;
    }

    public Object clone() {
        return new DynamicInstrumentationResult(this);
    }

    public DynamicInstrumentationResult setVerboseCause(String string) {
        this.causeVerbose = string;
        return this;
    }

    public DynamicInstrumentationResult setActive(Boolean b) {
        this.isActive = b;
        return this;
    }

    public DynamicInstrumentationResult setCodeCollection(SortedSet set) {
        this.codeCollection = set;
        return this;
    }

    public SortedSet getCodeCollection() {
        return this.codeCollection;
    }

    public DynamicInstrumentationResult setAvailableTracers(Collection list) {
        this.availableTracers = list;
        return this;
    }

    public Collection getAvailableTracers() {
        return this.availableTracers;
    }

    public DynamicInstrumentationResult setCallback(Callback notification) {
        this.fCallback = notification;
        return this;
    }

    public Callback getCallback() {
        return this.fCallback;
    }

    public Boolean isLastResult() {
        return this.isLastResult;
    }

    public void setLastResult(Boolean value) {
        this.isLastResult = value;
    }

    public static class ClassMethodPair
    extends SimpleClassMethodPair {
        private boolean isInstrumentable = false;
        private boolean isInstrumented = false;
        private boolean isInterface = false;
        private boolean isAbstractMethod = false;

        public ClassMethodPair(String cName, String method) {
            super(cName, method);
        }

        public ClassMethodPair() {
            this(DynamicInstrumentationResult.kEmptyString, DynamicInstrumentationResult.kEmptyString);
        }

        public void readExternal(ObjectInput in) throws IOException, ClassNotFoundException {
            super.readExternal(in);
            this.isInstrumentable = in.readBoolean();
            this.isInstrumented = in.readBoolean();
            this.isInterface = in.readBoolean();
            this.isAbstractMethod = in.readBoolean();
        }

        public void writeExternal(ObjectOutput out) throws IOException {
            super.writeExternal(out);
            out.writeBoolean(this.isInstrumentable);
            out.writeBoolean(this.isInstrumented);
            out.writeBoolean(this.isInterface);
            out.writeBoolean(this.isAbstractMethod);
        }

        public boolean isInstrumentable() {
            return this.isInstrumentable;
        }

        public void setInstrumentable(boolean b) {
            this.isInstrumentable = b;
        }

        public boolean isInstrumented() {
            return this.isInstrumented;
        }

        public void setInstrumented(boolean b) {
            this.isInstrumented = b;
        }

        public boolean isInterface() {
            return this.isInterface;
        }

        public void setInterface(boolean b) {
            this.isInterface = b;
        }

        public boolean isAbstractMethod() {
            return this.isAbstractMethod;
        }

        public void setAbstractMethod(boolean b) {
            this.isAbstractMethod = b;
        }

        public boolean equals(Object o) {
            if (o == null && o instanceof ClassMethodPair) {
                return false;
            }
            return this.compareTo(o) == 0 && this.isInstrumentable == ((ClassMethodPair)o).isInstrumentable && this.isInterface == ((ClassMethodPair)o).isInterface && this.isInstrumented == ((ClassMethodPair)o).isInstrumented;
        }

        public int hashCode() {
            int result = super.hashCode();
            result = HashCodeUtils.accumulateHashCode(result, this.isInstrumentable);
            result = HashCodeUtils.accumulateHashCode(result, this.isInstrumented);
            result = HashCodeUtils.accumulateHashCode(result, this.isInterface);
            return result;
        }
    }

    public static class SimpleClassMethodPair
    implements Externalizable,
    Comparable {
        private String className;
        private String methodSignature;

        public SimpleClassMethodPair(String cName, String method) {
            this.setClassName(cName);
            this.setMethodSignature(method);
        }

        public SimpleClassMethodPair() {
            this(DynamicInstrumentationResult.kEmptyString, DynamicInstrumentationResult.kEmptyString);
        }

        public void readExternal(ObjectInput in) throws IOException, ClassNotFoundException {
            this.className = (String)in.readObject();
            this.methodSignature = (String)in.readObject();
        }

        public void writeExternal(ObjectOutput out) throws IOException {
            out.writeObject(this.className);
            out.writeObject(this.methodSignature);
        }

        public int compareTo(Object o) {
            int result = 0;
            if (o != null && o instanceof SimpleClassMethodPair) {
                SimpleClassMethodPair other = (SimpleClassMethodPair)o;
                try {
                    result = other.getClassName().compareTo(this.getClassName());
                    if (result == 0) {
                        result = other.getMethodSignature().compareTo(this.getMethodSignature());
                    }
                }
                catch (NullPointerException nullPointerException) {
                    result = 1;
                }
            }
            return result;
        }

        public void setMethodSignature(String methodSignature) {
            this.methodSignature = methodSignature;
        }

        public String getMethodSignature() {
            return this.methodSignature;
        }

        public void setClassName(String className) {
            this.className = className;
        }

        public String getClassName() {
            return this.className;
        }

        public boolean equals(Object o) {
            if (o == null && o instanceof ClassMethodPair) {
                return false;
            }
            return this.compareTo(o) == 0;
        }

        public int hashCode() {
            int result = 0;
            result = HashCodeUtils.accumulateHashCode(result, this.className);
            result = HashCodeUtils.accumulateHashCode(result, this.methodSignature);
            return result;
        }
    }
}

