/*
 * Decompiled with CFR 0.152.
 */
package com.wily.introscope.spec.metric;

import com.wily.introscope.spec.metric.AgentMetricPrefix;
import com.wily.introscope.spec.metric.BadlyFormedNameException;
import com.wily.introscope.spec.metric.ConflictingTypesException;
import com.wily.introscope.spec.metric.InternalException;
import com.wily.introscope.spec.metric.MetricNotFoundException;
import com.wily.introscope.spec.metric.TrackedMetaData;
import com.wily.introscope.spec.metric.TypeInquisitor;
import com.wily.isengard.data.IIsengardCachedData;
import com.wily.isengard.data.IIsengardReadResolve;
import com.wily.util.StringUtils;
import com.wily.util.adt.CanonicalObjectPool;
import com.wily.util.adt.CanonicalObjectPoolWithKey;
import com.wily.util.adt.IObjectAction;
import com.wily.util.adt.IObjectFilter;
import com.wily.util.adt.KeyValueWrapper;
import com.wily.util.text.FormattedLocalizableMessage;
import com.wily.util.text.ILocalizableMessage;
import com.wily.util.text.SimpleLocalizableMessage;
import com.wily.wilyassert.Assertion;
import com.wily.wilyassert.AssertionFailureException;
import java.io.Externalizable;
import java.io.IOException;
import java.io.InvalidObjectException;
import java.io.ObjectInput;
import java.io.ObjectOutput;
import java.io.ObjectStreamException;
import java.io.Serializable;

public final class AgentMetric
extends TrackedMetaData
implements CharSequence,
Externalizable,
IIsengardReadResolve,
IIsengardCachedData {
    private static final long serialVersionUID = 8167903946367818228L;
    private static final int kMetricNameLengthLimit = 21845;
    private AgentMetricPrefix fESEPath;
    private String fAttributeName;
    private int fAttributeType;
    private int fPathLen;
    public static final AgentMetric[] kZeroLengthAgentMetricArray = new AgentMetric[0];
    public static final AgentMetric kNullAgentMetric = new AgentMetric();
    private static IAgentMetricPool sPool = new CanonicalAgentMetricPool();

    public static void setAgentMetricPool(IAgentMetricPool pool) {
        sPool = pool;
    }

    public static IAgentMetricPool getAgentMetricPool() {
        return sPool;
    }

    public AgentMetric() {
        super(-1);
    }

    public AgentMetric(String fullPath, int typeCookie) throws BadlyFormedNameException {
        this(fullPath, typeCookie, -1);
    }

    public AgentMetric(String fullPath, int typeCookie, int persistentId) throws BadlyFormedNameException {
        super(persistentId);
        String metric;
        String path;
        int attributeIndex = fullPath.lastIndexOf(58);
        if (attributeIndex == -1) {
            path = "";
            metric = fullPath;
        } else {
            path = fullPath.substring(0, attributeIndex);
            metric = fullPath.substring(attributeIndex + 1, fullPath.length());
        }
        this.fESEPath = AgentMetricPrefix.getAgentMetricPrefix(path);
        this.fPathLen = this.fESEPath.length();
        this.fAttributeName = CanonicalObjectPool.getCanonicalString(metric);
        AgentMetric.verifyValidName(this.fAttributeName);
        this.fAttributeType = TypeInquisitor.getNonTransientTypeCookie(typeCookie);
    }

    private String buildAttributeURL() {
        if (this.fESEPath.isEmpty()) {
            return this.fAttributeName;
        }
        String pathString = this.fESEPath.toString();
        StringBuffer sb = new StringBuffer(1 + pathString.length() + this.fAttributeName.length());
        sb.append(pathString);
        sb.append(':');
        sb.append(this.fAttributeName);
        return sb.toString();
    }

    public AgentMetricPrefix getAgentMetricPrefix() {
        return this.fESEPath;
    }

    public String getAttributeName() {
        return this.fAttributeName;
    }

    public int getAttributeType() {
        return this.fAttributeType;
    }

    public String getAttributeURL() {
        return this.buildAttributeURL();
    }

    public String getSuffixingAttributeURL() {
        if (this.fESEPath.isEmpty()) {
            return String.valueOf(':') + this.getAttributeURL();
        }
        return String.valueOf('|') + this.getAttributeURL();
    }

    public String toString() {
        if (this == kNullAgentMetric) {
            return "{NullMetric}";
        }
        return this.getAttributeURL();
    }

    public String getSegment(int index) {
        return this.fESEPath.getSegment(index);
    }

    public Object readResolve() throws ObjectStreamException {
        try {
            return AgentMetric.getAgentMetric(this.fESEPath, this.fAttributeName, this.fAttributeType);
        }
        catch (BadlyFormedNameException badlyFormedNameException) {
            throw new InvalidObjectException("Bad AgentMetric metric name");
        }
    }

    public void writeExternal(ObjectOutput out) throws IOException {
        if (this == kNullAgentMetric) {
            throw new AssertionFailureException();
        }
        out.writeObject(this.fESEPath);
        out.writeObject(this.fAttributeName);
        out.writeInt(this.fAttributeType);
    }

    public void readExternal(ObjectInput in) throws IOException, ClassNotFoundException {
        this.fESEPath = (AgentMetricPrefix)in.readObject();
        this.fPathLen = this.fESEPath.length();
        this.fAttributeName = (String)in.readObject();
        this.fAttributeType = in.readInt();
    }

    private static AgentMetric lookupMetric(String metricName, int metricType, int id) throws BadlyFormedNameException {
        try {
            return sPool.lookupMetricWithTypeCheck(metricName, metricType, false, true, id);
        }
        catch (ConflictingTypesException conflictingTypesException) {
            return null;
        }
    }

    private static AgentMetric getUniqueNameAgentMetricFromCache(String metricName, int metricType) throws BadlyFormedNameException, ConflictingTypesException {
        AgentMetric existing = sPool.lookupMetricWithTypeCheck(metricName, metricType, true, true, -1);
        return existing;
    }

    private static AgentMetric getAgentMetricFromCache(String attributeURL, int typeCookie, int id) throws BadlyFormedNameException {
        return AgentMetric.lookupMetric(attributeURL, typeCookie, id);
    }

    private static void verifyValidName(String name) throws BadlyFormedNameException {
        if (name == null || name.length() == 0) {
            SimpleLocalizableMessage message = new SimpleLocalizableMessage("Metric_Name_Must_Be_Non_Empty_Error");
            throw new BadlyFormedNameException("Null or empty metric name.", (ILocalizableMessage)message);
        }
        if (name.indexOf(58) != -1 || name.indexOf(124) != -1) {
            FormattedLocalizableMessage message = new FormattedLocalizableMessage("Metric_Name_Is_Badly_Formed", name, false);
            throw new BadlyFormedNameException("Invalid metric name: \"" + name + "\"", (ILocalizableMessage)message);
        }
        if (StringUtils.containsTrailingSpaces(name)) {
            FormattedLocalizableMessage message = new FormattedLocalizableMessage("Metric_Name_Has_Trailing_Spaces", name, false);
            throw new BadlyFormedNameException("Invalid metric name containing trailing spaces: \"" + name + "\"", (ILocalizableMessage)message);
        }
        if (name.length() >= 21845) {
            String shortName = name.substring(0, 1000);
            FormattedLocalizableMessage message = new FormattedLocalizableMessage("Metric_Name_Is_Too_Long", shortName, "" + name.length(), "21845");
            throw new BadlyFormedNameException("Metric name too long: \"" + shortName + "...\"", (ILocalizableMessage)message);
        }
    }

    public static AgentMetric getUniqueNameAgentMetric(String metricName, int metricType) throws BadlyFormedNameException, ConflictingTypesException {
        return AgentMetric.getUniqueNameAgentMetricFromCache(metricName, metricType);
    }

    public static AgentMetric lookupUniqueNameAgentMetric(String metricName) throws BadlyFormedNameException, MetricNotFoundException {
        return sPool.lookupExistingMetric(metricName, true);
    }

    public static AgentMetric removeAgentMetric(String metricName) throws BadlyFormedNameException, MetricNotFoundException {
        return sPool.removeAgentMetric(metricName, 15);
    }

    public AgentMetric remove() {
        return sPool.removeAgentMetric(this);
    }

    public static String composeMetricString(AgentMetricPrefix path, AgentMetric metric) {
        return AgentMetric.composeMetricString(path.getPathURL(), metric.getAttributeName());
    }

    public static String composeMetricString(AgentMetricPrefix path, String metricName) {
        return AgentMetric.composeMetricString(path.getPathURL(), metricName);
    }

    public static String composeMetricString(String pathString, String metricName) {
        String metricString;
        if (metricName == null) {
            metricName = "";
        }
        if (pathString == null || pathString.length() == 0) {
            metricString = metricName;
        } else {
            StringBuffer sb = new StringBuffer(pathString.length() + 1 + metricName.length());
            sb.append(pathString);
            sb.append(':');
            sb.append(metricName);
            metricString = sb.toString();
        }
        return metricString;
    }

    public static void verifyValidMetricName(String metricName) throws BadlyFormedNameException {
        int separatorIndex;
        int n = separatorIndex = metricName == null ? -1 : metricName.lastIndexOf(58);
        if (separatorIndex != -1) {
            String resourceName = metricName.substring(0, separatorIndex);
            metricName = metricName.substring(separatorIndex + 1);
            AgentMetricPrefix.verifyValidResource(resourceName);
        }
        AgentMetric.verifyValidName(metricName);
    }

    public static AgentMetric getAgentMetric(AgentMetricPrefix path, String attributeName, int typeCookie) throws BadlyFormedNameException {
        return AgentMetric.getAgentMetric(path.getPathURL(), attributeName, typeCookie);
    }

    public static AgentMetric getAgentMetric(String pathString, String attributeName, int typeCookie) throws BadlyFormedNameException {
        String fullPath = AgentMetric.composeMetricString(pathString, attributeName);
        return AgentMetric.getAgentMetricFromCache(fullPath, typeCookie, -1);
    }

    public static AgentMetric getAgentMetric(String fullPath, int typeCookie, int id) throws BadlyFormedNameException {
        return AgentMetric.getAgentMetricFromCache(fullPath, typeCookie, id);
    }

    public static AgentMetric getAgentMetric(String fullPath, int typeCookie) throws BadlyFormedNameException {
        return AgentMetric.getAgentMetricFromCache(fullPath, typeCookie, -1);
    }

    public static AgentMetric getUniqueNameAgentMetric(String resource, String metricName, int metricType) throws BadlyFormedNameException, ConflictingTypesException {
        if (metricName == null) {
            metricName = "";
        }
        String fullMetric = resource == null || resource.length() == 0 ? metricName : String.valueOf(resource) + ":" + metricName;
        return AgentMetric.getUniqueNameAgentMetricFromCache(fullMetric, metricType);
    }

    public static AgentMetric getAgentMetric(AgentMetricPrefix path, String attributeName) {
        try {
            return AgentMetric.getAgentMetric(path, attributeName, 15);
        }
        catch (BadlyFormedNameException badlyFormedNameException) {
            throw new IllegalArgumentException(String.valueOf(path.getPathURL()) + ":" + attributeName);
        }
    }

    public static AgentMetric getAgentMetric(String fullPath) {
        try {
            return AgentMetric.getAgentMetric(fullPath, 15);
        }
        catch (BadlyFormedNameException badlyFormedNameException) {
            throw new IllegalArgumentException(fullPath);
        }
    }

    public static AgentMetric getAgentMetric(AgentMetricPrefix prefixPath, AgentMetric attribute) {
        if (prefixPath.isEmpty()) {
            return attribute;
        }
        try {
            return AgentMetric.getAgentMetricFromCache(String.valueOf(prefixPath.getPathURL()) + attribute.getSuffixingAttributeURL(), attribute.getAttributeType(), -1);
        }
        catch (BadlyFormedNameException bfne) {
            throw new InternalException(bfne);
        }
    }

    public static AgentMetric getAgentMetric(AgentMetric attributeToClone) {
        return attributeToClone;
    }

    public static AgentMetric getAgentMetric(AgentMetric attributeToClone, int typeCookie) {
        try {
            return AgentMetric.getAgentMetric(attributeToClone.getAttributeURL(), typeCookie);
        }
        catch (BadlyFormedNameException bfne) {
            throw new InternalException(bfne);
        }
    }

    public static AgentMetric[] getAllAgentMetrics() {
        return sPool.getAllAgentMetrics();
    }

    public static AgentMetric[] getPersistentAgentMetrics() {
        return sPool.getAgentMetrics(new IObjectFilter(){

            public boolean matches(Object o) {
                return ((AgentMetric)o).isPersistent();
            }
        });
    }

    public static AgentMetric[] getPersistentAgentMetricsInRange(final int startTimeSec, final int endTimeSec) {
        return sPool.getAgentMetrics(new IObjectFilter(){

            public boolean matches(Object o) {
                AgentMetric agentMetric = (AgentMetric)o;
                return agentMetric.isPersistent() && agentMetric.getLastSeenEndTimeSec() >= startTimeSec && agentMetric.getLastSeenStartTimeSec() <= endTimeSec;
            }
        });
    }

    public static void DEBUG_clearAllCachedIDs() {
        sPool.executeOnAllAgentMetrics(new IObjectAction(){

            public void execute(Object o) {
                AgentMetric m = (AgentMetric)o;
                m.setPersistentID(-1);
            }
        });
    }

    public static int getNumberAgentMetrics() {
        return sPool.getNumberAgentMetrics();
    }

    public CharSequence getCharSequence() {
        return this;
    }

    private char getCharAt(int index) {
        if (this.fPathLen == 0) {
            return this.fAttributeName.charAt(index);
        }
        if (index < this.fPathLen) {
            return this.fESEPath.charAt(index);
        }
        if (index == this.fPathLen) {
            return ':';
        }
        return this.fAttributeName.charAt(index - this.fPathLen - 1);
    }

    private int getLength() {
        if (this.fPathLen == 0) {
            return this.fAttributeName.length();
        }
        return this.fPathLen + 1 + this.fAttributeName.length();
    }

    public char charAt(int index) {
        char theChar = this.getCharAt(index);
        return theChar;
    }

    public int length() {
        int len = this.getLength();
        return len;
    }

    public CharSequence subSequence(int start, int end) {
        Assertion.unimplemented("If this is really called then perhaps we should optimize");
        return null;
    }

    public static void setNotUseThreadLocal() {
        sPool.setNotUseThreadLocal();
    }

    public static class AgentMetricKey
    implements Serializable {
        private static final long serialVersionUID = 4626794802331083302L;
        private final String fMetricName;
        private final int fMetricType;

        public AgentMetricKey(String metricName, int metricType) {
            this.fMetricName = metricName;
            this.fMetricType = TypeInquisitor.getNonTransientTypeCookie(metricType);
        }

        public boolean equals(Object obj) {
            if (this == obj) {
                return true;
            }
            AgentMetricKey compareTo = (AgentMetricKey)obj;
            return (this.fMetricType == compareTo.fMetricType || compareTo.fMetricType == 15 || this.fMetricType == 15) && this.fMetricName.equals(compareTo.fMetricName);
        }

        public int hashCode() {
            return this.fMetricName.hashCode();
        }

        public String toString() {
            return String.valueOf(this.fMetricName) + "(" + this.fMetricType + ")";
        }

        public String getAttributeURL() {
            return this.fMetricName;
        }

        public int getAttributeType() {
            return this.fMetricType;
        }
    }

    private static class CanonicalAgentMetricPool
    implements IAgentMetricPool {
        private volatile boolean fShouldUseThreadLocal = true;
        private CanonicalObjectPoolWithKey sCache = new CanonicalObjectPoolWithKey();
        private ThreadLocal sPoolThreadLocal = new ThreadLocal(){

            protected Object initialValue() {
                return new CanonicalObjectPoolWithKey();
            }
        };

        private CanonicalAgentMetricPool() {
        }

        private CanonicalObjectPoolWithKey getPool(boolean canUseLocal) {
            CanonicalObjectPoolWithKey result = null;
            if (canUseLocal) {
                if (this.fShouldUseThreadLocal) {
                    result = (CanonicalObjectPoolWithKey)this.sPoolThreadLocal.get();
                }
            } else {
                result = this.sCache;
            }
            return result;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public AgentMetric lookupMetricWithTypeCheck(String metricName, int metricType, boolean doUntypedLookup, boolean insertOnFailure, int initialPersistentId) throws BadlyFormedNameException, ConflictingTypesException {
            int existingType;
            AgentMetric result;
            boolean doTypeCheck = doUntypedLookup;
            int type = doUntypedLookup ? 15 : metricType;
            AgentMetricKey key = new AgentMetricKey(metricName, type);
            KeyValueWrapper resultKeyValueWrapper = null;
            CanonicalObjectPoolWithKey pool = this.getPool(true);
            if (pool != null) {
                resultKeyValueWrapper = pool.getCanonicalObjectWrapper(key);
            }
            if (resultKeyValueWrapper == null) {
                CanonicalObjectPoolWithKey masterPool;
                CanonicalObjectPoolWithKey canonicalObjectPoolWithKey = masterPool = this.getPool(false);
                synchronized (canonicalObjectPoolWithKey) {
                    block11: {
                        resultKeyValueWrapper = masterPool.getCanonicalObjectWrapper(key);
                        if (resultKeyValueWrapper != null || insertOnFailure) break block11;
                        return null;
                    }
                    AgentMetricKey newKey = new AgentMetricKey(metricName, metricType);
                    if (resultKeyValueWrapper == null) {
                        result = new AgentMetric(metricName, metricType, initialPersistentId);
                        resultKeyValueWrapper = masterPool.getCanonicalObjectWrapper(newKey, result);
                        doTypeCheck = false;
                    }
                }
                if (pool != null) {
                    pool.getCanonicalObjectWrapper(resultKeyValueWrapper.getKey(), resultKeyValueWrapper.getValue());
                }
            }
            if ((result = (AgentMetric)resultKeyValueWrapper.getValue()).getPersistentID() == -1 && initialPersistentId != -1) {
                result.setPersistentID(initialPersistentId);
            }
            if (result.getAttributeType() == 15 && type != 15) {
                result.fAttributeType = type;
            }
            if (doTypeCheck && !TypeInquisitor.isSameType(existingType = result.getAttributeType(), metricType)) {
                FormattedLocalizableMessage message = new FormattedLocalizableMessage("Metric_Type_Mismatch", metricName);
                throw new ConflictingTypesException("Mismatched metric types for " + metricName + ": Existing=" + existingType + " Requested=" + metricType, (ILocalizableMessage)message);
            }
            return result;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public AgentMetric lookupExistingMetric(String metricName, boolean throwOnFail) throws MetricNotFoundException, BadlyFormedNameException {
            AgentMetricKey key = new AgentMetricKey(metricName, 15);
            CanonicalObjectPoolWithKey pool = this.getPool(true);
            AgentMetric result = null;
            if (pool != null) {
                result = (AgentMetric)pool.getCanonicalObject(key);
            }
            if (result == null) {
                CanonicalObjectPoolWithKey masterPool;
                CanonicalObjectPoolWithKey canonicalObjectPoolWithKey = masterPool = this.getPool(false);
                synchronized (canonicalObjectPoolWithKey) {
                    result = (AgentMetric)masterPool.getCanonicalObject(key);
                    if (result == null && throwOnFail) {
                        throw new MetricNotFoundException("Failed to find metric: " + metricName);
                    }
                    if (pool != null) {
                        pool.getCanonicalObject(key, result);
                    }
                }
            }
            return result;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public AgentMetric[] getAllAgentMetrics() {
            AgentMetric[] result = kZeroLengthAgentMetricArray;
            CanonicalObjectPoolWithKey canonicalObjectPoolWithKey = this.sCache;
            synchronized (canonicalObjectPoolWithKey) {
                result = (AgentMetric[])this.sCache.toArray(kZeroLengthAgentMetricArray);
            }
            return result;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public AgentMetric[] getAgentMetrics(IObjectFilter filter) {
            AgentMetric[] result;
            CanonicalObjectPoolWithKey canonicalObjectPoolWithKey = this.sCache;
            synchronized (canonicalObjectPoolWithKey) {
                result = (AgentMetric[])this.sCache.toArray(filter, kZeroLengthAgentMetricArray);
            }
            return result;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public void executeOnAllAgentMetrics(IObjectAction action) {
            AgentMetric[] poolMetrics = null;
            CanonicalObjectPoolWithKey canonicalObjectPoolWithKey = this.sCache;
            synchronized (canonicalObjectPoolWithKey) {
                poolMetrics = (AgentMetric[])this.sCache.toArray(kZeroLengthAgentMetricArray);
            }
            if (poolMetrics != null) {
                int j = 0;
                while (j < poolMetrics.length) {
                    action.execute(poolMetrics[j]);
                    ++j;
                }
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public int getNumberAgentMetrics() {
            int result = 0;
            CanonicalObjectPoolWithKey canonicalObjectPoolWithKey = this.sCache;
            synchronized (canonicalObjectPoolWithKey) {
                result = this.sCache.size();
            }
            return result;
        }

        public void setNotUseThreadLocal() {
            this.fShouldUseThreadLocal = false;
        }

        public AgentMetric removeAgentMetric(String metricName, int metricType) throws BadlyFormedNameException, MetricNotFoundException {
            return this.lookupExistingMetric(metricName, true);
        }

        public AgentMetric removeAgentMetric(AgentMetric metric) {
            return metric;
        }
    }

    public static class Factory {
        private static Factory obj = new Factory();

        private Factory() {
        }

        public void setAttributeType(AgentMetric result, int type) {
            result.fAttributeType = type;
        }

        public static Factory getInstance() {
            return obj;
        }
    }

    public static interface IAgentMetricPool {
        public AgentMetric lookupMetricWithTypeCheck(String var1, int var2, boolean var3, boolean var4, int var5) throws BadlyFormedNameException, ConflictingTypesException;

        public AgentMetric lookupExistingMetric(String var1, boolean var2) throws MetricNotFoundException, BadlyFormedNameException;

        public AgentMetric[] getAllAgentMetrics();

        public AgentMetric[] getAgentMetrics(IObjectFilter var1);

        public void executeOnAllAgentMetrics(IObjectAction var1);

        public int getNumberAgentMetrics();

        public AgentMetric removeAgentMetric(String var1, int var2) throws MetricNotFoundException, BadlyFormedNameException;

        public AgentMetric removeAgentMetric(AgentMetric var1);

        public void setNotUseThreadLocal();
    }
}

