/*
 * Decompiled with CFR 0.152.
 */
package com.wily.introscope.spec.metric;

import com.wily.introscope.spec.metric.BadlyFormedNameException;
import com.wily.introscope.spec.metric.StringParser;
import com.wily.util.text.FormattedLocalizableMessage;
import com.wily.util.text.ILocalizableMessage;
import java.io.IOException;
import java.io.ObjectInput;
import java.io.ObjectOutput;

public final class AgentNameParser
extends StringParser {
    private static final long serialVersionUID = 5629842145261737403L;
    static final int kDomainSegmentIndex = 0;
    static final int kHostSegmentIndex = 1;
    static final int kProcessSegmentIndex = 2;
    static final int kAgentNameSegmentIndex = 3;
    public static final int kSegmentCount = 4;

    public AgentNameParser(String fullName) throws BadlyFormedNameException {
        super('|', fullName);
        this.validate();
    }

    public AgentNameParser(String[] segments) throws BadlyFormedNameException {
        super('|', segments);
        this.validate();
    }

    public AgentNameParser(String[] segments, int startIndex, int count) throws BadlyFormedNameException {
        super('|', segments, startIndex, count);
        this.validate();
    }

    public AgentNameParser() {
    }

    private void validate() throws BadlyFormedNameException {
        if (this.getSegmentCount() != 4) {
            FormattedLocalizableMessage message = new FormattedLocalizableMessage("Agent_Name_Is_Badly_Formed", this.getEntireString(), false);
            throw new BadlyFormedNameException("wrong number of segments in: " + this.getEntireString(), (ILocalizableMessage)message);
        }
        int i = 0;
        while (i < 4) {
            this.validateSegment(this.getSegment(i));
            ++i;
        }
    }

    private void validateSegment(String segment) throws BadlyFormedNameException {
        if (segment == null) {
            FormattedLocalizableMessage message = new FormattedLocalizableMessage("Agent_Name_Is_Badly_Formed", this.getEntireString(), false);
            throw new BadlyFormedNameException("null segment in: " + this.getEntireString(), (ILocalizableMessage)message);
        }
        if (segment.length() == 0) {
            FormattedLocalizableMessage message = new FormattedLocalizableMessage("Agent_Name_Is_Badly_Formed", this.getEntireString(), false);
            throw new BadlyFormedNameException("empty segment in: " + this.getEntireString(), (ILocalizableMessage)message);
        }
        if (segment.indexOf("|") != -1) {
            FormattedLocalizableMessage message = new FormattedLocalizableMessage("Agent_Name_Is_Badly_Formed", this.getEntireString(), false);
            throw new BadlyFormedNameException("illegal character in: " + this.getEntireString(), (ILocalizableMessage)message);
        }
        if (segment.indexOf(58) != -1) {
            FormattedLocalizableMessage message = new FormattedLocalizableMessage("Agent_Name_Is_Badly_Formed", this.getEntireString(), false);
            throw new BadlyFormedNameException("illegal character in: " + this.getEntireString(), (ILocalizableMessage)message);
        }
    }

    public final void smartWriteExternal(ObjectOutput out) throws IOException {
        super.smartWriteExternal(out);
    }

    public static AgentNameParser smartReadExternalAgentNameParser(ObjectInput in) throws IOException, ClassNotFoundException {
        AgentNameParser parser = new AgentNameParser();
        parser.readExternal(in);
        return parser;
    }
}

