/*
 * Decompiled with CFR 0.152.
 */
package com.wily.introscope.spec.metric;

import com.wily.introscope.spec.metric.AgentMetric;
import com.wily.introscope.spec.metric.AgentMetricData;
import com.wily.introscope.spec.metric.Frequency;
import com.wily.introscope.spec.server.beans.agent.ICompressedTimesliceData;
import com.wily.introscope.stat.timeslice.IntegerTimeslicedValue;
import com.wily.introscope.stat.timeslice.LongTimeslicedValue;
import com.wily.introscope.stat.timeslice.StringTimeslicedValue;
import com.wily.util.bit.BitPacking;
import com.wily.wilyassert.Assertion;
import java.io.Externalizable;
import java.io.IOException;
import java.io.ObjectInput;
import java.io.ObjectOutput;
import java.util.ArrayList;

public class CompressingAgentMetricDataSet
implements Externalizable,
ICompressedTimesliceData {
    private static final long serialVersionUID = -5097803348005109597L;
    private long fStartTime;
    private long fEndTime;
    private Frequency fFrequency;
    private Data[] fIntegerBindings;
    private Data[] fLongBindings;
    private Data[] fStringBindings;
    private AgentMetricData[] fUncompressedBindings;

    public CompressingAgentMetricDataSet() {
    }

    public CompressingAgentMetricDataSet(AgentMetricData[] bindings) {
        if (bindings.length > 0) {
            this.fStartTime = bindings[0].getDataValue().getStartTimestampInMillis();
            this.fEndTime = bindings[0].getDataValue().getStopTimestampInMillis();
            this.fFrequency = bindings[0].getFrequency();
        }
        ArrayList<Data> integerBindings = new ArrayList<Data>();
        ArrayList<Data> longBindings = new ArrayList<Data>();
        ArrayList<Data> stringBindings = new ArrayList<Data>();
        ArrayList<AgentMetricData> uncompressedBindings = new ArrayList<AgentMetricData>();
        int iter = 0;
        while (iter < bindings.length) {
            if (!bindings[iter].getFrequency().equals(this.fFrequency) || bindings[iter].getDataValue().getStartTimestampInMillis() != this.fStartTime || bindings[iter].getDataValue().getStopTimestampInMillis() != this.fEndTime) {
                uncompressedBindings.add(bindings[iter]);
            } else if (bindings[iter].getDataValue() instanceof IntegerTimeslicedValue) {
                integerBindings.add(this.packIntegerTimeslice(bindings[iter]));
            } else if (bindings[iter].getDataValue() instanceof LongTimeslicedValue) {
                longBindings.add(this.packLongTimeslice(bindings[iter]));
            } else if (bindings[iter].getDataValue() instanceof StringTimeslicedValue) {
                stringBindings.add(this.packStringTimeslice(bindings[iter]));
            } else {
                Assertion.wilyFail("unknown timesliced value data type " + bindings[iter].getDataValue().getClass());
            }
            ++iter;
        }
        if (integerBindings.size() > 0) {
            this.fIntegerBindings = integerBindings.toArray(new Data[0]);
        }
        if (longBindings.size() > 0) {
            this.fLongBindings = longBindings.toArray(new Data[0]);
        }
        if (stringBindings.size() > 0) {
            this.fStringBindings = stringBindings.toArray(new Data[0]);
        }
        if (uncompressedBindings.size() > 0) {
            this.fUncompressedBindings = uncompressedBindings.toArray(new AgentMetricData[0]);
        }
    }

    private Data[] readData(ObjectInput in) throws IOException, ClassNotFoundException {
        int length = in.readInt();
        if (length == -1) {
            return null;
        }
        Data[] data = new Data[length];
        int i = 0;
        while (i < length) {
            data[i] = new Data();
            data[i].readExternal(in);
            ++i;
        }
        return data;
    }

    public void readExternal(ObjectInput in) throws IOException, ClassNotFoundException {
        this.fStartTime = in.readLong();
        this.fEndTime = in.readLong();
        this.fFrequency = (Frequency)in.readObject();
        this.fIntegerBindings = this.readData(in);
        this.fLongBindings = this.readData(in);
        this.fStringBindings = this.readData(in);
        this.fUncompressedBindings = (AgentMetricData[])in.readObject();
    }

    private void writeData(ObjectOutput out, Data[] data) throws IOException {
        if (data == null) {
            out.writeInt(-1);
        } else {
            out.writeInt(data.length);
            int i = 0;
            while (i < data.length) {
                data[i].writeExternal(out);
                ++i;
            }
        }
    }

    public void writeExternal(ObjectOutput out) throws IOException {
        out.writeLong(this.fStartTime);
        out.writeLong(this.fEndTime);
        out.writeObject(this.fFrequency);
        this.writeData(out, this.fIntegerBindings);
        this.writeData(out, this.fLongBindings);
        this.writeData(out, this.fStringBindings);
        out.writeObject(this.fUncompressedBindings);
    }

    private Data packLongTimeslice(AgentMetricData binding) {
        int[] buf;
        Assertion.wilyAssert(binding.getDataValue() instanceof LongTimeslicedValue);
        LongTimeslicedValue bindValue = (LongTimeslicedValue)binding.getDataValue();
        int countLength = 0;
        int valueLength = 0;
        int minLength = 0;
        int maxLength = 0;
        int fieldLength = 0;
        int bitCount = 0;
        boolean dataAbsent = bindValue.dataIsAbsent();
        if (!dataAbsent) {
            countLength = BitPacking.bitLengthOfLong(bindValue.getDataPointCount());
            valueLength = BitPacking.bitLengthOfLong(bindValue.getValue());
            minLength = BitPacking.bitLengthOfLong(bindValue.getMinimum());
            maxLength = BitPacking.bitLengthOfLong(bindValue.getMaximum());
            fieldLength = CompressingAgentMetricDataSet.max(valueLength, minLength, maxLength);
            bitCount += 6;
            bitCount += countLength;
            bitCount += 6;
            bitCount += fieldLength * 3;
        }
        int[] nArray = buf = bitCount > 0 ? new int[BitPacking.getIntBufferSize(bitCount)] : null;
        if (buf != null && !dataAbsent) {
            int bitIndex = 0;
            BitPacking.writeInt(buf, bitIndex, 6, countLength - 1);
            BitPacking.writeLong(buf, bitIndex += 6, countLength, bindValue.getDataPointCount());
            BitPacking.writeInt(buf, bitIndex += countLength, 6, fieldLength - 1);
            BitPacking.writeLong(buf, bitIndex += 6, fieldLength, bindValue.getValue());
            BitPacking.writeLong(buf, bitIndex += fieldLength, fieldLength, bindValue.getMinimum());
            BitPacking.writeLong(buf, bitIndex += fieldLength, fieldLength, bindValue.getMaximum());
            bitIndex += fieldLength;
        }
        return new Data(binding.getAgentMetric(), buf);
    }

    private AgentMetricData unpackStringTimeslice(Data compressed) {
        boolean dataAbsent;
        String value = null;
        int[] buf = compressed.getValue();
        boolean bl = dataAbsent = buf == null;
        if (!dataAbsent) {
            int bitIndex = 0;
            if (BitPacking.readInt(buf, bitIndex++, 1) == 1) {
                int numBytes = BitPacking.readInt(buf, bitIndex, 32);
                value = new String(BitPacking.readBytes(buf, bitIndex += 32, numBytes));
            }
        }
        return new AgentMetricData(compressed.getMetric(), this.fFrequency, value != null ? new StringTimeslicedValue(compressed.getMetric().getAttributeType(), this.fStartTime, this.fEndTime, null, value) : new StringTimeslicedValue(compressed.getMetric().getAttributeType(), this.fStartTime, this.fEndTime, null, dataAbsent));
    }

    private AgentMetricData unpackIntegerTimeslice(Data compressed) {
        boolean dataAbsent;
        long dataCount = 0L;
        int value = 0;
        int min = 0;
        int max = 0;
        int[] buf = compressed.getValue();
        boolean bl = dataAbsent = buf == null;
        if (!dataAbsent) {
            int bitIndex = 0;
            int countLength = BitPacking.readInt(buf, bitIndex, 6) + 1;
            dataCount = BitPacking.readLong(buf, bitIndex += 6, countLength);
            int fieldLength = BitPacking.readInt(buf, bitIndex += countLength, 5) + 1;
            value = BitPacking.readInt(buf, bitIndex += 5, fieldLength);
            min = BitPacking.readInt(buf, bitIndex += fieldLength, fieldLength);
            max = BitPacking.readInt(buf, bitIndex += fieldLength, fieldLength);
            bitIndex += fieldLength;
        }
        return new AgentMetricData(compressed.getMetric(), this.fFrequency, new IntegerTimeslicedValue(compressed.getMetric().getAttributeType(), this.fStartTime, this.fEndTime, null, dataCount, dataAbsent, value, min, max));
    }

    private AgentMetricData unpackLongTimeslice(Data compressed) {
        boolean dataAbsent;
        long dataCount = 0L;
        long value = 0L;
        long min = 0L;
        long max = 0L;
        int[] buf = compressed.getValue();
        boolean bl = dataAbsent = buf == null;
        if (!dataAbsent) {
            int bitIndex = 0;
            int countLength = BitPacking.readInt(buf, bitIndex, 6) + 1;
            dataCount = BitPacking.readLong(buf, bitIndex += 6, countLength);
            int fieldLength = BitPacking.readInt(buf, bitIndex += countLength, 6) + 1;
            value = BitPacking.readLong(buf, bitIndex += 6, fieldLength);
            min = BitPacking.readLong(buf, bitIndex += fieldLength, fieldLength);
            max = BitPacking.readLong(buf, bitIndex += fieldLength, fieldLength);
            bitIndex += fieldLength;
        }
        return new AgentMetricData(compressed.getMetric(), this.fFrequency, new LongTimeslicedValue(compressed.getMetric().getAttributeType(), this.fStartTime, this.fEndTime, null, dataCount, dataAbsent, value, min, max));
    }

    private Data packStringTimeslice(AgentMetricData binding) {
        Assertion.wilyAssert(binding.getDataValue() instanceof StringTimeslicedValue);
        StringTimeslicedValue bindValue = (StringTimeslicedValue)binding.getDataValue();
        byte[] value = null;
        int bitCount = 0;
        boolean dataAbsent = bindValue.dataIsAbsent();
        int[] buf = null;
        if (!dataAbsent) {
            ++bitCount;
            if (bindValue.getString() != null) {
                value = bindValue.getString().getBytes();
                bitCount += 32;
                bitCount += value.length * 8;
            }
            buf = new int[BitPacking.getIntBufferSize(bitCount)];
            int bitIndex = 0;
            BitPacking.writeInt(buf, bitIndex++, 1, value != null ? 1 : 0);
            if (value != null) {
                BitPacking.writeInt(buf, bitIndex, 32, value.length);
                BitPacking.writeBytes(buf, bitIndex += 32, value);
            }
        }
        return new Data(binding.getAgentMetric(), buf);
    }

    private Data packIntegerTimeslice(AgentMetricData binding) {
        int[] buf;
        Assertion.wilyAssert(binding.getDataValue() instanceof IntegerTimeslicedValue);
        IntegerTimeslicedValue bindValue = (IntegerTimeslicedValue)binding.getDataValue();
        int countLength = 0;
        int valueLength = 0;
        int minLength = 0;
        int maxLength = 0;
        int fieldLength = 0;
        int bitCount = 0;
        boolean dataAbsent = bindValue.dataIsAbsent();
        if (!dataAbsent) {
            countLength = BitPacking.bitLengthOfLong(bindValue.getDataPointCount());
            valueLength = BitPacking.bitLengthOfInt(bindValue.getValue());
            minLength = BitPacking.bitLengthOfInt(bindValue.getMinimum());
            maxLength = BitPacking.bitLengthOfInt(bindValue.getMaximum());
            fieldLength = CompressingAgentMetricDataSet.max(valueLength, minLength, maxLength);
            bitCount += 6;
            bitCount += countLength;
            bitCount += 5;
            bitCount += fieldLength * 3;
        }
        int[] nArray = buf = bitCount > 0 ? new int[BitPacking.getIntBufferSize(bitCount)] : null;
        if (buf != null && !dataAbsent) {
            int bitIndex = 0;
            BitPacking.writeInt(buf, bitIndex, 6, countLength - 1);
            BitPacking.writeLong(buf, bitIndex += 6, countLength, bindValue.getDataPointCount());
            BitPacking.writeInt(buf, bitIndex += countLength, 5, fieldLength - 1);
            BitPacking.writeInt(buf, bitIndex += 5, fieldLength, bindValue.getValue());
            BitPacking.writeInt(buf, bitIndex += fieldLength, fieldLength, bindValue.getMinimum());
            BitPacking.writeInt(buf, bitIndex += fieldLength, fieldLength, bindValue.getMaximum());
            bitIndex += fieldLength;
        }
        return new Data(binding.getAgentMetric(), buf);
    }

    public AgentMetricData[] toArray() {
        int iter;
        ArrayList<AgentMetricData> bindings = new ArrayList<AgentMetricData>();
        if (this.fIntegerBindings != null) {
            iter = 0;
            while (iter < this.fIntegerBindings.length) {
                bindings.add(this.unpackIntegerTimeslice(this.fIntegerBindings[iter]));
                ++iter;
            }
        }
        if (this.fLongBindings != null) {
            iter = 0;
            while (iter < this.fLongBindings.length) {
                bindings.add(this.unpackLongTimeslice(this.fLongBindings[iter]));
                ++iter;
            }
        }
        if (this.fStringBindings != null) {
            iter = 0;
            while (iter < this.fStringBindings.length) {
                bindings.add(this.unpackStringTimeslice(this.fStringBindings[iter]));
                ++iter;
            }
        }
        if (this.fUncompressedBindings != null) {
            iter = 0;
            while (iter < this.fUncompressedBindings.length) {
                bindings.add(this.fUncompressedBindings[iter]);
                ++iter;
            }
        }
        return bindings.toArray(new AgentMetricData[bindings.size()]);
    }

    private static int max(int a, int b, int c) {
        int max = a > b ? a : b;
        max = max > c ? max : c;
        return max;
    }

    private static class Data
    implements Externalizable {
        private static final long serialVersionUID = -187396941075654753L;
        private AgentMetric fMetric;
        private int[] fValue;

        public Data() {
        }

        public Data(AgentMetric metric, int[] value) {
            this.fMetric = metric;
            this.fValue = value;
        }

        public AgentMetric getMetric() {
            return this.fMetric;
        }

        public int[] getValue() {
            return this.fValue;
        }

        public void readExternal(ObjectInput in) throws IOException, ClassNotFoundException {
            this.fMetric = (AgentMetric)in.readObject();
            int length = in.readInt();
            if (length == -1) {
                this.fValue = null;
            } else {
                this.fValue = new int[length];
                int i = 0;
                while (i < length) {
                    this.fValue[i] = in.readInt();
                    ++i;
                }
            }
        }

        public void writeExternal(ObjectOutput out) throws IOException {
            out.writeObject(this.fMetric);
            if (this.fValue == null) {
                out.writeInt(-1);
            } else {
                out.writeInt(this.fValue.length);
                int i = 0;
                while (i < this.fValue.length) {
                    out.writeInt(this.fValue[i]);
                    ++i;
                }
            }
        }
    }
}

