/*
 * Decompiled with CFR 0.152.
 */
package com.wily.introscope.spec.server.transactiontrace;

import com.wily.introscope.spec.server.transactiontrace.ATransactionTraceFilter;
import com.wily.introscope.spec.server.transactiontrace.TransactionComponentData;
import com.wily.util.text.IStringLocalizer;
import java.io.DataInput;
import java.io.DataOutput;
import java.io.Externalizable;
import java.io.IOException;
import java.io.ObjectInput;
import java.io.ObjectOutput;
import java.util.Locale;
import java.util.Map;

public class ResourceTraceFilter
extends ATransactionTraceFilter
implements Externalizable {
    private static final long serialVersionUID = 7682589343997456909L;
    private String fResource;

    public ResourceTraceFilter() {
    }

    public ResourceTraceFilter(String resource) {
        this.fResource = resource;
    }

    public int ITransactionTraceFilter_getFilterType() {
        return 8;
    }

    public boolean ITransactionTraceFilter_passesFilter(TransactionComponentData root) {
        String lResource = root.getResource();
        if (lResource.startsWith(this.fResource) && (lResource.length() == this.fResource.length() || lResource.charAt(this.fResource.length()) == '|')) {
            return true;
        }
        int count = root.getSubNodeCount();
        int i = 0;
        while (i < count) {
            boolean result = this.ITransactionTraceFilter_passesFilter(root.getCalledComponent(i));
            if (result) {
                return result;
            }
            ++i;
        }
        return false;
    }

    public boolean shouldCollect(Map parameters) {
        return true;
    }

    public boolean isHeadFilter() {
        return false;
    }

    public String ITransactionTraceFilter_getLocalizedDescription(IStringLocalizer localizer) {
        return "Unimplemented";
    }

    public String ITransactionTraceFilter_getLocalizedStatusMessage(IStringLocalizer localizer) {
        return "Unimplemented";
    }

    public String ITransactionTraceFilter_getLocalizedStatusMessage(IStringLocalizer localizer, Locale locale) {
        return "Unimplemented";
    }

    public void ITransactionTraceFilter_write(DataOutput out) throws IOException {
        out.writeUTF(this.fResource);
    }

    private void readInternal(DataInput in) throws IOException {
        this.fResource = in.readUTF();
    }

    public void writeExternal(ObjectOutput out) throws IOException {
        this.ITransactionTraceFilter_write(out);
    }

    public void readExternal(ObjectInput in) throws IOException, ClassNotFoundException {
        this.readInternal(in);
    }

    public int hashCode() {
        return this.fResource.hashCode();
    }

    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (o != null && o instanceof ResourceTraceFilter) {
            ResourceTraceFilter f = (ResourceTraceFilter)o;
            return f.fResource.equals(this.fResource);
        }
        return false;
    }
}

