/*
 * Decompiled with CFR 0.152.
 */
package com.wily.introscope.spec.server.transactiontrace;

import com.wily.introscope.spec.server.transactiontrace.BoundaryOnlyTransactionData;
import com.wily.introscope.spec.server.transactiontrace.TransactionComponentData;
import java.io.DataInput;
import java.io.IOException;
import java.util.HashMap;
import java.util.LinkedList;
import java.util.Map;

public class TransactionComponentDataEnhanced
extends TransactionComponentData {
    private static final long serialVersionUID = 8887871890146845996L;
    private long fDurationMilliSecs;
    private boolean fDurationMilliSecsState;
    private long fDurationMicroSecs;
    private boolean fDurationMicroSecsState;
    private long fDurationNanoSecs;
    private boolean fDurationNanoSecsState;
    private long fStartTimeMilliSecs;
    private boolean fStartTimeMilliSecsState;
    private long fStartTimeMicroSecs;
    private boolean fStartTimeMicroSecsState;
    private long fStartTimeNanoSecs;
    private boolean fStartTimeNanoSecsState;

    private void initialize(long duration, long startTime) {
        this.fDurationMilliSecs = duration / 1000L;
        this.fDurationMilliSecsState = true;
        this.fStartTimeMilliSecs = startTime / 1000L;
        this.fStartTimeMilliSecsState = true;
        this.fDurationNanoSecs = duration * 1000L;
        this.fDurationNanoSecsState = true;
        this.fStartTimeNanoSecs = startTime * 1000L;
        this.fStartTimeNanoSecsState = true;
    }

    public TransactionComponentDataEnhanced() {
    }

    public static TransactionComponentData createMicroSecTransactionComponentData(String resource, long startTime, long duration) {
        return new TransactionComponentDataEnhanced(resource, startTime, duration);
    }

    private TransactionComponentDataEnhanced(String resource, long startTime, long duration) {
        super(resource, startTime, duration, kNoParameters, kNoCalledComponents);
        this.initialize(duration, startTime);
    }

    public static TransactionComponentData createMicroSecTransactionComponentData(String resource, long startTime, long duration, Map parameters) {
        return new TransactionComponentDataEnhanced(resource, startTime, duration, parameters);
    }

    private TransactionComponentDataEnhanced(String resource, long startTime, long duration, Map parameters) {
        super(resource, startTime, duration, parameters, kNoCalledComponents);
        this.initialize(duration, startTime);
    }

    public static TransactionComponentData createMicroSecTransactionComponentData(String resource, long startTime, long duration, HashMap parameters) {
        return new TransactionComponentDataEnhanced(resource, startTime, duration, parameters);
    }

    private TransactionComponentDataEnhanced(String resource, long startTime, long duration, HashMap parameters) {
        super(resource, startTime, duration, parameters, kNoCalledComponents);
        this.initialize(duration, startTime);
    }

    public static TransactionComponentDataEnhanced createMicroSecTransactionComponentData(String resource, long startTime, long duration, TransactionComponentDataEnhanced[] calledComponents) {
        return new TransactionComponentDataEnhanced(resource, startTime, duration, calledComponents);
    }

    private TransactionComponentDataEnhanced(String resource, long startTime, long duration, TransactionComponentDataEnhanced[] calledComponents) {
        super(resource, startTime, duration, kNoParameters, calledComponents);
        this.initialize(duration, startTime);
    }

    public static TransactionComponentDataEnhanced createMicroSecTransactionComponentData(String resource, long startTime, long duration, Map parameters, TransactionComponentDataEnhanced[] calledComponents) {
        return new TransactionComponentDataEnhanced(resource, startTime, duration, parameters, calledComponents);
    }

    private TransactionComponentDataEnhanced(String resource, long startTime, long duration, Map parameters, TransactionComponentDataEnhanced[] calledComponents) {
        super(resource, 5000, startTime, duration, parameters, (TransactionComponentData[])calledComponents);
        this.initialize(duration, startTime);
    }

    public static TransactionComponentDataEnhanced createMicroSecTransactionComponentData(String resource, int magnitude, long startTime, long duration, Map parameters, TransactionComponentDataEnhanced[] calledComponents) {
        return new TransactionComponentDataEnhanced(resource, magnitude, startTime, duration, parameters, calledComponents);
    }

    private TransactionComponentDataEnhanced(String resource, int magnitude, long startTime, long duration, Map parameters, TransactionComponentDataEnhanced[] calledComponents) {
        super(resource, magnitude, startTime, duration, parameters, (TransactionComponentData[])calledComponents);
        this.initialize(duration, startTime);
    }

    public long getDurationInMicroSecs() {
        return this.getDuration();
    }

    public long getNetDurationInMicroSecs() {
        return this.getNetDuration();
    }

    public long getStartTimeInMicroSecs() {
        return this.getStartTime();
    }

    public long getDurationInMilliSecs() {
        if (!this.fDurationMilliSecsState) {
            this.fDurationMilliSecs = this.getDuration() / 1000L;
            this.fDurationMilliSecsState = true;
        }
        return this.fDurationMilliSecs;
    }

    public long getNetDurationInMilliSecs() {
        return this.getNetDuration() / 1000L;
    }

    public long getStartTimeInMilliSecs() {
        if (!this.fStartTimeMilliSecsState) {
            this.fStartTimeMilliSecs = this.getStartTime() / 1000L;
            this.fStartTimeMilliSecsState = true;
        }
        return this.fStartTimeMilliSecs;
    }

    public long getDurationInNanoSecs() {
        if (!this.fDurationNanoSecsState) {
            this.fDurationNanoSecs = this.getDuration() * 1000L;
            this.fDurationNanoSecsState = true;
        }
        return this.fDurationNanoSecs;
    }

    public long getStartTimeInNanoSecs() {
        if (!this.fStartTimeNanoSecsState) {
            this.fStartTimeNanoSecs = this.getStartTime() * 1000L;
            this.fStartTimeNanoSecsState = true;
        }
        return this.fStartTimeNanoSecs;
    }

    public long getNetDurationInNanoSecs() {
        return this.getNetDuration() * 1000L;
    }

    public boolean equals(Object o) {
        if (o instanceof TransactionComponentDataEnhanced) {
            return super.equals(o);
        }
        return false;
    }

    protected void readInternal(DataInput in) throws IOException {
        LinkedList<Object> stack = new LinkedList<Object>();
        stack.addLast(this);
        do {
            BoundaryOnlyTransactionData.TTCalledComponentData children;
            Object top;
            if ((top = stack.removeLast()) instanceof BoundaryOnlyTransactionData.TTCalledComponentData) {
                int index;
                children = (BoundaryOnlyTransactionData.TTCalledComponentData)top;
                ++children.fNextIndex;
                BoundaryOnlyTransactionData[] calledComponents = children.fCalledComponents;
                if (index >= calledComponents.length) continue;
                TransactionComponentDataEnhanced child = new TransactionComponentDataEnhanced();
                calledComponents[index] = child;
                stack.addLast(children);
                stack.addLast(child);
                continue;
            }
            if (!(top instanceof TransactionComponentDataEnhanced)) continue;
            TransactionComponentDataEnhanced cfr_ignored_0 = (TransactionComponentDataEnhanced)top;
            children = new BoundaryOnlyTransactionData.TTCalledComponentData();
            stack.addLast(children);
        } while (!stack.isEmpty());
    }
}

