/*
 * Decompiled with CFR 0.152.
 */
package com.wily.introscope.stat.gatherer;

import com.wily.introscope.spec.metric.IncompatibleTypesException;
import com.wily.introscope.spec.server.beans.metricdata.IMetricDataValue;
import com.wily.introscope.stat.blame.BlameStackSnapshot;
import com.wily.introscope.stat.gatherer.IGatherer;
import com.wily.introscope.stat.timeslice.ATimeslicedValue;
import com.wily.introscope.stat.timeslice.IntegerTimeslicedValue;

public class DeterministicIntegerGatherer
implements IGatherer {
    private final int fTypeCookie;
    private int[] fValues;
    private int fCurIndex;
    private long fLastTimestamp;
    private boolean fTimeToIncrement;

    public DeterministicIntegerGatherer(int typeCookie, long startTimestamp) {
        this.fTypeCookie = typeCookie;
        this.fValues = new int[0];
        this.fCurIndex = 0;
        this.fLastTimestamp = startTimestamp;
        this.fTimeToIncrement = false;
    }

    public final synchronized void addValues(int[] newValues) {
        int[] oldValues = this.fValues;
        int totalLength = oldValues.length + newValues.length;
        this.fValues = new int[totalLength];
        System.arraycopy(oldValues, 0, this.fValues, 0, oldValues.length);
        System.arraycopy(newValues, 0, this.fValues, oldValues.length, newValues.length);
    }

    public final synchronized boolean hasDataRemaining() {
        return this.fCurIndex < this.fValues.length;
    }

    public final ATimeslicedValue[] IGatherer_harvestAndReset(long when) {
        return this.IGatherer_harvestAndReset(when, BlameStackSnapshot.kEmptyBlameStackSnapshot);
    }

    public final synchronized ATimeslicedValue[] IGatherer_harvestAndReset(long when, BlameStackSnapshot blameStack) {
        ATimeslicedValue[] result = this.IGatherer_harvest(when, blameStack);
        this.IGatherer_reset(when);
        return result;
    }

    public final ATimeslicedValue[] IGatherer_harvest(long when) {
        return this.IGatherer_harvest(when, BlameStackSnapshot.kEmptyBlameStackSnapshot);
    }

    public final synchronized ATimeslicedValue[] IGatherer_harvest(long when, BlameStackSnapshot blameStack) {
        ATimeslicedValue[] result = new ATimeslicedValue[]{this.hasDataRemaining() ? new IntegerTimeslicedValue(this.fTypeCookie, this.fLastTimestamp, when, blameStack, this.fValues[this.fCurIndex]) : new IntegerTimeslicedValue(this.fTypeCookie, this.fLastTimestamp, when, blameStack, true)};
        return result;
    }

    public final synchronized void IGatherer_reset(long when) {
        this.fLastTimestamp = when;
        if (this.hasDataRemaining()) {
            if (this.fTimeToIncrement) {
                ++this.fCurIndex;
            }
            this.fTimeToIncrement = !this.fTimeToIncrement;
        }
    }

    public final void IGatherer_acceptAggregateTimeslicedValue(ATimeslicedValue newAggregate) throws IncompatibleTypesException {
        throw new IncompatibleTypesException("Can't change value of a deterministic gatherer");
    }

    public final void IGatherer_reinitialize() {
    }

    public final int IGatherer_getESETypeCookie() {
        return this.fTypeCookie;
    }

    public boolean IGatherer_canCombineData() {
        return false;
    }

    public void forceToExist(BlameStackSnapshot blameStack) {
    }

    public void acceptValueNonSync(IMetricDataValue value) throws IncompatibleTypesException {
        throw new IncompatibleTypesException("Can't change value of a deterministic gatherer");
    }

    public IMetricDataValue harvestAndReinitializeNonSync(long harvestTimeMS) {
        return this.IGatherer_harvest(harvestTimeMS)[0];
    }

    public boolean IGatherer_hasNewData(int timeslices) {
        return true;
    }

    public long IGatherer_getStartTimestamp() {
        return this.fLastTimestamp;
    }

    public IMetricDataValue harvestAndAbandonNonSync(long harvestTimeMS) {
        return this.IGatherer_harvest(harvestTimeMS)[0];
    }
}

