/*
 * Decompiled with CFR 0.152.
 */
package com.wily.introscope.stat.gatherer;

import com.wily.introscope.spec.metric.TypeInquisitor;
import com.wily.introscope.spec.server.beans.metricdata.IMetricDataValue;
import com.wily.introscope.stat.gatherer.AIntegerCombiningGatherer;
import com.wily.introscope.stat.timeslice.IntegerTimeslicedValue;
import com.wily.math.RunningLongAverage;
import com.wily.wilyassert.Assertion;

public class IntegerAverageGatherer
extends AIntegerCombiningGatherer {
    private int fMinimum;
    private int fMaximum;
    private RunningLongAverage fRunningAverage;
    private static final int kMaxCount = 2000;
    private static final int kMaxValue = 30000;

    public IntegerAverageGatherer(int typeCookie, long startTimestamp) {
        super(typeCookie, startTimestamp);
        Assertion.wilyAssert(TypeInquisitor.isPercentage(typeCookie));
    }

    private RunningLongAverage getRunningAverage() {
        if (this.fRunningAverage == null) {
            this.fRunningAverage = new RunningLongAverage();
        }
        return this.fRunningAverage;
    }

    public int getIntValue() {
        if (this.fRunningAverage == null) {
            return 0;
        }
        return (int)this.fRunningAverage.getAverage();
    }

    public int getIntMinimum() {
        return this.fMinimum;
    }

    public int getIntMaximum() {
        return this.fMaximum;
    }

    protected void directSetIntMinimum(int minimum) {
        this.fMinimum = minimum;
    }

    protected void directSetIntMaximum(int maximum) {
        this.fMaximum = maximum;
    }

    public synchronized void recordOneDataPoint(int value) {
        this.getRunningAverage().combineValue(value);
        this.syncSinglePointBounds(value);
        this.incrementDataPointCountNonSync();
        this.noteDataIsPresent();
    }

    protected void doAcceptAggregateIntegerTimeslicedValue(IntegerTimeslicedValue typedAggregate) {
        if (typedAggregate.getDataPointCount() != 0L) {
            long count = typedAggregate.getDataPointCount();
            int avg = typedAggregate.getValue();
            long min = typedAggregate.getMinimumAsLong();
            long max = typedAggregate.getMaximumAsLong();
            this.getRunningAverage().combineValue(avg, count, min, max);
            this.syncAggregateBounds(typedAggregate);
            this.addToDataPointCountNonSync(typedAggregate.getDataPointCount());
        }
    }

    protected void doResetCombiningGatherer(long when) {
        this.whackInternalState();
    }

    protected void doReinitializeCombiningGatherer() {
        this.whackInternalState();
    }

    private void whackInternalState() {
        this.directSetIntMinimum(0);
        this.directSetIntMaximum(0);
        this.getRunningAverage().reset();
    }

    private static int fastIntWeightedAverage(int value1, long count1, int value2, long count2) {
        if (count1 > 2000L || count2 > 2000L || value1 > 30000 || value2 > 30000) {
            double total = (double)value1 * (double)count1 + (double)value2 * (double)count2;
            return (int)(total /= (double)count1 + (double)count2);
        }
        return (value1 * (int)count1 + value2 * (int)count2) / ((int)count1 + (int)count2);
    }

    public static IMetricDataValue aggregateByTime(IMetricDataValue pvalue1, IMetricDataValue pvalue2) {
        IntegerTimeslicedValue value1 = (IntegerTimeslicedValue)pvalue1;
        IntegerTimeslicedValue value2 = (IntegerTimeslicedValue)pvalue2;
        if (value1.dataIsAbsent() || value2.dataIsAbsent()) {
            return IntegerAverageGatherer.absentInt(value1, value2);
        }
        long count = value1.getDataPointCount() + value2.getDataPointCount();
        int min = Math.min(value1.getMinimum(), value2.getMinimum());
        int max = Math.max(value1.getMaximum(), value2.getMaximum());
        int avg = IntegerAverageGatherer.fastIntWeightedAverage(value1.getValue(), value1.getDataPointCount(), value2.getValue(), value2.getDataPointCount());
        return new IntegerTimeslicedValue(value1.getType(), value1.getStartTimestampInMillis(), value2.getStopTimestampInMillis(), null, count, false, avg, min, max);
    }
}

