/*
 * Decompiled with CFR 0.152.
 */
package com.wily.isengard.messageprimitives;

import com.wily.isengard.IsengardError;
import com.wily.isengard.messageprimitives.IRawMethodHandler;
import com.wily.isengard.messageprimitives.IVersionedInterface;
import com.wily.isengard.messageprimitives.MethodCallMessage;
import com.wily.util.exception.UnexpectedExceptionError;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import java.text.MessageFormat;

public class MethodCallUtilities {
    private static final boolean sLog = Boolean.getBoolean("log.remotecalls");
    private static final Object sLogLock = new Object();

    public static Object callInterface(Object callHandler, MethodCallMessage message) throws Throwable {
        return MethodCallUtilities.callInterface(callHandler, message.getMethod(), message.getMethodName(), message.getInterfaceVersion(), message.getParams());
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static void log(Method method, Object[] params) {
        Object object = sLogLock;
        synchronized (object) {
            System.out.print("Calling " + method.getDeclaringClass().getName() + "." + method.getName() + "(");
            if (params != null) {
                int i = 0;
                while (i < params.length) {
                    System.out.print("[" + params[i] + "]");
                    if (i < params.length - 1) {
                        System.out.print(", ");
                    }
                    ++i;
                }
            }
            System.out.println(")");
        }
    }

    public static Object callInterface(Object callHandler, Method method, String methodName, int version, Object[] params) throws Throwable {
        if (sLog) {
            MethodCallUtilities.log(method, params);
        }
        try {
            if (callHandler instanceof IRawMethodHandler) {
                return ((IRawMethodHandler)callHandler).rawMethodHandler(method, version, params);
            }
            method.setAccessible(true);
            return method.invoke(callHandler, params);
        }
        catch (InvocationTargetException e) {
            throw e.getTargetException();
        }
        catch (IllegalArgumentException illegalArgumentException) {
            return MethodCallUtilities.deliverToOldInterface(callHandler, methodName, version, params);
        }
        catch (IllegalAccessException e) {
            throw new UnexpectedExceptionError("The method " + method + " of class " + method.getDeclaringClass() + " is not accessible for message delivery.", e);
        }
        catch (Error e) {
            throw new IsengardError("Error while invoking method " + method + " of class " + method.getDeclaringClass(), e);
        }
    }

    private static Object deliverToOldInterface(Object callHandler, String methodName, int version, Object[] params) {
        try {
            IVersionedInterface i = (IVersionedInterface)callHandler;
            Object deliveryObject = i.getOldVersionHandler(version);
            Object[] classParams = null;
            if (params != null) {
                classParams = new Class[params.length];
                int k = 0;
                while (k < params.length) {
                    classParams[k] = params[k].getClass();
                    ++k;
                }
            }
            Method method = deliveryObject.getClass().getMethod(methodName, (Class<?>[])classParams);
            return method.invoke(deliveryObject, classParams);
        }
        catch (ClassCastException e) {
            throw new UnexpectedExceptionError(MessageFormat.format("Unable to deliver message {0} to the invocation handler {1}, probably because of a versioning problem", methodName, callHandler.getClass().getName()), e);
        }
        catch (Throwable e) {
            throw new UnexpectedExceptionError(e);
        }
    }
}

