/*
 * Decompiled with CFR 0.152.
 */
package com.wily.isengard.messageprimitives.callback;

import com.wily.isengard.messageprimitives.ConnectionException;
import com.wily.isengard.messageprimitives.InvalidIsengardInterface;
import com.wily.isengard.messageprimitives.callback.CallbackConnector;
import com.wily.isengard.messageprimitives.callback.ICallback;
import com.wily.isengard.messageprimitives.pipe.AAsyncMessagePipeEndpoint;
import com.wily.isengard.messageprimitives.pipe.EndpointNotFoundException;
import com.wily.isengard.messageprimitives.pipe.IMessagePipeData;
import com.wily.isengard.postoffice.Address;
import com.wily.isengard.postoffice.PostOffice;
import com.wily.util.ICloseable;
import com.wily.util.exception.UnexpectedExceptionError;
import java.io.Externalizable;
import java.io.IOException;
import java.io.ObjectInput;
import java.io.ObjectOutput;

public class Callback
implements Externalizable,
ICloseable {
    private static final long serialVersionUID = -7036188355773696061L;
    private AAsyncMessagePipeEndpoint fEndpoint;
    private PostOffice fPostOffice;
    private CallbackConnector fConnector;
    private ICallback fCallbackHandler;
    private Address fPipeAddress;
    private Class fCallbackInterface;
    private boolean fClosed;

    public Callback() {
    }

    protected Callback(Class callbackInterface, ICallback callbackHandler) {
        this.fCallbackHandler = callbackHandler;
        this.fCallbackInterface = callbackInterface;
    }

    public Callback(PostOffice po, Class callbackInterface, ICallback callbackHandler) {
        this.fPostOffice = po;
        this.fCallbackHandler = callbackHandler;
        this.fCallbackInterface = callbackInterface;
    }

    public ICallback getHandler() {
        return this.fCallbackHandler;
    }

    public PostOffice getPostOffice() {
        return this.fPostOffice;
    }

    synchronized void setCallbackConnector(CallbackConnector notification) throws EndpointNotFoundException {
        this.fConnector = notification;
        if (this.fClosed) {
            throw new EndpointNotFoundException();
        }
    }

    CallbackConnector getConnectorCloseNotification() {
        return this.fConnector;
    }

    public synchronized void close() {
        if (this.fClosed) {
            return;
        }
        this.fClosed = true;
        if (this.fEndpoint != null) {
            this.fEndpoint.close();
            this.fEndpoint = null;
        } else if (this.fConnector != null) {
            this.fConnector.clientClosing();
        }
    }

    public synchronized boolean isClosed() {
        return this.fClosed;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    void connectorClose() {
        Callback callback = this;
        synchronized (callback) {
            if (this.fClosed) {
                return;
            }
            this.fClosed = true;
        }
        try {
            if (this.fCallbackHandler != null) {
                this.fCallbackHandler.closing();
            }
        }
        catch (ConnectionException connectionException) {}
    }

    final Address getRemotePipeAddress() {
        return this.fPipeAddress;
    }

    public void readExternal(ObjectInput in) throws IOException, ClassNotFoundException {
        this.fPipeAddress = (Address)in.readObject();
    }

    public synchronized void writeExternal(ObjectOutput out) throws IOException {
        if (this.fPostOffice == null && this.fPipeAddress != null) {
            out.writeObject(this.fPipeAddress);
            return;
        }
        if (this.fEndpoint == null) {
            try {
                this.fEndpoint = new LocalAsyncMessagePipeEndpoint(this.fPostOffice, this.fCallbackInterface, this.fCallbackHandler);
            }
            catch (InvalidIsengardInterface e) {
                throw new UnexpectedExceptionError(e);
            }
        }
        out.writeObject(this.fEndpoint.getPipeAddress());
        if (this.fClosed) {
            this.fEndpoint.close();
            this.fEndpoint = null;
        }
    }

    protected void finalize() throws Throwable {
        if (this.fEndpoint != null) {
            this.fEndpoint.close();
            this.fEndpoint = null;
        }
    }

    boolean hasEndpoint() {
        return this.fEndpoint != null;
    }

    private class LocalAsyncMessagePipeEndpoint
    extends AAsyncMessagePipeEndpoint {
        public LocalAsyncMessagePipeEndpoint(PostOffice po, Class clazz, IMessagePipeData handler) throws InvalidIsengardInterface {
            super(po, clazz, handler);
        }

        protected void onPipeClosed() {
            Callback.this.connectorClose();
        }
    }
}

