/*
 * Decompiled with CFR 0.152.
 */
package com.wily.isengard.messageprimitives.service;

import com.wily.isengard.message.AMessage;
import com.wily.isengard.message.CheckedThrowableMessage;
import com.wily.isengard.message.MessageUndeliverableException;
import com.wily.isengard.message.UncheckedThrowableMessage;
import com.wily.isengard.messageprimitives.CompressedMethodResultMessage;
import com.wily.isengard.messageprimitives.InterfaceValidationUtilities;
import com.wily.isengard.messageprimitives.InvalidIsengardInterface;
import com.wily.isengard.messageprimitives.MethodCallMessage;
import com.wily.isengard.messageprimitives.MethodCallUtilities;
import com.wily.isengard.messageprimitives.MethodResultMessage;
import com.wily.isengard.messageprimitives.UnexpectedMessageError;
import com.wily.isengard.messageprimitives.service.IMessageService;
import com.wily.isengard.messageprimitives.service.MessageServiceInfo;
import com.wily.isengard.postoffice.Address;
import com.wily.isengard.postoffice.Mailbox;
import com.wily.isengard.postoffice.MailboxInUseException;
import com.wily.isengard.postoffice.MessageUndeliverableMessage;
import com.wily.isengard.postoffice.PostOffice;
import com.wily.isengard.util.parameter.CheckParameter;
import com.wily.util.feedback.Module;
import java.lang.reflect.InvocationTargetException;
import java.text.MessageFormat;
import java.util.HashMap;

public class MessageService
extends Mailbox {
    public static final String kDefaultMessageServiceContext = "/service/";
    public static final String kRegistryInterfaceProperty = "Interface";
    private static final Module sModule = new Module("MessageService");
    private Class fServiceInterface;
    private boolean fCompressed;
    static /* synthetic */ Class class$0;
    static /* synthetic */ Class class$1;

    public MessageService(PostOffice po) {
        super(po);
    }

    public MessageService(PostOffice po, int mailbox) throws MailboxInUseException {
        super(po, mailbox);
    }

    public void initialize(Class clazz, IMessageService methodHandler) throws InvalidIsengardInterface {
        Class<?> clazz2 = class$0;
        if (clazz2 == null) {
            try {
                clazz2 = class$0 = Class.forName("com.wily.isengard.messageprimitives.service.IMessageService");
            }
            catch (ClassNotFoundException classNotFoundException) {
                throw new NoClassDefFoundError(classNotFoundException.getMessage());
            }
        }
        InterfaceValidationUtilities.validateInterface(clazz, clazz2);
        Class<?> clazz3 = class$1;
        if (clazz3 == null) {
            try {
                clazz3 = class$1 = Class.forName("com.wily.isengard.messageprimitives.service.IIsengardCompressed");
            }
            catch (ClassNotFoundException classNotFoundException) {
                throw new NoClassDefFoundError(classNotFoundException.getMessage());
            }
        }
        if (clazz3.isAssignableFrom(clazz)) {
            this.fCompressed = true;
        }
        this.fServiceInterface = clazz;
        this.setInvocationHandler(methodHandler);
    }

    public Class getServiceInterface() {
        return this.fServiceInterface;
    }

    public MessageServiceInfo getServiceInfo() {
        return new MessageServiceInfo(this.getAddress(), "Unknown", new HashMap());
    }

    public final void allowAllGroupsToAccess() {
        this.setGroupAccess(Address.kAllGroupsHaveAccess);
    }

    public final void setGroupAccess(String[] groups) {
        CheckParameter.notEmptyArray("Security Groups", groups);
        this.getAddress().setGroupAccess(groups);
    }

    private void handleMethodCallMessage(MethodCallMessage request) {
        AMessage reply = this.attemptMethodCall(request);
        reply.setSequenceNumber(request.getSequenceNumber());
        reply.setLowLatency();
        reply.setHubShouldDirectDeliver(true);
        reply.setDeliverIfClosed(true);
        try {
            this.sendMessage(reply, request.getSourceAddress());
        }
        catch (MessageUndeliverableException messageUndeliverableException) {}
    }

    public final void receiveMessage(AMessage message) {
        if (message instanceof MethodCallMessage) {
            this.handleMethodCallMessage((MethodCallMessage)message);
        } else if (!(message instanceof MessageUndeliverableMessage)) {
            throw new UnexpectedMessageError(message);
        }
    }

    private AMessage attemptMethodCall(MethodCallMessage message) {
        AMessage reply;
        try {
            Object result = MethodCallUtilities.callInterface(this.getInvocationHandler(), message);
            reply = this.fCompressed ? new CompressedMethodResultMessage(result) : new MethodResultMessage(result);
        }
        catch (InvocationTargetException ite) {
            reply = new CheckedThrowableMessage(ite.getTargetException());
        }
        catch (Throwable t) {
            if (t instanceof RuntimeException || t instanceof Error) {
                String msg = MessageFormat.format("Exception: {0} calling method: {1}", t, message);
                if (this.getFeedbackChannel().isDebugEnabled(sModule)) {
                    this.getFeedbackChannel().debug(sModule, msg, t);
                } else {
                    this.getFeedbackChannel().error(sModule, msg);
                }
                reply = new UncheckedThrowableMessage(t);
            }
            reply = new CheckedThrowableMessage(t);
        }
        return reply;
    }
}

