/*
 * Decompiled with CFR 0.152.
 */
package com.wily.isengard.postofficehub.link.http.client;

import com.wily.isengard.util.parameter.CheckParameter;
import com.wily.util.StringUtils;
import com.wily.util.feedback.IModuleFeedbackChannel;
import com.wily.util.feedback.Module;
import com.wily.util.properties.IndexedProperties;
import java.io.IOException;
import java.net.InetAddress;
import java.net.UnknownHostException;

public class ProxyConfiguration {
    private static Module sModule = new Module("ProxyConfiguration");
    private final String fHostName;
    private final int fPort;
    private boolean fRequiresAuthentication;
    private String fUserName;
    private String fPassword;
    private String fRealm;

    public ProxyConfiguration(String hostName, int port) throws UnknownHostException {
        CheckParameter.notNull("Host Name", hostName);
        InetAddress.getByName(hostName);
        this.fHostName = hostName;
        this.fPort = port;
    }

    public static ProxyConfiguration newInstance(IndexedProperties properties, IModuleFeedbackChannel feedback) throws UnknownHostException {
        return ProxyConfiguration.newInstance(properties, feedback, sModule);
    }

    public static ProxyConfiguration newInstance(IndexedProperties properties, IModuleFeedbackChannel feedback, Module module) throws UnknownHostException {
        ProxyConfiguration config;
        block6: {
            config = null;
            String proxyHost = properties.getTrimmedProperty("transport.http.proxy.host");
            if (!StringUtils.isEmpty(proxyHost)) {
                feedback.verbose(sModule, "Using proxy server for http tunneling: " + proxyHost);
                String proxyPortString = properties.getTrimmedProperty("transport.http.proxy.port");
                if (!StringUtils.isEmpty(proxyPortString)) {
                    try {
                        int proxyPort = Integer.parseInt(proxyPortString);
                        feedback.verbose(sModule, "Using proxy server port: " + proxyPort);
                        config = new ProxyConfiguration(proxyHost, proxyPort);
                        String proxyUserName = properties.getTrimmedProperty("transport.http.proxy.username");
                        String proxyPassword = properties.getPasswordProperty("transport.http.proxy.password");
                        if (StringUtils.isEmpty(proxyUserName) || StringUtils.isEmpty(proxyPassword)) break block6;
                        String proxyRealm = properties.getTrimmedProperty("transport.http.proxy.realm");
                        if (StringUtils.isEmpty(proxyRealm)) {
                            feedback.verbose(sModule, "Configuring password authentication for proxy server.");
                            config.setAuthenticationCredentials(proxyUserName, proxyPassword);
                            break block6;
                        }
                        feedback.verbose(sModule, "Configuring password authentication for proxy server with realm: " + proxyRealm);
                        config.setAuthenticationCredentials(proxyUserName, proxyPassword, proxyRealm);
                    }
                    catch (NumberFormatException numberFormatException) {
                        feedback.verbose(sModule, "Failed to configure proxy server since the port is not an integer: " + proxyPortString);
                    }
                } else {
                    feedback.verbose(sModule, "Failed to configure proxy server since no port is specified.");
                }
            }
        }
        return config;
    }

    /*
     * Exception decompiling
     */
    public void pingProxy() throws IOException {
        /*
         * This method has failed to decompile.  When submitting a bug report, please provide this stack trace, and (if you hold appropriate legal rights) the relevant class file.
         * 
         * org.benf.cfr.reader.util.ConfusedCFRException: Back jump on a try block [egrp 2[TRYBLOCK] [1 : 42->46)] java.lang.Throwable
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op02WithProcessedDataAndRefs.insertExceptionBlocks(Op02WithProcessedDataAndRefs.java:2283)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisInner(CodeAnalyser.java:415)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisOrWrapFail(CodeAnalyser.java:278)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysis(CodeAnalyser.java:201)
         *     at org.benf.cfr.reader.entities.attributes.AttributeCode.analyse(AttributeCode.java:94)
         *     at org.benf.cfr.reader.entities.Method.analyse(Method.java:531)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseMid(ClassFile.java:1055)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseTop(ClassFile.java:942)
         *     at org.benf.cfr.reader.Driver.doJarVersionTypes(Driver.java:257)
         *     at org.benf.cfr.reader.Driver.doJar(Driver.java:139)
         *     at org.benf.cfr.reader.CfrDriverImpl.analyse(CfrDriverImpl.java:76)
         *     at org.benf.cfr.reader.Main.main(Main.java:54)
         */
        throw new IllegalStateException("Decompilation failed");
    }

    public String getHostName() {
        return this.fHostName;
    }

    public int getPort() {
        return this.fPort;
    }

    public void setAuthenticationCredentials(String userName, String password) {
        CheckParameter.notNull("User Name", userName);
        CheckParameter.notNull("Password", password);
        this.fUserName = userName;
        this.fPassword = password;
        this.fRequiresAuthentication = true;
    }

    public void setAuthenticationCredentials(String userName, String password, String realm) {
        CheckParameter.notNull("Realm", realm);
        this.setAuthenticationCredentials(userName, password);
        this.fRealm = realm;
    }

    public boolean requiresAuthentication() {
        return this.fRequiresAuthentication;
    }

    public String getUserName() {
        return this.fUserName;
    }

    public String getPassword() {
        return this.fPassword;
    }

    public String getRealm() {
        return this.fRealm;
    }
}

