/*
 * Decompiled with CFR 0.152.
 */
package com.wily.isengard.postofficehub.link.net;

import com.wily.isengard.IsengardException;
import com.wily.isengard.postofficehub.link.net.ASSLSocketFactory;
import com.wily.util.feedback.IModuleFeedbackChannel;
import com.wily.util.properties.IndexedProperties;
import java.io.IOException;
import java.net.InetAddress;
import java.net.Socket;
import java.net.UnknownHostException;
import javax.net.ssl.SSLSocket;

public class SSLSocketFactory
extends ASSLSocketFactory {
    public SSLSocketFactory(IndexedProperties properties, IModuleFeedbackChannel feedback) throws IsengardException {
        super(properties, feedback);
    }

    public Socket createSocket(String host, int port) throws IOException, UnknownHostException {
        String[] protocols;
        SSLSocket socket = (SSLSocket)this.getSSLContext().getSocketFactory().createSocket(host, port);
        String[] suites = this.getCipherSuites();
        if (suites.length > 0) {
            socket.setEnabledCipherSuites(suites);
        }
        if ((protocols = this.getProtocols()).length > 0) {
            socket.setEnabledProtocols(protocols);
        }
        return socket;
    }

    public Socket createSocket(String host, int port, InetAddress localHost, int localPort) throws IOException, UnknownHostException {
        String[] protocols;
        SSLSocket socket = (SSLSocket)this.getSSLContext().getSocketFactory().createSocket(host, port, localHost, localPort);
        String[] suites = this.getCipherSuites();
        if (suites.length > 0) {
            socket.setEnabledCipherSuites(suites);
        }
        if ((protocols = this.getProtocols()).length > 0) {
            socket.setEnabledProtocols(protocols);
        }
        return socket;
    }

    public Socket createSocket(InetAddress host, int port) throws IOException {
        String[] protocols;
        SSLSocket socket = (SSLSocket)this.getSSLContext().getSocketFactory().createSocket(host, port);
        String[] suites = this.getCipherSuites();
        if (suites.length > 0) {
            socket.setEnabledCipherSuites(suites);
        }
        if ((protocols = this.getProtocols()).length > 0) {
            socket.setEnabledProtocols(protocols);
        }
        return socket;
    }

    public Socket createSocket(InetAddress address, int port, InetAddress localAddress, int localPort) throws IOException {
        String[] protocols;
        SSLSocket socket = (SSLSocket)this.getSSLContext().getSocketFactory().createSocket(address, port, localAddress, localPort);
        String[] suites = this.getCipherSuites();
        if (suites.length > 0) {
            socket.setEnabledCipherSuites(suites);
        }
        if ((protocols = this.getProtocols()).length > 0) {
            socket.setEnabledProtocols(protocols);
        }
        return socket;
    }

    public String getSocketType() {
        return "ssl";
    }
}

