/*
 * Decompiled with CFR 0.152.
 */
package com.wily.util.adt;

import java.io.FilterWriter;
import java.io.IOException;
import java.io.Writer;

public final class NonSyncBufferedWriter
extends FilterWriter {
    private char[] fBuffer;
    private int fBufferIndex;

    public NonSyncBufferedWriter(Writer output) {
        this(output, 8192);
    }

    public NonSyncBufferedWriter(Writer output, int bufferSize) {
        super(output);
        this.fBuffer = new char[bufferSize];
    }

    public void close() throws IOException {
        this.checkWriter();
        if (this.fBufferIndex != 0) {
            this.flush();
        }
        this.out.close();
        this.out = null;
    }

    public void flush() throws IOException {
        this.checkWriter();
        if (this.fBufferIndex > 0) {
            this.out.write(this.fBuffer, 0, this.fBufferIndex);
            this.out.flush();
            this.fBufferIndex = 0;
        }
    }

    public void write(char[] cbuf, int off, int len) throws IOException {
        int toCopy;
        this.checkWriter();
        do {
            if (this.fBufferIndex == this.fBuffer.length) {
                this.flush();
            }
            toCopy = Math.min(len, this.fBuffer.length - this.fBufferIndex);
            System.arraycopy(cbuf, off, this.fBuffer, this.fBufferIndex, toCopy);
            off += toCopy;
            this.fBufferIndex += toCopy;
        } while ((len -= toCopy) > 0);
    }

    public void write(int c) throws IOException {
        this.checkWriter();
        if (this.fBufferIndex == this.fBuffer.length) {
            this.flush();
        }
        this.fBuffer[this.fBufferIndex++] = (char)c;
    }

    public void write(String str, int off, int len) throws IOException {
        int toCopy;
        this.checkWriter();
        do {
            if (this.fBufferIndex == this.fBuffer.length) {
                this.flush();
            }
            toCopy = Math.min(len, this.fBuffer.length - this.fBufferIndex);
            str.getChars(off, off + toCopy, this.fBuffer, this.fBufferIndex);
            off += toCopy;
            this.fBufferIndex += toCopy;
        } while ((len -= toCopy) > 0);
    }

    private void checkWriter() throws IOException {
        if (this.out == null) {
            throw new IOException("Writer may have been closed");
        }
    }
}

