/*
 * Decompiled with CFR 0.152.
 */
package com.wily.soaextension.tibcobw.correlation;

import com.wily.introscope.agent.IAgent;
import com.wily.introscope.agent.trace.InvocationData;
import com.wily.introscope.agent.trace.ProbeIdentification;
import com.wily.introscope.agent.transactiontrace.CorrelationId;
import com.wily.soaextension.tibcobw.BWObfuscationHelper;
import com.wily.soaextension.tibcobw.KConstants;
import com.wily.soaextension.tibcobw.TibcoBWUtils;
import com.wily.soaextension.tibcobw.TibcoReflectionCache;
import com.wily.soaextension.tibcobw.correlation.CorrelationTracer;
import com.wily.soaextension.tibcobw.multithread.blame.MultiBoundaryBlameStackFeature;
import com.wily.util.properties.AttributeListing;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import java.util.List;

public class SOAPServerCorrelationTracer
extends CorrelationTracer {
    private static final String C_expandName = "com.tibco.xml.data.primitive.ExpandedName";
    private static final String C_ContextUtils = "com.tibco.spin.utils.ContextUtils";
    private static final String C_SoapMessage = "com.tibco.xml.soap.api.SoapMessage";
    private static Class clazzExpandedName = null;
    private static Class clazzContextUtils = null;
    private static Class clazzSoapMessage = null;
    private static Object CorIDAttribute = null;

    public SOAPServerCorrelationTracer(IAgent agent, AttributeListing parameters, ProbeIdentification probe, Object sampleTracedObject) {
        super(agent, parameters, probe, sampleTracedObject);
    }

    public void printSOAPMessage(Object soapMessage, InvocationData data, String prependMsg) {
        try {
            Object soapMessageAsString = null;
            ClassLoader loader = data.getInvocationParameterAsObject(1).getClass().getClassLoader();
            if (BWObfuscationHelper.isContainer) {
                clazzContextUtils = Class.forName(C_ContextUtils, false, loader);
            } else if (clazzContextUtils == null) {
                clazzContextUtils = Class.forName(C_ContextUtils, false, loader);
            }
            if (BWObfuscationHelper.isContainer) {
                clazzSoapMessage = Class.forName(C_SoapMessage, false, loader);
            } else if (clazzSoapMessage == null) {
                clazzSoapMessage = Class.forName(C_SoapMessage, false, loader);
            }
            soapMessageAsString = TibcoBWUtils.invokeMethodOnClass(clazzContextUtils, KConstants.kM_ContextUtils_getSoapMessageAsString, new Class[]{clazzSoapMessage}, new Object[]{soapMessage});
            this.fLogger.debug(String.valueOf(prependMsg) + " " + soapMessageAsString);
        }
        catch (ClassNotFoundException bomb) {
            this.fLogger.error("printSOAPMessage :: ClassNotFoundException" + TibcoBWUtils.dumpStackTrace(bomb));
        }
        catch (SecurityException bomb) {
            this.fLogger.error("printSOAPMessage :: SecurityException" + TibcoBWUtils.dumpStackTrace(bomb));
        }
        catch (IllegalArgumentException bomb) {
            this.fLogger.error("printSOAPMessage :: IllegalArgumentException" + TibcoBWUtils.dumpStackTrace(bomb));
        }
        catch (NoSuchMethodException bomb) {
            this.fLogger.error("printSOAPMessage :: NoSuchMethodException" + TibcoBWUtils.dumpStackTrace(bomb));
        }
        catch (IllegalAccessException bomb) {
            this.fLogger.error("printSOAPMessage :: IllegalAccessException" + TibcoBWUtils.dumpStackTrace(bomb));
        }
        catch (InvocationTargetException bomb) {
            this.fLogger.error("printSOAPMessage :: InvocationTargetException" + bomb.getCause().getMessage());
        }
    }

    public void ITracer_startTrace(int tracerIndex, InvocationData data) {
        boolean debug = false;
        if (!TibcoBWUtils.correlationSOAPReadEnabled()) {
            return;
        }
        Object soapMessage = null;
        List soapHeaders = null;
        try {
            String correlationIdAsString = "";
            ClassLoader loader = data.getInvocationParameterAsObject(1).getClass().getClassLoader();
            if (BWObfuscationHelper.isContainer) {
                clazzExpandedName = Class.forName(C_expandName, false, loader);
            } else if (clazzExpandedName == null) {
                clazzExpandedName = Class.forName(C_expandName, false, loader);
            }
            if (BWObfuscationHelper.isContainer) {
                CorIDAttribute = TibcoBWUtils.invokeMethodOnClass(clazzExpandedName, KConstants.kM_ExpandedName_makeName, new Class[]{String.class}, new Object[]{"CorID"});
            } else if (CorIDAttribute == null) {
                CorIDAttribute = TibcoBWUtils.invokeMethodOnClass(clazzExpandedName, KConstants.kM_ExpandedName_makeName, new Class[]{String.class}, new Object[]{"CorID"});
            }
            soapMessage = data.getInvocationParameterAsObject(1);
            Method M_SoapMessage = TibcoReflectionCache.getM_SoapMessage_getSoapHeaderBlocks(soapMessage);
            Object soapHeadersObj = M_SoapMessage.invoke(soapMessage, KConstants.EMPTY_OBJECT_ARRAY);
            if (soapHeadersObj != null) {
                soapHeaders = (List)soapHeadersObj;
            }
            Object headerElement2 = null;
            Object xiNode = null;
            Object attribute = null;
            boolean hasCorId = false;
            debug = this.fLogger.isDebugEnabled();
            if (debug) {
                this.printSOAPMessage(soapMessage, data, "SOAP Message at server side Before Processing :");
            }
            if (soapHeaders.size() > 0) {
                for (Object headerElement2 : soapHeaders) {
                    xiNode = TibcoReflectionCache.getM_XinXmlElement_getElement(headerElement2);
                    attribute = TibcoReflectionCache.getM_XiNode_getAttribute(xiNode, new Class[]{clazzExpandedName}, new Object[]{CorIDAttribute});
                    if (attribute == null) continue;
                    Method M_Attribute = TibcoReflectionCache.getM_Attribute_getStringValue(attribute);
                    Object correlationIdObj = M_Attribute.invoke(attribute, KConstants.EMPTY_OBJECT_ARRAY);
                    if (correlationIdObj != null) {
                        correlationIdAsString = (String)correlationIdObj;
                    }
                    String prevCorID = this.getComponentTracer().getCrossProcessDataCache().getCorrelationID();
                    new CorrelationId(correlationIdAsString, true);
                    String newCorID = this.getComponentTracer().getCrossProcessDataCache().getCorrelationID();
                    if (TibcoBWUtils.isMBBSEnabled()) {
                        MultiBoundaryBlameStackFeature blameStackFeature = (MultiBoundaryBlameStackFeature)MultiBoundaryBlameStackFeature.instance.get();
                        blameStackFeature.updateCorrelationInfo(prevCorID, newCorID);
                    }
                    if (debug) {
                        this.fLogger.debug("SOAPServerCorrelationTracer ITracer_startTrace :: Override with new correlationId" + newCorID);
                    }
                    hasCorId = true;
                    break;
                }
                if (hasCorId) {
                    soapHeaders.remove(headerElement2);
                    if (debug) {
                        this.printSOAPMessage(soapMessage, data, "SOAP Message at server side After Processing : ");
                    }
                } else {
                    new CorrelationId();
                }
            }
        }
        catch (ClassNotFoundException bomb) {
            this.fLogger.error("SOAPServerCorrelationTracer :: ClassNotFoundException" + TibcoBWUtils.dumpStackTrace(bomb));
        }
        catch (SecurityException bomb) {
            this.fLogger.error("SOAPServerCorrelationTracer :: SecurityException" + TibcoBWUtils.dumpStackTrace(bomb));
        }
        catch (IllegalArgumentException bomb) {
            this.fLogger.error("SOAPServerCorrelationTracer :: IllegalArgumentException" + TibcoBWUtils.dumpStackTrace(bomb));
        }
        catch (NoSuchMethodException bomb) {
            this.fLogger.error("SOAPServerCorrelationTracer :: NoSuchMethodException" + TibcoBWUtils.dumpStackTrace(bomb));
        }
        catch (IllegalAccessException bomb) {
            this.fLogger.error("SOAPServerCorrelationTracer :: IllegalAccessException" + TibcoBWUtils.dumpStackTrace(bomb));
        }
        catch (InvocationTargetException bomb) {
            this.fLogger.error("SOAPServerCorrelationTracer :: InvocationTargetException" + bomb.getCause().getMessage());
        }
    }
}

