/*
 * Decompiled with CFR 0.152.
 */
package com.wily.soaextension.tibcobw.correlation;

import com.wily.introscope.agent.IAgent;
import com.wily.introscope.agent.trace.InvocationData;
import com.wily.introscope.agent.trace.ProbeIdentification;
import com.wily.introscope.agent.transactiontrace.CorrelationId;
import com.wily.introscope.agent.transactiontrace.SharedCrossProcessData;
import com.wily.introscope.agent.transactiontrace.ThreadCorrelationId;
import com.wily.introscope.spec.server.transactiontrace.GUIDGenerator;
import com.wily.soaextension.tibcobw.TibcoBWUtils;
import com.wily.soaextension.tibcobw.TibcoReflectionCache;
import com.wily.soaextension.tibcobw.correlation.CorrelationTracer;
import com.wily.util.properties.AttributeListing;
import java.util.HashMap;

public class SpawnedProcessCorrelationTracer
extends CorrelationTracer {
    private static GUIDGenerator sGuidGenerator = GUIDGenerator.getInstance();
    private SharedCrossProcessData cache = null;
    private String fTransactionIdentity;

    public SpawnedProcessCorrelationTracer(IAgent agent, AttributeListing parameters, ProbeIdentification probe, Object sampleTracedObject) {
        super(agent, parameters, probe, sampleTracedObject);
    }

    private HashMap getProcessContextMap(Object processContext) {
        HashMap ctxMap = null;
        try {
            ctxMap = (HashMap)TibcoReflectionCache.getF_Job_M(processContext).get(processContext);
        }
        catch (Exception e) {
            this.fLogger.error("SpawnedProcessCorrelationTracer::Error in getProcessContextMap :" + TibcoBWUtils.dumpStackTrace(e));
        }
        return ctxMap;
    }

    private void setCorInfoInParentProcess(Object parentContext) {
        HashMap<String, Object> ctxMap;
        Object correlationData = new Object();
        this.cache = this.getComponentTracer().getCrossProcessDataCache();
        String transactionId = this.cache.getStringParamOut("TxnTraceId");
        if (transactionId == null) {
            this.fTransactionIdentity = sGuidGenerator.generateKey();
            this.cache.addParamOut("TxnTraceId", this.fTransactionIdentity);
        }
        if ((ctxMap = this.getProcessContextMap(parentContext)) == null) {
            ctxMap = new HashMap<String, Object>();
        }
        new CorrelationId();
        SharedCrossProcessData cache = this.getComponentTracer().getCrossProcessDataCache();
        cache.markNextCrossProcessCallAsNonBlocking();
        correlationData = TibcoBWUtils.isSerializationEnabled() ? cache.getOutgoingSerializableInstance() : new ThreadCorrelationId().getOutgoingStringFromInstance();
        if (correlationData != null) {
            ctxMap.put("CorID", correlationData);
        }
        this.setProcessContextMap(parentContext, ctxMap);
    }

    private void setProcessContextMap(Object processContext, HashMap ctxMap) {
        try {
            TibcoReflectionCache.getF_Job_M(processContext).set(processContext, ctxMap);
        }
        catch (Exception e) {
            this.fLogger.debug("SpawnedProcessCorrelationTracer::Error in setProcessContextMap :" + e.toString());
        }
    }

    public void ITracer_finishTrace(int i, InvocationData data) {
        try {
            Object parentProcessContext = data.getInvocationObject();
            boolean debug = this.fLogger.isDebugEnabled();
            Object correlationData = new Object();
            this.setCorInfoInParentProcess(parentProcessContext);
            Object spawnedProcessContext = data.getInvocationReturnValueAsObject();
            HashMap parentCtxMap = this.getProcessContextMap(parentProcessContext);
            HashMap<String, Object> spawnedCtxMap = this.getProcessContextMap(spawnedProcessContext);
            if (parentCtxMap == null) {
                parentCtxMap = new HashMap();
            }
            if (spawnedCtxMap == null) {
                spawnedCtxMap = new HashMap<String, Object>();
            }
            if (parentCtxMap.containsKey("CorID")) {
                correlationData = TibcoBWUtils.isSerializationEnabled() ? (SharedCrossProcessData.SerializableSharedCrossProcessData)parentCtxMap.get("CorID") : (String)parentCtxMap.get("CorID");
                if (debug) {
                    this.fLogger.debug("Found Correlation ID from Parent Job:" + correlationData);
                }
                if (correlationData != null) {
                    spawnedCtxMap.put("CorID", correlationData);
                }
                this.setProcessContextMap(spawnedProcessContext, spawnedCtxMap);
                spawnedCtxMap.put("is_Spawned", "true");
            } else if (debug) {
                this.fLogger.debug("Could not set the Correlation Id in spawned job.");
            }
            data.IParameterizedMethodTracer_setReturnValue(spawnedProcessContext);
        }
        catch (Throwable throwable) {
            this.fLogger.debug("SpawnedProcessCorrelationTracer:ITracer_finishTrace : Error in correlation");
        }
        super.ITracer_finishTrace(i, data);
    }
}

